/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.meta.Attribute;
import io.requery.meta.EntityModel;
import io.requery.meta.Type;
import io.requery.query.Expression;
import io.requery.sql.Attributes;
import io.requery.sql.BoundParameters;
import io.requery.sql.GeneratedResultReader;
import io.requery.sql.RuntimeConfiguration;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

abstract class PreparedQueryOperation {
    final RuntimeConfiguration configuration;
    private final EntityModel model;
    private final GeneratedResultReader generatedResultReader;

    PreparedQueryOperation(RuntimeConfiguration configuration, GeneratedResultReader generatedResultReader) {
        this.configuration = configuration;
        this.generatedResultReader = generatedResultReader;
        this.model = configuration.getModel();
    }

    PreparedStatement prepare(String sql, Connection connection) throws SQLException {
        PreparedStatement statement;
        if (this.generatedResultReader != null) {
            if (this.configuration.getPlatform().supportsGeneratedColumnsInPrepareStatement()) {
                String[] generatedColumns = this.generatedResultReader.generatedColumns();
                statement = connection.prepareStatement(sql, generatedColumns);
            } else {
                statement = connection.prepareStatement(sql, 1);
            }
        } else {
            statement = connection.prepareStatement(sql, 2);
        }
        return statement;
    }

    void mapParameters(PreparedStatement statement, BoundParameters parameters2) throws SQLException {
        for (int i = 0; i < parameters2.count(); ++i) {
            Type<?> entityType;
            Attribute<?, ?> keyAttribute;
            Class<?> type2;
            Attribute attribute;
            Expression expression = parameters2.expressionAt(i);
            Object value = parameters2.valueAt(i);
            if (expression instanceof Attribute && (attribute = (Attribute)((Object)expression)).isAssociation()) {
                value = Attributes.replaceKeyReference(value, attribute);
            }
            Class<?> clazz = type2 = value == null ? null : value.getClass();
            if (type2 != null && this.model.containsTypeOf(type2) && (keyAttribute = (entityType = this.model.typeOf(type2)).getSingleKeyAttribute()) != null) {
                value = keyAttribute.getProperty().get(value);
                expression = (Expression)((Object)keyAttribute);
            }
            this.configuration.getMapping().write(expression, statement, i + 1, value);
        }
    }

    void readGeneratedKeys(int index, Statement statement) throws SQLException {
        if (this.generatedResultReader != null) {
            try (ResultSet results = statement.getGeneratedKeys();){
                this.generatedResultReader.read(index, results);
            }
        }
    }
}

