/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.sync;

import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.db.Item;
import eu.pretix.libpretixsync.db.Migrations;
import eu.pretix.libpretixsync.db.Question;
import eu.pretix.libpretixsync.sync.BaseConditionalSyncAdapter;
import eu.pretix.libpretixsync.sync.FileStorage;
import eu.pretix.libpretixsync.sync.SyncManager;
import eu.pretix.libpretixsync.utils.JSONUtils;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.meta.QueryAttribute;
import io.requery.query.Result;
import io.requery.query.Tuple;
import io.requery.query.WhereAndOr;
import io.requery.util.CloseableIterator;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class QuestionSyncAdapter
extends BaseConditionalSyncAdapter<Question, Long> {
    public QuestionSyncAdapter(BlockingEntityStore<Persistable> store, FileStorage fileStorage2, String eventSlug, PretixApi api, String syncCycleId, SyncManager.ProgressFeedback feedback) {
        super(store, fileStorage2, eventSlug, api, syncCycleId, feedback);
    }

    @Override
    public void updateObject(Question obj, JSONObject jsonobj) throws JSONException {
        obj.setEvent_slug(this.eventSlug);
        obj.setServer_id(jsonobj.getLong("id"));
        obj.setPosition(jsonobj.getLong("position"));
        obj.setRequired(jsonobj.optBoolean("required", false));
        obj.setJson_data(jsonobj.toString());
        JSONArray itemsarr = jsonobj.getJSONArray("items");
        ArrayList<Long> itemids = new ArrayList<Long>();
        for (int i = 0; i < itemsarr.length(); ++i) {
            itemids.add(itemsarr.getLong(i));
        }
        List items = ((Result)this.store.select(Item.class, new QueryAttribute[0]).where(Item.SERVER_ID.in(itemids)).get()).toList();
        for (Item item : items) {
            if (obj.getItems().contains(item)) continue;
            obj.getItems().add(item);
        }
        obj.getItems().retainAll(items);
    }

    @Override
    public CloseableIterator<Question> runBatch(List<Long> ids) {
        return ((Result)((WhereAndOr)this.store.select(Question.class, new QueryAttribute[0]).where(Question.EVENT_SLUG.eq((Object)this.eventSlug)).and(Question.SERVER_ID.in(ids))).get()).iterator();
    }

    @Override
    CloseableIterator<Tuple> getKnownIDsIterator() {
        return ((Result)this.store.select(Question.SERVER_ID).where(Question.EVENT_SLUG.eq((Object)this.eventSlug)).get()).iterator();
    }

    @Override
    String getResourceName() {
        return "questions";
    }

    @Override
    Long getId(JSONObject obj) throws JSONException {
        return obj.getLong("id");
    }

    @Override
    Long getId(Question obj) {
        return obj.getServer_id();
    }

    @Override
    Question newEmptyObject() {
        return new Question();
    }

    public void standaloneRefreshFromJSON(JSONObject data2) throws JSONException {
        Question obj = ((Result)this.store.select(Question.class, new QueryAttribute[0]).where(Question.SERVER_ID.eq((Object)data2.getLong("id"))).get()).firstOr(this.newEmptyObject());
        JSONObject old = null;
        if (obj.getId() != null) {
            old = obj.getJSON();
        }
        data2.put("__libpretixsync_dbversion", Migrations.CURRENT_VERSION);
        data2.put("__libpretixsync_syncCycleId", this.syncCycleId);
        if (old == null) {
            this.updateObject(obj, data2);
            this.store.insert(obj);
        } else if (!JSONUtils.similar(data2, (Object)old)) {
            this.updateObject(obj, data2);
            this.store.update(obj);
        }
    }
}

