/*
 * Decompiled with CFR 0.152.
 */
package java8.util.stream;

import java8.lang.Longs;
import java8.util.J8Arrays;
import java8.util.Objects;
import java8.util.Spliterators;
import java8.util.function.LongConsumer;
import java8.util.function.LongPredicate;
import java8.util.function.LongSupplier;
import java8.util.function.LongUnaryOperator;
import java8.util.stream.LongStream;
import java8.util.stream.StreamSpliterators;
import java8.util.stream.StreamSupport;
import java8.util.stream.Streams;

public final class LongStreams {
    public static LongStream.Builder builder() {
        return new Streams.LongStreamBuilderImpl();
    }

    public static LongStream empty() {
        return StreamSupport.longStream(Spliterators.emptyLongSpliterator(), false);
    }

    public static LongStream of(long t) {
        return StreamSupport.longStream(new Streams.LongStreamBuilderImpl(t), false);
    }

    public static LongStream of(long ... values2) {
        return J8Arrays.stream(values2);
    }

    public static LongStream iterate(final long seed, final LongUnaryOperator f) {
        Objects.requireNonNull(f);
        Spliterators.AbstractLongSpliterator spliterator = new Spliterators.AbstractLongSpliterator(Long.MAX_VALUE, 1296){
            long prev;
            boolean started;

            @Override
            public boolean tryAdvance(LongConsumer action) {
                long t;
                Objects.requireNonNull(action);
                if (this.started) {
                    t = f.applyAsLong(this.prev);
                } else {
                    t = seed;
                    this.started = true;
                }
                this.prev = t;
                action.accept(this.prev);
                return true;
            }
        };
        return StreamSupport.longStream(spliterator, false);
    }

    public static LongStream iterate(final long seed, final LongPredicate hasNext, final LongUnaryOperator next) {
        Objects.requireNonNull(next);
        Objects.requireNonNull(hasNext);
        Spliterators.AbstractLongSpliterator spliterator = new Spliterators.AbstractLongSpliterator(Long.MAX_VALUE, 1296){
            long prev;
            boolean started;
            boolean finished;

            @Override
            public boolean tryAdvance(LongConsumer action) {
                long t;
                Objects.requireNonNull(action);
                if (this.finished) {
                    return false;
                }
                if (this.started) {
                    t = next.applyAsLong(this.prev);
                } else {
                    t = seed;
                    this.started = true;
                }
                if (!hasNext.test(t)) {
                    this.finished = true;
                    return false;
                }
                this.prev = t;
                action.accept(this.prev);
                return true;
            }

            @Override
            public void forEachRemaining(LongConsumer action) {
                long t;
                Objects.requireNonNull(action);
                if (this.finished) {
                    return;
                }
                this.finished = true;
                long l = t = this.started ? next.applyAsLong(this.prev) : seed;
                while (hasNext.test(t)) {
                    action.accept(t);
                    t = next.applyAsLong(t);
                }
            }
        };
        return StreamSupport.longStream(spliterator, false);
    }

    public static LongStream generate(LongSupplier s2) {
        Objects.requireNonNull(s2);
        return StreamSupport.longStream(new StreamSpliterators.InfiniteSupplyingSpliterator.OfLong(Long.MAX_VALUE, s2), false);
    }

    public static LongStream range(long startInclusive, long endExclusive) {
        if (startInclusive >= endExclusive) {
            return LongStreams.empty();
        }
        if (endExclusive - startInclusive < 0L) {
            long m3 = startInclusive + Longs.divideUnsigned(endExclusive - startInclusive, 2L) + 1L;
            return LongStreams.concat(LongStreams.range(startInclusive, m3), LongStreams.range(m3, endExclusive));
        }
        return StreamSupport.longStream(new Streams.RangeLongSpliterator(startInclusive, endExclusive, false), false);
    }

    public static LongStream rangeClosed(long startInclusive, long endInclusive) {
        if (startInclusive > endInclusive) {
            return LongStreams.empty();
        }
        if (endInclusive - startInclusive + 1L <= 0L) {
            long m3 = startInclusive + Longs.divideUnsigned(endInclusive - startInclusive, 2L) + 1L;
            return LongStreams.concat(LongStreams.range(startInclusive, m3), LongStreams.rangeClosed(m3, endInclusive));
        }
        return StreamSupport.longStream(new Streams.RangeLongSpliterator(startInclusive, endInclusive, true), false);
    }

    public static LongStream concat(LongStream a, LongStream b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        Streams.ConcatSpliterator.OfLong split = new Streams.ConcatSpliterator.OfLong(a.spliterator(), b.spliterator());
        LongStream stream = StreamSupport.longStream(split, a.isParallel() || b.isParallel());
        return (LongStream)stream.onClose(Streams.composedClose(a, b));
    }

    private LongStreams() {
    }
}

