/*
 * Decompiled with CFR 0.152.
 */
package io.requery.reactor;

import io.requery.BlockingEntityStore;
import io.requery.EntityStore;
import io.requery.meta.Attribute;
import io.requery.meta.QueryAttribute;
import io.requery.query.Deletion;
import io.requery.query.Expression;
import io.requery.query.InsertInto;
import io.requery.query.Insertion;
import io.requery.query.Result;
import io.requery.query.Return;
import io.requery.query.Scalar;
import io.requery.query.Selection;
import io.requery.query.Tuple;
import io.requery.query.Update;
import io.requery.query.element.QueryElement;
import io.requery.reactor.ReactorQueryable;
import io.requery.reactor.ReactorResult;
import io.requery.reactor.ReactorScalar;
import io.requery.util.Objects;
import io.requery.util.function.Function;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.ParametersAreNonnullByDefault;
import reactor.core.publisher.Mono;

@ParametersAreNonnullByDefault
public class ReactorEntityStore<T>
implements EntityStore<T, Object>,
ReactorQueryable<T> {
    private final BlockingEntityStore<T> delegate;

    public ReactorEntityStore(BlockingEntityStore<T> delegate) {
        this.delegate = Objects.requireNotNull(delegate);
    }

    @Override
    public <E extends T> Mono<E> insert(final E entity) {
        return Mono.fromCallable((Callable)new Callable<E>(){

            @Override
            public E call() throws Exception {
                return ReactorEntityStore.this.delegate.insert(entity);
            }
        });
    }

    @Override
    public <E extends T> Mono<Iterable<E>> insert(final Iterable<E> entities) {
        return Mono.fromCallable((Callable)new Callable<Iterable<E>>(){

            @Override
            public Iterable<E> call() throws Exception {
                return ReactorEntityStore.this.delegate.insert(entities);
            }
        });
    }

    @Override
    public <K, E extends T> Mono<K> insert(final E entity, final Class<K> keyClass) {
        return Mono.fromCallable((Callable)new Callable<K>(){

            @Override
            public K call() throws Exception {
                return ReactorEntityStore.this.delegate.insert(entity, keyClass);
            }
        });
    }

    @Override
    public <K, E extends T> Mono<Iterable<K>> insert(final Iterable<E> entities, final Class<K> keyClass) {
        return Mono.fromCallable((Callable)new Callable<Iterable<K>>(){

            @Override
            public Iterable<K> call() throws Exception {
                return ReactorEntityStore.this.delegate.insert(entities, keyClass);
            }
        });
    }

    @Override
    public <E extends T> Mono<E> update(final E entity) {
        return Mono.fromCallable((Callable)new Callable<E>(){

            @Override
            public E call() throws Exception {
                return ReactorEntityStore.this.delegate.update(entity);
            }
        });
    }

    @Override
    public <E extends T> Mono<E> update(final E entity, final Attribute<?, ?> ... attributes) {
        return Mono.fromCallable((Callable)new Callable<E>(){

            @Override
            public E call() throws Exception {
                return ReactorEntityStore.this.delegate.update(entity, attributes);
            }
        });
    }

    @Override
    public <E extends T> Mono<Iterable<E>> update(final Iterable<E> entities) {
        return Mono.fromCallable((Callable)new Callable<Iterable<E>>(){

            @Override
            public Iterable<E> call() throws Exception {
                return ReactorEntityStore.this.delegate.update(entities);
            }
        });
    }

    @Override
    public <E extends T> Mono<E> upsert(final E entity) {
        return Mono.fromCallable((Callable)new Callable<E>(){

            @Override
            public E call() throws Exception {
                return ReactorEntityStore.this.delegate.upsert(entity);
            }
        });
    }

    @Override
    public <E extends T> Mono<Iterable<E>> upsert(final Iterable<E> entities) {
        return Mono.fromCallable((Callable)new Callable<Iterable<E>>(){

            @Override
            public Iterable<E> call() throws Exception {
                return ReactorEntityStore.this.delegate.upsert(entities);
            }
        });
    }

    @Override
    public <E extends T> Mono<E> refresh(final E entity) {
        return Mono.fromCallable((Callable)new Callable<E>(){

            @Override
            public E call() throws Exception {
                return ReactorEntityStore.this.delegate.refresh(entity);
            }
        });
    }

    @Override
    public <E extends T> Mono<E> refresh(final E entity, final Attribute<?, ?> ... attributes) {
        return Mono.fromCallable((Callable)new Callable<E>(){

            @Override
            public E call() throws Exception {
                return ReactorEntityStore.this.delegate.refresh(entity, attributes);
            }
        });
    }

    @Override
    public <E extends T> Mono<Iterable<E>> refresh(final Iterable<E> entities, final Attribute<?, ?> ... attributes) {
        return Mono.fromCallable((Callable)new Callable<Iterable<E>>(){

            @Override
            public Iterable<E> call() throws Exception {
                return ReactorEntityStore.this.delegate.refresh(entities, attributes);
            }
        });
    }

    @Override
    public <E extends T> Mono<E> refreshAll(final E entity) {
        return Mono.fromCallable((Callable)new Callable<E>(){

            @Override
            public E call() throws Exception {
                return ReactorEntityStore.this.delegate.refreshAll(entity);
            }
        });
    }

    @Override
    public <E extends T> Mono<Void> delete(final E entity) {
        return Mono.fromRunnable((Runnable)new Runnable(){

            @Override
            public void run() {
                ReactorEntityStore.this.delegate.delete(entity);
            }
        });
    }

    @Override
    public <E extends T> Mono<Void> delete(final Iterable<E> entities) {
        return Mono.fromRunnable((Runnable)new Runnable(){

            @Override
            public void run() {
                ReactorEntityStore.this.delegate.delete(entities);
            }
        });
    }

    @Override
    public <E extends T, K> Mono<E> findByKey(final Class<E> type2, final K key) {
        return Mono.fromCallable((Callable)new Callable<E>(){

            @Override
            public E call() throws Exception {
                return ReactorEntityStore.this.delegate.findByKey(type2, key);
            }
        });
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public Selection<ReactorResult<Tuple>> select(Expression<?> ... attributes) {
        return ReactorEntityStore.result(this.delegate.select(attributes));
    }

    @Override
    public Selection<ReactorResult<Tuple>> select(Set<? extends Expression<?>> expressions) {
        return ReactorEntityStore.result(this.delegate.select(expressions));
    }

    @Override
    public Update<ReactorScalar<Integer>> update() {
        return ReactorEntityStore.scalar(this.delegate.update());
    }

    @Override
    public Deletion<ReactorScalar<Integer>> delete() {
        return ReactorEntityStore.scalar(this.delegate.delete());
    }

    @Override
    public <E extends T> Selection<ReactorResult<E>> select(Class<E> type2, QueryAttribute<?, ?> ... attributes) {
        return ReactorEntityStore.result(this.delegate.select(type2, attributes));
    }

    @Override
    public <E extends T> Selection<ReactorResult<E>> select(Class<E> type2, Set<? extends QueryAttribute<E, ?>> attributes) {
        return ReactorEntityStore.result(this.delegate.select(type2, attributes));
    }

    @Override
    public <E extends T> Insertion<ReactorResult<Tuple>> insert(Class<E> type2) {
        return ReactorEntityStore.result(this.delegate.insert(type2));
    }

    @Override
    public <E extends T> InsertInto<ReactorResult<Tuple>> insert(Class<E> type2, QueryAttribute<?, ?> ... attributes) {
        return ReactorEntityStore.result(this.delegate.insert(type2, attributes));
    }

    @Override
    public <E extends T> Update<ReactorScalar<Integer>> update(Class<E> type2) {
        return ReactorEntityStore.scalar(this.delegate.update(type2));
    }

    @Override
    public <E extends T> Deletion<ReactorScalar<Integer>> delete(Class<E> type2) {
        return ReactorEntityStore.scalar(this.delegate.delete(type2));
    }

    @Override
    public <E extends T> Selection<ReactorScalar<Integer>> count(Class<E> type2) {
        return ReactorEntityStore.scalar(this.delegate.count(type2));
    }

    @Override
    public Selection<ReactorScalar<Integer>> count(QueryAttribute<?, ?> ... attributes) {
        return ReactorEntityStore.scalar(this.delegate.count(attributes));
    }

    @Override
    public ReactorResult<Tuple> raw(String query, Object ... parameters2) {
        return new ReactorResult<Tuple>(this.delegate.raw(query, parameters2));
    }

    @Override
    public <E extends T> ReactorResult<E> raw(Class<E> type2, String query, Object ... parameters2) {
        return new ReactorResult<E>(this.delegate.raw(type2, query, parameters2));
    }

    @Override
    public BlockingEntityStore<T> toBlocking() {
        return this.delegate;
    }

    private static <E> QueryElement<ReactorResult<E>> result(Return<? extends Result<E>> query) {
        QueryElement element = (QueryElement)query;
        return element.extend(new Function<Result<E>, ReactorResult<E>>(){

            @Override
            public ReactorResult<E> apply(Result<E> result2) {
                return new ReactorResult(result2);
            }
        });
    }

    private static <E> QueryElement<ReactorScalar<E>> scalar(Return<? extends Scalar<E>> query) {
        QueryElement element = (QueryElement)query;
        return element.extend(new Function<Scalar<E>, ReactorScalar<E>>(){

            @Override
            public ReactorScalar<E> apply(Scalar<E> result2) {
                return new ReactorScalar(result2);
            }
        });
    }
}

