/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.EntityCache;
import io.requery.Transaction;
import io.requery.TransactionException;
import io.requery.TransactionIsolation;
import io.requery.TransactionListener;
import io.requery.meta.Type;
import io.requery.proxy.EntityProxy;
import io.requery.sql.ConnectionProvider;
import io.requery.sql.EntityTransaction;
import io.requery.sql.TransactionEntitiesSet;
import io.requery.sql.UncloseableConnection;
import io.requery.util.Objects;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;

class ConnectionTransaction
implements EntityTransaction,
ConnectionProvider {
    private final ConnectionProvider connectionProvider;
    private final TransactionEntitiesSet entities;
    private final TransactionListener transactionListener;
    private final boolean supportsTransaction;
    private Connection connection;
    private Connection uncloseableConnection;
    private boolean committed;
    private boolean rolledBack;
    private int previousIsolationLevel;

    ConnectionTransaction(TransactionListener transactionListener, ConnectionProvider connectionProvider, EntityCache cache2, boolean supportsTransaction) {
        this.transactionListener = Objects.requireNotNull(transactionListener);
        this.connectionProvider = Objects.requireNotNull(connectionProvider);
        this.supportsTransaction = supportsTransaction;
        this.entities = new TransactionEntitiesSet(cache2);
        this.previousIsolationLevel = -1;
    }

    @Override
    public Connection getConnection() {
        return this.uncloseableConnection;
    }

    @Override
    public Transaction begin() {
        return this.begin(null);
    }

    @Override
    public Transaction begin(TransactionIsolation isolation) {
        if (this.active()) {
            throw new IllegalStateException("transaction already active");
        }
        try {
            this.transactionListener.beforeBegin(isolation);
            this.connection = this.connectionProvider.getConnection();
            this.uncloseableConnection = new UncloseableConnection(this.connection);
            if (this.supportsTransaction) {
                this.connection.setAutoCommit(false);
                if (isolation != null) {
                    int level;
                    this.previousIsolationLevel = this.connection.getTransactionIsolation();
                    switch (isolation) {
                        case NONE: {
                            level = 0;
                            break;
                        }
                        case READ_UNCOMMITTED: {
                            level = 1;
                            break;
                        }
                        case READ_COMMITTED: {
                            level = 2;
                            break;
                        }
                        case REPEATABLE_READ: {
                            level = 4;
                            break;
                        }
                        case SERIALIZABLE: {
                            level = 8;
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException();
                        }
                    }
                    this.connection.setTransactionIsolation(level);
                }
            }
            this.committed = false;
            this.rolledBack = false;
            this.entities.clear();
            this.transactionListener.afterBegin(isolation);
        }
        catch (SQLException e) {
            throw new TransactionException(e);
        }
        return this;
    }

    @Override
    public void close() {
        if (this.connection != null) {
            if (!this.committed && !this.rolledBack) {
                try {
                    this.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                throw new TransactionException(e);
            }
            finally {
                this.connection = null;
            }
        }
    }

    @Override
    public void commit() {
        try {
            this.transactionListener.beforeCommit(this.entities.types());
            if (this.supportsTransaction) {
                this.connection.commit();
                this.committed = true;
            }
            this.transactionListener.afterCommit(this.entities.types());
            this.entities.clear();
        }
        catch (SQLException e) {
            throw new TransactionException(e);
        }
        finally {
            this.resetConnection();
            this.close();
        }
    }

    @Override
    public void rollback() {
        try {
            this.transactionListener.beforeRollback(this.entities.types());
            if (this.supportsTransaction) {
                this.connection.rollback();
                this.rolledBack = true;
                this.entities.clearAndInvalidate();
            }
            this.transactionListener.afterRollback(this.entities.types());
            this.entities.clear();
        }
        catch (SQLException e) {
            throw new TransactionException(e);
        }
        finally {
            this.resetConnection();
        }
    }

    @Override
    public boolean active() {
        try {
            return this.connection != null && !this.connection.getAutoCommit();
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public void addToTransaction(EntityProxy<?> proxy) {
        this.entities.add(proxy);
    }

    @Override
    public void addToTransaction(Collection<Type<?>> types) {
        this.entities.types().addAll(types);
    }

    private void resetConnection() {
        if (this.supportsTransaction) {
            try {
                this.connection.setAutoCommit(true);
                if (this.previousIsolationLevel != -1) {
                    this.connection.setTransactionIsolation(this.previousIsolationLevel);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

