/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.utils;

import java.net.IDN;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\tR\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0019\u0010\u000e\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0015"}, d2={"Leu/pretix/libpretixsync/utils/EmailValidator;", "", "()V", "DOMAIN_REGEX", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getDOMAIN_REGEX", "()Ljava/util/regex/Pattern;", "DOT_ATOM", "", "getDOT_ATOM", "()Ljava/lang/String;", "QUOTED_STRING", "getQUOTED_STRING", "USER_REGEX", "getUSER_REGEX", "isValidEmail", "", "value", "validateDomainPart", "domainPart", "libpretixsync"})
public final class EmailValidator {
    @NotNull
    private final String DOT_ATOM;
    @NotNull
    private final String QUOTED_STRING;
    private final Pattern USER_REGEX;
    private final Pattern DOMAIN_REGEX;

    public EmailValidator() {
        this.DOT_ATOM = "^[-!#\\$%&'*+/=?^_`{}|~0-9A-Z]+(\\.[-!#\\$%&'*+/=?^_`{}|~0-9A-Z]+)*\\Z";
        this.QUOTED_STRING = "^\"([\\001-\\010\\013\\014\\016-\\037!#-\\[\\]-\\0177]|\\\\[\\001-\\011\\013\\014\\016-\\0177])*\"\\Z";
        this.USER_REGEX = Pattern.compile('(' + this.DOT_ATOM + '|' + this.QUOTED_STRING + ')', 2);
        this.DOMAIN_REGEX = Pattern.compile("((?:[A-Z0-9](?:[A-Z0-9-]{0,61}[A-Z0-9])?\\.)+)(?:[A-Z0-9-]{2,63}(?<!-))\\Z", 2);
    }

    @NotNull
    public final String getDOT_ATOM() {
        return this.DOT_ATOM;
    }

    @NotNull
    public final String getQUOTED_STRING() {
        return this.QUOTED_STRING;
    }

    public final Pattern getUSER_REGEX() {
        return this.USER_REGEX;
    }

    public final Pattern getDOMAIN_REGEX() {
        return this.DOMAIN_REGEX;
    }

    public final boolean isValidEmail(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (StringsKt.isBlank(value) || !StringsKt.contains$default((CharSequence)value, "@", false, 2, null) || value.length() > 320) {
            return false;
        }
        String userPart = StringsKt.substringBeforeLast$default(value, "@", null, 2, null);
        String domainPart = StringsKt.substringAfterLast$default(value, "@", null, 2, null);
        if (!this.USER_REGEX.matcher(userPart).matches()) {
            return false;
        }
        if (!this.validateDomainPart(domainPart)) {
            try {
                String asciiDomainPart = IDN.toASCII(domainPart);
                Intrinsics.checkNotNullExpressionValue(asciiDomainPart, "asciiDomainPart");
                if (this.validateDomainPart(asciiDomainPart)) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public final boolean validateDomainPart(@NotNull String domainPart) {
        Intrinsics.checkNotNullParameter(domainPart, "domainPart");
        return this.DOMAIN_REGEX.matcher(domainPart).matches();
    }
}

