/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.cache;

import io.micrometer.common.lang.NonNullApi;
import io.micrometer.common.lang.NonNullFields;
import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.cache.CacheMeterBinder;
import io.micrometer.core.instrument.binder.cache.HazelcastIMapAdapter;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

@NonNullApi
@NonNullFields
public class HazelcastCacheMetrics
extends CacheMeterBinder<Object> {
    private static final String DESCRIPTION_CACHE_ENTRIES = "The number of entries held by this member";
    private static final String DESCRIPTION_CACHE_ENTRY_MEMORY = "Memory cost of entries held by this member";
    private static final String DESCRIPTION_CACHE_NEAR_REQUESTS = "The number of requests (hits or misses) of near cache entries owned by this member";
    private final HazelcastIMapAdapter cache;

    public static Object monitor(MeterRegistry registry, Object cache2, String ... tags) {
        return HazelcastCacheMetrics.monitor(registry, cache2, Tags.of(tags));
    }

    public static Object monitor(MeterRegistry registry, Object cache2, Iterable<Tag> tags) {
        new HazelcastCacheMetrics(cache2, tags).bindTo(registry);
        return cache2;
    }

    public HazelcastCacheMetrics(Object cache2, Iterable<Tag> tags) {
        super(cache2, HazelcastIMapAdapter.nameOf(cache2), tags);
        this.cache = new HazelcastIMapAdapter(cache2);
    }

    @Override
    protected Long size() {
        HazelcastIMapAdapter.LocalMapStats localMapStats = this.cache.getLocalMapStats();
        if (localMapStats != null) {
            return localMapStats.getOwnedEntryCount();
        }
        return null;
    }

    @Override
    protected long hitCount() {
        HazelcastIMapAdapter.LocalMapStats localMapStats = this.cache.getLocalMapStats();
        if (localMapStats != null) {
            return localMapStats.getHits();
        }
        return 0L;
    }

    @Override
    protected Long missCount() {
        return null;
    }

    @Override
    @Nullable
    protected Long evictionCount() {
        return null;
    }

    @Override
    protected long putCount() {
        HazelcastIMapAdapter.LocalMapStats localMapStats = this.cache.getLocalMapStats();
        if (localMapStats != null) {
            return localMapStats.getPutOperationCount();
        }
        return 0L;
    }

    @Override
    protected void bindImplementationSpecificMetrics(MeterRegistry registry) {
        Gauge.builder("cache.entries", this.cache, cache2 -> this.getDouble(cache2.getLocalMapStats(), HazelcastIMapAdapter.LocalMapStats::getBackupEntryCount)).tags(this.getTagsWithCacheName()).tag("ownership", "backup").description(DESCRIPTION_CACHE_ENTRIES).register(registry);
        Gauge.builder("cache.entries", this.cache, cache2 -> this.getDouble(cache2.getLocalMapStats(), HazelcastIMapAdapter.LocalMapStats::getOwnedEntryCount)).tags(this.getTagsWithCacheName()).tag("ownership", "owned").description(DESCRIPTION_CACHE_ENTRIES).register(registry);
        Gauge.builder("cache.entry.memory", this.cache, cache2 -> this.getDouble(cache2.getLocalMapStats(), HazelcastIMapAdapter.LocalMapStats::getBackupEntryMemoryCost)).tags(this.getTagsWithCacheName()).tag("ownership", "backup").description(DESCRIPTION_CACHE_ENTRY_MEMORY).baseUnit("bytes").register(registry);
        Gauge.builder("cache.entry.memory", this.cache, cache2 -> this.getDouble(cache2.getLocalMapStats(), HazelcastIMapAdapter.LocalMapStats::getOwnedEntryMemoryCost)).tags(this.getTagsWithCacheName()).tag("ownership", "owned").description(DESCRIPTION_CACHE_ENTRY_MEMORY).baseUnit("bytes").register(registry);
        FunctionCounter.builder("cache.partition.gets", this.cache, cache2 -> this.getDouble(cache2.getLocalMapStats(), HazelcastIMapAdapter.LocalMapStats::getGetOperationCount)).tags(this.getTagsWithCacheName()).description("The total number of get operations executed against this partition").register(registry);
        this.timings(registry);
        this.nearCacheMetrics(registry);
    }

    private double getDouble(HazelcastIMapAdapter.LocalMapStats localMapStats, ToDoubleFunction<HazelcastIMapAdapter.LocalMapStats> function2) {
        return localMapStats != null ? function2.applyAsDouble(localMapStats) : Double.NaN;
    }

    private void nearCacheMetrics(MeterRegistry registry) {
        HazelcastIMapAdapter.LocalMapStats localMapStats = this.cache.getLocalMapStats();
        if (localMapStats != null && localMapStats.getNearCacheStats() != null) {
            Gauge.builder("cache.near.requests", this.cache, cache2 -> this.getDouble(cache2.getLocalMapStats(), stats -> stats.getNearCacheStats().getHits())).tags(this.getTagsWithCacheName()).tag("result", "hit").description(DESCRIPTION_CACHE_NEAR_REQUESTS).register(registry);
            Gauge.builder("cache.near.requests", this.cache, cache2 -> this.getDouble(cache2.getLocalMapStats(), stats -> stats.getNearCacheStats().getMisses())).tags(this.getTagsWithCacheName()).tag("result", "miss").description(DESCRIPTION_CACHE_NEAR_REQUESTS).register(registry);
            Gauge.builder("cache.near.evictions", this.cache, cache2 -> this.getDouble(cache2.getLocalMapStats(), stats -> stats.getNearCacheStats().getEvictions())).tags(this.getTagsWithCacheName()).description("The number of evictions of near cache entries owned by this member").register(registry);
            Gauge.builder("cache.near.persistences", this.cache, cache2 -> this.getDouble(cache2.getLocalMapStats(), stats -> stats.getNearCacheStats().getPersistenceCount())).tags(this.getTagsWithCacheName()).description("The number of near cache key persistences (when the pre-load feature is enabled)").register(registry);
        }
    }

    private void timings(MeterRegistry registry) {
        FunctionTimer.builder("cache.gets.latency", this.cache, cache2 -> this.getLong(cache2.getLocalMapStats(), HazelcastIMapAdapter.LocalMapStats::getGetOperationCount), cache2 -> this.getDouble(cache2.getLocalMapStats(), HazelcastIMapAdapter.LocalMapStats::getTotalGetLatency), TimeUnit.MILLISECONDS).tags(this.getTagsWithCacheName()).description("Cache gets").register(registry);
        FunctionTimer.builder("cache.puts.latency", this.cache, cache2 -> this.getLong(cache2.getLocalMapStats(), HazelcastIMapAdapter.LocalMapStats::getPutOperationCount), cache2 -> this.getDouble(cache2.getLocalMapStats(), HazelcastIMapAdapter.LocalMapStats::getTotalPutLatency), TimeUnit.MILLISECONDS).tags(this.getTagsWithCacheName()).description("Cache puts").register(registry);
        FunctionTimer.builder("cache.removals.latency", this.cache, cache2 -> this.getLong(cache2.getLocalMapStats(), HazelcastIMapAdapter.LocalMapStats::getRemoveOperationCount), cache2 -> this.getDouble(cache2.getLocalMapStats(), HazelcastIMapAdapter.LocalMapStats::getTotalRemoveLatency), TimeUnit.MILLISECONDS).tags(this.getTagsWithCacheName()).description("Cache removals").register(registry);
    }

    private long getLong(HazelcastIMapAdapter.LocalMapStats localMapStats, ToLongFunction<HazelcastIMapAdapter.LocalMapStats> function2) {
        return localMapStats != null ? function2.applyAsLong(localMapStats) : 0L;
    }
}

