/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql.gen;

import io.requery.query.Expression;
import io.requery.query.ExpressionType;
import io.requery.query.Order;
import io.requery.query.OrderingExpression;
import io.requery.query.element.OrderByElement;
import io.requery.sql.Keyword;
import io.requery.sql.QueryBuilder;
import io.requery.sql.gen.Generator;
import io.requery.sql.gen.Output;
import java.util.Set;

public class OrderByGenerator
implements Generator<OrderByElement> {
    @Override
    public void write(Output output, OrderByElement query) {
        Set<Expression<?>> orderBy = query.getOrderByExpressions();
        if (orderBy != null && orderBy.size() > 0) {
            QueryBuilder qb = output.builder();
            qb.keyword(Keyword.ORDER, Keyword.BY);
            int i = 0;
            int size = orderBy.size();
            for (Expression<?> order : orderBy) {
                if (order.getExpressionType() == ExpressionType.ORDERING) {
                    OrderingExpression ordering = (OrderingExpression)order;
                    output.appendColumn(ordering.getInnerExpression());
                    qb.keyword(ordering.getOrder() == Order.ASC ? Keyword.ASC : Keyword.DESC);
                    if (ordering.getNullOrder() != null) {
                        qb.keyword(Keyword.NULLS);
                        switch (ordering.getNullOrder()) {
                            case FIRST: {
                                qb.keyword(Keyword.FIRST);
                                break;
                            }
                            case LAST: {
                                qb.keyword(Keyword.LAST);
                            }
                        }
                    }
                } else {
                    output.appendColumn(order);
                }
                if (i < size - 1) {
                    qb.append(",");
                }
                ++i;
            }
        }
    }
}

