/*
 * Decompiled with CFR 0.152.
 */
package java8.util.concurrent;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.Comparator;
import java.util.Random;
import java8.util.Objects;
import java8.util.Spliterator;
import java8.util.Spliterators;
import java8.util.concurrent.TLRandom;
import java8.util.function.Consumer;
import java8.util.function.DoubleConsumer;
import java8.util.function.IntConsumer;
import java8.util.function.LongConsumer;
import java8.util.stream.DoubleStream;
import java8.util.stream.IntStream;
import java8.util.stream.LongStream;
import java8.util.stream.StreamSupport;

public class ThreadLocalRandom
extends Random {
    private boolean initialized = true;
    private static final long serialVersionUID = 9123313859120073139L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("rnd", Long.TYPE), new ObjectStreamField("initialized", Boolean.TYPE)};
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    private static final float FLOAT_UNIT = 5.9604645E-8f;
    private static final String BAD_BOUND = "bound must be positive";
    private static final String BAD_RANGE = "bound must be greater than origin";
    private static final String BAD_SIZE = "size must be non-negative";
    private static final ThreadLocal<Double> nextLocalGaussian = new ThreadLocal();
    private static final ThreadLocalRandom instance = new ThreadLocalRandom();

    private ThreadLocalRandom() {
    }

    public static ThreadLocalRandom current() {
        if (TLRandom.getThreadLocalRandomProbe() == 0) {
            TLRandom.localInit();
        }
        return instance;
    }

    @Override
    public void setSeed(long seed) {
        if (this.initialized) {
            throw new UnsupportedOperationException();
        }
    }

    private final long nextSeed() {
        return TLRandom.nextSeed();
    }

    final long internalNextLong(long origin, long bound) {
        long r = TLRandom.mix64(this.nextSeed());
        if (origin < bound) {
            long n = bound - origin;
            long m3 = n - 1L;
            if ((n & m3) == 0L) {
                r = (r & m3) + origin;
            } else if (n > 0L) {
                long u = r >>> 1;
                while (u + m3 - (r = u % n) < 0L) {
                    u = TLRandom.mix64(this.nextSeed()) >>> 1;
                }
                r += origin;
            } else {
                while (r < origin || r >= bound) {
                    r = TLRandom.mix64(this.nextSeed());
                }
            }
        }
        return r;
    }

    final int internalNextInt(int origin, int bound) {
        int r = TLRandom.mix32(this.nextSeed());
        if (origin < bound) {
            int n = bound - origin;
            int m3 = n - 1;
            if ((n & m3) == 0) {
                r = (r & m3) + origin;
            } else if (n > 0) {
                int u = r >>> 1;
                while (u + m3 - (r = u % n) < 0) {
                    u = TLRandom.mix32(this.nextSeed()) >>> 1;
                }
                r += origin;
            } else {
                while (r < origin || r >= bound) {
                    r = TLRandom.mix32(this.nextSeed());
                }
            }
        }
        return r;
    }

    final double internalNextDouble(double origin, double bound) {
        double r = (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
        if (origin < bound && (r = r * (bound - origin) + origin) >= bound) {
            r = Double.longBitsToDouble(Double.doubleToLongBits(bound) - 1L);
        }
        return r;
    }

    @Override
    public int nextInt() {
        return TLRandom.mix32(this.nextSeed());
    }

    @Override
    public int nextInt(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException(BAD_BOUND);
        }
        int r = TLRandom.mix32(this.nextSeed());
        int m3 = bound - 1;
        if ((bound & m3) == 0) {
            r &= m3;
        } else {
            int u = r >>> 1;
            while (u + m3 - (r = u % bound) < 0) {
                u = TLRandom.mix32(this.nextSeed()) >>> 1;
            }
        }
        return r;
    }

    @Override
    public int nextInt(int origin, int bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException(BAD_RANGE);
        }
        return this.internalNextInt(origin, bound);
    }

    @Override
    public long nextLong() {
        return TLRandom.mix64(this.nextSeed());
    }

    @Override
    public long nextLong(long bound) {
        if (bound <= 0L) {
            throw new IllegalArgumentException(BAD_BOUND);
        }
        long r = TLRandom.mix64(this.nextSeed());
        long m3 = bound - 1L;
        if ((bound & m3) == 0L) {
            r &= m3;
        } else {
            long u = r >>> 1;
            while (u + m3 - (r = u % bound) < 0L) {
                u = TLRandom.mix64(this.nextSeed()) >>> 1;
            }
        }
        return r;
    }

    @Override
    public long nextLong(long origin, long bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException(BAD_RANGE);
        }
        return this.internalNextLong(origin, bound);
    }

    @Override
    public double nextDouble() {
        return (double)(TLRandom.mix64(this.nextSeed()) >>> 11) * (double)1.110223E-16f;
    }

    @Override
    public double nextDouble(double bound) {
        if (!(bound > 0.0)) {
            throw new IllegalArgumentException(BAD_BOUND);
        }
        double result2 = (double)(TLRandom.mix64(this.nextSeed()) >>> 11) * (double)1.110223E-16f * bound;
        return result2 < bound ? result2 : Double.longBitsToDouble(Double.doubleToLongBits(bound) - 1L);
    }

    @Override
    public double nextDouble(double origin, double bound) {
        if (!(origin < bound)) {
            throw new IllegalArgumentException(BAD_RANGE);
        }
        return this.internalNextDouble(origin, bound);
    }

    @Override
    public boolean nextBoolean() {
        return TLRandom.mix32(this.nextSeed()) < 0;
    }

    @Override
    public float nextFloat() {
        return (float)(TLRandom.mix32(this.nextSeed()) >>> 8) * 5.9604645E-8f;
    }

    @Override
    public double nextGaussian() {
        double v2;
        double v1;
        double s2;
        Double d = nextLocalGaussian.get();
        if (d != null) {
            nextLocalGaussian.set(null);
            return d;
        }
        while ((s2 = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s2 == 0.0) {
        }
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s2) / s2);
        nextLocalGaussian.set(v2 * multiplier);
        return v1 * multiplier;
    }

    public IntStream ints(long streamSize) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException(BAD_SIZE);
        }
        return StreamSupport.intStream(new RandomIntsSpliterator(0L, streamSize, Integer.MAX_VALUE, 0), false);
    }

    public IntStream ints() {
        return StreamSupport.intStream(new RandomIntsSpliterator(0L, Long.MAX_VALUE, Integer.MAX_VALUE, 0), false);
    }

    public IntStream ints(long streamSize, int randomNumberOrigin, int randomNumberBound) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException(BAD_SIZE);
        }
        if (randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException(BAD_RANGE);
        }
        return StreamSupport.intStream(new RandomIntsSpliterator(0L, streamSize, randomNumberOrigin, randomNumberBound), false);
    }

    public IntStream ints(int randomNumberOrigin, int randomNumberBound) {
        if (randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException(BAD_RANGE);
        }
        return StreamSupport.intStream(new RandomIntsSpliterator(0L, Long.MAX_VALUE, randomNumberOrigin, randomNumberBound), false);
    }

    public LongStream longs(long streamSize) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException(BAD_SIZE);
        }
        return StreamSupport.longStream(new RandomLongsSpliterator(0L, streamSize, Long.MAX_VALUE, 0L), false);
    }

    public LongStream longs() {
        return StreamSupport.longStream(new RandomLongsSpliterator(0L, Long.MAX_VALUE, Long.MAX_VALUE, 0L), false);
    }

    public LongStream longs(long streamSize, long randomNumberOrigin, long randomNumberBound) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException(BAD_SIZE);
        }
        if (randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException(BAD_RANGE);
        }
        return StreamSupport.longStream(new RandomLongsSpliterator(0L, streamSize, randomNumberOrigin, randomNumberBound), false);
    }

    public LongStream longs(long randomNumberOrigin, long randomNumberBound) {
        if (randomNumberOrigin >= randomNumberBound) {
            throw new IllegalArgumentException(BAD_RANGE);
        }
        return StreamSupport.longStream(new RandomLongsSpliterator(0L, Long.MAX_VALUE, randomNumberOrigin, randomNumberBound), false);
    }

    public DoubleStream doubles(long streamSize) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException(BAD_SIZE);
        }
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(0L, streamSize, Double.MAX_VALUE, 0.0), false);
    }

    public DoubleStream doubles() {
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(0L, Long.MAX_VALUE, Double.MAX_VALUE, 0.0), false);
    }

    public DoubleStream doubles(long streamSize, double randomNumberOrigin, double randomNumberBound) {
        if (streamSize < 0L) {
            throw new IllegalArgumentException(BAD_SIZE);
        }
        if (!(randomNumberOrigin < randomNumberBound)) {
            throw new IllegalArgumentException(BAD_RANGE);
        }
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(0L, streamSize, randomNumberOrigin, randomNumberBound), false);
    }

    public DoubleStream doubles(double randomNumberOrigin, double randomNumberBound) {
        if (!(randomNumberOrigin < randomNumberBound)) {
            throw new IllegalArgumentException(BAD_RANGE);
        }
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(0L, Long.MAX_VALUE, randomNumberOrigin, randomNumberBound), false);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        ObjectOutputStream.PutField fields2 = s2.putFields();
        fields2.put("rnd", TLRandom.getThreadLocalRandomSeed());
        fields2.put("initialized", true);
        s2.writeFields();
    }

    private Object readResolve() {
        return ThreadLocalRandom.current();
    }

    private static final class RandomDoublesSpliterator
    implements Spliterator.OfDouble {
        long index;
        final long fence;
        final double origin;
        final double bound;

        RandomDoublesSpliterator(long index, long fence, double origin, double bound) {
            this.index = index;
            this.fence = fence;
            this.origin = origin;
            this.bound = bound;
        }

        @Override
        public RandomDoublesSpliterator trySplit() {
            RandomDoublesSpliterator randomDoublesSpliterator;
            long i = this.index;
            long m3 = i + this.fence >>> 1;
            if (m3 <= i) {
                randomDoublesSpliterator = null;
            } else {
                this.index = m3;
                RandomDoublesSpliterator randomDoublesSpliterator2 = new RandomDoublesSpliterator(i, this.index, this.origin, this.bound);
                randomDoublesSpliterator = randomDoublesSpliterator2;
            }
            return randomDoublesSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public long getExactSizeIfKnown() {
            return Spliterators.getExactSizeIfKnown(this);
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return Spliterators.hasCharacteristics(this, characteristics);
        }

        @Override
        public Comparator<? super Double> getComparator() {
            return Spliterators.getComparator(this);
        }

        @Override
        public boolean tryAdvance(DoubleConsumer consumer) {
            Objects.requireNonNull(consumer);
            long i = this.index;
            long f = this.fence;
            if (i < f) {
                consumer.accept(ThreadLocalRandom.current().internalNextDouble(this.origin, this.bound));
                this.index = i + 1L;
                return true;
            }
            return false;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Double> action) {
            return Spliterators.OfDouble.tryAdvance(this, action);
        }

        @Override
        public void forEachRemaining(DoubleConsumer consumer) {
            Objects.requireNonNull(consumer);
            long i = this.index;
            long f = this.fence;
            if (i < f) {
                this.index = f;
                double o = this.origin;
                double b = this.bound;
                ThreadLocalRandom rng = ThreadLocalRandom.current();
                do {
                    consumer.accept(rng.internalNextDouble(o, b));
                } while (++i < f);
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super Double> action) {
            Spliterators.OfDouble.forEachRemaining((Spliterator.OfDouble)this, action);
        }
    }

    private static final class RandomLongsSpliterator
    implements Spliterator.OfLong {
        long index;
        final long fence;
        final long origin;
        final long bound;

        RandomLongsSpliterator(long index, long fence, long origin, long bound) {
            this.index = index;
            this.fence = fence;
            this.origin = origin;
            this.bound = bound;
        }

        @Override
        public RandomLongsSpliterator trySplit() {
            RandomLongsSpliterator randomLongsSpliterator;
            long i = this.index;
            long m3 = i + this.fence >>> 1;
            if (m3 <= i) {
                randomLongsSpliterator = null;
            } else {
                this.index = m3;
                RandomLongsSpliterator randomLongsSpliterator2 = new RandomLongsSpliterator(i, this.index, this.origin, this.bound);
                randomLongsSpliterator = randomLongsSpliterator2;
            }
            return randomLongsSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public long getExactSizeIfKnown() {
            return Spliterators.getExactSizeIfKnown(this);
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return Spliterators.hasCharacteristics(this, characteristics);
        }

        @Override
        public Comparator<? super Long> getComparator() {
            return Spliterators.getComparator(this);
        }

        @Override
        public boolean tryAdvance(LongConsumer consumer) {
            Objects.requireNonNull(consumer);
            long i = this.index;
            long f = this.fence;
            if (i < f) {
                consumer.accept(ThreadLocalRandom.current().internalNextLong(this.origin, this.bound));
                this.index = i + 1L;
                return true;
            }
            return false;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Long> action) {
            return Spliterators.OfLong.tryAdvance(this, action);
        }

        @Override
        public void forEachRemaining(LongConsumer consumer) {
            Objects.requireNonNull(consumer);
            long i = this.index;
            long f = this.fence;
            if (i < f) {
                this.index = f;
                long o = this.origin;
                long b = this.bound;
                ThreadLocalRandom rng = ThreadLocalRandom.current();
                do {
                    consumer.accept(rng.internalNextLong(o, b));
                } while (++i < f);
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super Long> action) {
            Spliterators.OfLong.forEachRemaining((Spliterator.OfLong)this, action);
        }
    }

    private static final class RandomIntsSpliterator
    implements Spliterator.OfInt {
        long index;
        final long fence;
        final int origin;
        final int bound;

        RandomIntsSpliterator(long index, long fence, int origin, int bound) {
            this.index = index;
            this.fence = fence;
            this.origin = origin;
            this.bound = bound;
        }

        @Override
        public RandomIntsSpliterator trySplit() {
            RandomIntsSpliterator randomIntsSpliterator;
            long i = this.index;
            long m3 = i + this.fence >>> 1;
            if (m3 <= i) {
                randomIntsSpliterator = null;
            } else {
                this.index = m3;
                RandomIntsSpliterator randomIntsSpliterator2 = new RandomIntsSpliterator(i, this.index, this.origin, this.bound);
                randomIntsSpliterator = randomIntsSpliterator2;
            }
            return randomIntsSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public long getExactSizeIfKnown() {
            return Spliterators.getExactSizeIfKnown(this);
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return Spliterators.hasCharacteristics(this, characteristics);
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            return Spliterators.getComparator(this);
        }

        @Override
        public boolean tryAdvance(IntConsumer consumer) {
            Objects.requireNonNull(consumer);
            long i = this.index;
            long f = this.fence;
            if (i < f) {
                consumer.accept(ThreadLocalRandom.current().internalNextInt(this.origin, this.bound));
                this.index = i + 1L;
                return true;
            }
            return false;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Integer> action) {
            return Spliterators.OfInt.tryAdvance(this, action);
        }

        @Override
        public void forEachRemaining(IntConsumer consumer) {
            Objects.requireNonNull(consumer);
            long i = this.index;
            long f = this.fence;
            if (i < f) {
                this.index = f;
                int o = this.origin;
                int b = this.bound;
                ThreadLocalRandom rng = ThreadLocalRandom.current();
                do {
                    consumer.accept(rng.internalNextInt(o, b));
                } while (++i < f);
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super Integer> action) {
            Spliterators.OfInt.forEachRemaining((Spliterator.OfInt)this, action);
        }
    }
}

