/*
 * Decompiled with CFR 0.152.
 */
package io.requery.query.element;

import io.requery.query.Exists;
import io.requery.query.Return;
import io.requery.util.Objects;

public class ExistsElement<E>
implements Exists<E> {
    private final E parent;
    private Return<?> subQuery;
    private boolean notExists;

    ExistsElement(E query) {
        this.parent = query;
    }

    @Override
    public E exists(Return<?> query) {
        this.subQuery = Objects.requireNotNull(query);
        return this.parent;
    }

    @Override
    public E notExists(Return<?> query) {
        this.notExists = true;
        this.subQuery = Objects.requireNotNull(query);
        return this.parent;
    }

    public Return<?> getQuery() {
        return this.subQuery;
    }

    public boolean isNotExists() {
        return this.notExists;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExistsElement) {
            ExistsElement other = (ExistsElement)obj;
            return this.parent == other.parent && this.notExists == other.notExists;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.notExists);
    }
}

