/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.sync;

import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.db.CheckInList;
import eu.pretix.libpretixsync.db.Item;
import eu.pretix.libpretixsync.db.Migrations;
import eu.pretix.libpretixsync.sync.BaseConditionalSyncAdapter;
import eu.pretix.libpretixsync.sync.FileStorage;
import eu.pretix.libpretixsync.sync.SyncManager;
import eu.pretix.libpretixsync.utils.JSONUtils;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.meta.QueryAttribute;
import io.requery.query.Result;
import io.requery.query.Tuple;
import io.requery.query.WhereAndOr;
import io.requery.util.CloseableIterator;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CheckInListSyncAdapter
extends BaseConditionalSyncAdapter<CheckInList, Long> {
    private Long subeventId;

    public CheckInListSyncAdapter(BlockingEntityStore<Persistable> store, FileStorage fileStorage2, String eventSlug, PretixApi api, String syncCycleId, SyncManager.ProgressFeedback feedback, Long subeventId) {
        super(store, fileStorage2, eventSlug, api, syncCycleId, feedback);
        this.subeventId = subeventId;
    }

    @Override
    protected String getUrl() {
        Object url2 = this.api.eventResourceUrl(this.eventSlug, this.getResourceName());
        url2 = (String)url2 + "?exclude=checkin_count&exclude=position_count";
        if (this.subeventId != null && this.subeventId > 0L) {
            url2 = (String)url2 + "&subevent_match=" + this.subeventId;
        }
        return url2;
    }

    @Override
    public void updateObject(CheckInList obj, JSONObject jsonobj) throws JSONException {
        obj.setEvent_slug(this.eventSlug);
        obj.setServer_id(jsonobj.getLong("id"));
        obj.setSubevent_id(jsonobj.optLong("subevent"));
        obj.setName(jsonobj.optString("name", ""));
        obj.setInclude_pending(jsonobj.optBoolean("include_pending"));
        obj.setAll_items(jsonobj.optBoolean("all_products"));
        obj.setJson_data(jsonobj.toString());
        JSONArray itemsarr = jsonobj.getJSONArray("limit_products");
        ArrayList<Long> itemids = new ArrayList<Long>();
        for (int i = 0; i < itemsarr.length(); ++i) {
            itemids.add(itemsarr.getLong(i));
        }
        if (!itemids.isEmpty()) {
            List items = ((Result)this.store.select(Item.class, new QueryAttribute[0]).where(Item.SERVER_ID.in(itemids)).get()).toList();
            for (Item item : items) {
                if (obj.getItems().contains(item)) continue;
                obj.getItems().add(item);
            }
            obj.getItems().retainAll(items);
        } else {
            obj.getItems().clear();
        }
    }

    @Override
    public CloseableIterator<CheckInList> runBatch(List<Long> ids) {
        return ((Result)((WhereAndOr)this.store.select(CheckInList.class, new QueryAttribute[0]).where(CheckInList.EVENT_SLUG.eq((Object)this.eventSlug)).and(CheckInList.SERVER_ID.in(ids))).get()).iterator();
    }

    @Override
    CloseableIterator<Tuple> getKnownIDsIterator() {
        return ((Result)this.store.select(CheckInList.SERVER_ID).where(CheckInList.EVENT_SLUG.eq((Object)this.eventSlug)).get()).iterator();
    }

    @Override
    String getResourceName() {
        return "checkinlists";
    }

    @Override
    Long getId(JSONObject obj) throws JSONException {
        return obj.getLong("id");
    }

    @Override
    public String getMeta() {
        if (this.subeventId != null && this.subeventId > 0L) {
            return "subevent=" + this.subeventId;
        }
        return super.getMeta();
    }

    @Override
    Long getId(CheckInList obj) {
        return obj.getServer_id();
    }

    @Override
    CheckInList newEmptyObject() {
        return new CheckInList();
    }

    public void standaloneRefreshFromJSON(JSONObject data2) throws JSONException {
        CheckInList obj = ((Result)this.store.select(CheckInList.class, new QueryAttribute[0]).where(CheckInList.SERVER_ID.eq((Object)data2.getLong("id"))).get()).firstOr(this.newEmptyObject());
        JSONObject old = null;
        if (obj.getId() != null) {
            old = obj.getJSON();
        }
        data2.put("__libpretixsync_dbversion", Migrations.CURRENT_VERSION);
        data2.put("__libpretixsync_syncCycleId", this.syncCycleId);
        if (old == null) {
            this.updateObject(obj, data2);
            this.store.insert(obj);
        } else if (!JSONUtils.similar(data2, (Object)old)) {
            this.updateObject(obj, data2);
            this.store.update(obj);
        }
    }
}

