/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.sync;

import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.db.Event;
import eu.pretix.libpretixsync.db.Migrations;
import eu.pretix.libpretixsync.sync.BaseSingleObjectSyncAdapter;
import eu.pretix.libpretixsync.sync.SyncManager;
import eu.pretix.libpretixsync.utils.JSONUtils;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.meta.QueryAttribute;
import io.requery.query.Result;
import java.util.List;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONException;
import org.json.JSONObject;

public class EventSyncAdapter
extends BaseSingleObjectSyncAdapter<Event> {
    public EventSyncAdapter(BlockingEntityStore<Persistable> store, String eventSlug, String key, PretixApi api, String syncCycleId, SyncManager.ProgressFeedback feedback) {
        super(store, eventSlug, key, api, syncCycleId, feedback);
    }

    @Override
    public void updateObject(Event obj, JSONObject jsonobj) throws JSONException {
        obj.setSlug(jsonobj.getString("slug"));
        obj.setCurrency(jsonobj.getString("currency"));
        obj.setDate_from(ISODateTimeFormat.dateTimeParser().parseDateTime(jsonobj.getString("date_from")).toDate());
        if (!jsonobj.isNull("date_to")) {
            obj.setDate_to(ISODateTimeFormat.dateTimeParser().parseDateTime(jsonobj.getString("date_to")).toDate());
        }
        obj.setLive(jsonobj.getBoolean("live"));
        obj.setHas_subevents(jsonobj.getBoolean("has_subevents"));
        obj.setJson_data(jsonobj.toString());
    }

    @Override
    Event getKnownObject() {
        List is = ((Result)this.store.select(Event.class, new QueryAttribute[0]).where(Event.SLUG.eq((Object)this.key)).get()).toList();
        if (is.size() == 0) {
            return null;
        }
        if (is.size() == 1) {
            return (Event)is.get(0);
        }
        this.store.delete(is);
        return null;
    }

    @Override
    protected String getUrl() {
        return this.api.organizerResourceUrl("events/" + this.key);
    }

    @Override
    String getResourceName() {
        return "events";
    }

    @Override
    Event newEmptyObject() {
        return new Event();
    }

    public void standaloneRefreshFromJSON(JSONObject data2) throws JSONException {
        Event obj = ((Result)this.store.select(Event.class, new QueryAttribute[0]).where(Event.SLUG.eq((Object)data2.getString("slug"))).get()).firstOr(this.newEmptyObject());
        JSONObject old = null;
        if (obj.getId() != null) {
            old = obj.getJSON();
        }
        data2.put("__libpretixsync_dbversion", Migrations.CURRENT_VERSION);
        data2.put("__libpretixsync_syncCycleId", this.syncCycleId);
        if (old == null) {
            this.updateObject(obj, data2);
            this.store.insert(obj);
        } else if (!JSONUtils.similar(data2, (Object)old)) {
            this.updateObject(obj, data2);
            this.store.update(obj);
        }
    }
}

