/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.grpc;

import io.grpc.MethodDescriptor;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public abstract class AbstractMetricCollectingInterceptor {
    private static final String TAG_SERVICE_NAME = "service";
    private static final String TAG_METHOD_NAME = "method";
    private static final String TAG_METHOD_TYPE = "methodType";
    private static final String TAG_STATUS_CODE = "statusCode";
    private final Map<MethodDescriptor<?, ?>, MetricSet> metricsForMethods = new ConcurrentHashMap();
    protected final MeterRegistry registry;
    protected final UnaryOperator<Counter.Builder> counterCustomizer;
    protected final UnaryOperator<Timer.Builder> timerCustomizer;
    protected final Status.Code[] eagerInitializedCodes;

    protected static Counter.Builder prepareCounterFor(MethodDescriptor<?, ?> method2, String name, String description2) {
        return Counter.builder(name).description(description2).baseUnit("messages").tag(TAG_SERVICE_NAME, method2.getServiceName()).tag(TAG_METHOD_NAME, method2.getBareMethodName()).tag(TAG_METHOD_TYPE, method2.getType().name());
    }

    protected static Timer.Builder prepareTimerFor(MethodDescriptor<?, ?> method2, String name, String description2) {
        return Timer.builder(name).description(description2).tag(TAG_SERVICE_NAME, method2.getServiceName()).tag(TAG_METHOD_NAME, method2.getBareMethodName()).tag(TAG_METHOD_TYPE, method2.getType().name());
    }

    protected AbstractMetricCollectingInterceptor(MeterRegistry registry) {
        this(registry, UnaryOperator.identity(), UnaryOperator.identity(), Status.Code.OK);
    }

    protected AbstractMetricCollectingInterceptor(MeterRegistry registry, UnaryOperator<Counter.Builder> counterCustomizer, UnaryOperator<Timer.Builder> timerCustomizer, Status.Code ... eagerInitializedCodes) {
        this.registry = registry;
        this.counterCustomizer = counterCustomizer;
        this.timerCustomizer = timerCustomizer;
        this.eagerInitializedCodes = eagerInitializedCodes;
    }

    public void preregisterService(ServiceDescriptor service2) {
        for (MethodDescriptor method2 : service2.getMethods()) {
            this.preregisterMethod(method2);
        }
    }

    public void preregisterMethod(MethodDescriptor<?, ?> method2) {
        this.metricsFor(method2);
    }

    protected final MetricSet metricsFor(MethodDescriptor<?, ?> method2) {
        return this.metricsForMethods.computeIfAbsent(method2, this::newMetricsFor);
    }

    protected MetricSet newMetricsFor(MethodDescriptor<?, ?> method2) {
        return new MetricSet(this.newRequestCounterFor(method2), this.newResponseCounterFor(method2), this.newTimerFunction(method2));
    }

    protected abstract Counter newRequestCounterFor(MethodDescriptor<?, ?> var1);

    protected abstract Counter newResponseCounterFor(MethodDescriptor<?, ?> var1);

    protected Function<Status.Code, Timer> asTimerFunction(Supplier<Timer.Builder> timerTemplate) {
        EnumMap cache2 = new EnumMap(Status.Code.class);
        Function<Status.Code, Timer> creator = code -> ((Timer.Builder)timerTemplate.get()).tag(TAG_STATUS_CODE, code.name()).register(this.registry);
        Function<Status.Code, Timer> cacheResolver = code -> (Timer)cache2.computeIfAbsent((Status.Code)code, creator);
        for (Status.Code code2 : this.eagerInitializedCodes) {
            cacheResolver.apply(code2);
        }
        return cacheResolver;
    }

    protected abstract Function<Status.Code, Timer> newTimerFunction(MethodDescriptor<?, ?> var1);

    protected static class MetricSet {
        private final Counter requestCounter;
        private final Counter responseCounter;
        private final Function<Status.Code, Timer> timerFunction;

        public MetricSet(Counter requestCounter, Counter responseCounter, Function<Status.Code, Timer> timerFunction) {
            this.requestCounter = requestCounter;
            this.responseCounter = responseCounter;
            this.timerFunction = timerFunction;
        }

        public Counter getRequestCounter() {
            return this.requestCounter;
        }

        public Counter getResponseCounter() {
            return this.responseCounter;
        }

        public Consumer<Status.Code> newProcessingDurationTiming(MeterRegistry registry) {
            Timer.Sample timerSample = Timer.start(registry);
            return code -> timerSample.stop(this.timerFunction.apply((Status.Code)code));
        }
    }
}

