/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql.gen;

import io.requery.meta.Attribute;
import io.requery.meta.Type;
import io.requery.query.Expression;
import io.requery.query.ExpressionType;
import io.requery.sql.Keyword;
import io.requery.sql.QueryBuilder;
import io.requery.sql.gen.Generator;
import io.requery.sql.gen.Output;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class UpsertMergeGenerator
implements Generator<Map<Expression<?>, Object>> {
    protected final String alias = "val";

    @Override
    public void write(Output output, Map<Expression<?>, Object> values2) {
        QueryBuilder qb = output.builder();
        Type type2 = null;
        for (Expression<?> expression : values2.keySet()) {
            if (expression.getExpressionType() != ExpressionType.ATTRIBUTE) continue;
            Attribute attribute = (Attribute)((Object)expression);
            type2 = attribute.getDeclaringType();
            break;
        }
        if (type2 == null) {
            throw new IllegalStateException();
        }
        qb.keyword(Keyword.MERGE).keyword(Keyword.INTO).tableName(type2.getName()).keyword(Keyword.USING);
        this.appendUsing(output, values2);
        qb.keyword(Keyword.ON).openParenthesis();
        int count = 0;
        Set attributes = type2.getKeyAttributes();
        if (attributes.isEmpty()) {
            attributes = type2.getAttributes();
        }
        for (Attribute attribute : attributes) {
            if (count > 0) {
                qb.keyword(Keyword.AND);
            }
            qb.aliasAttribute(type2.getName(), attribute);
            qb.append(" = ");
            qb.aliasAttribute("val", attribute);
            ++count;
        }
        qb.closeParenthesis().space();
        LinkedHashSet<Attribute> updates = new LinkedHashSet<Attribute>();
        for (Expression<?> expression : values2.keySet()) {
            Attribute attribute;
            if (expression.getExpressionType() != ExpressionType.ATTRIBUTE || (attribute = (Attribute)((Object)expression)).isKey()) continue;
            updates.add(attribute);
        }
        qb.keyword(Keyword.WHEN, Keyword.MATCHED, Keyword.THEN, Keyword.UPDATE, Keyword.SET).commaSeparated(updates, new QueryBuilder.Appender<Attribute<?, ?>>(){

            @Override
            public void append(QueryBuilder qb, Attribute<?, ?> value) {
                qb.attribute(value);
                qb.append(" = val." + value.getName());
            }
        }).space();
        qb.keyword(Keyword.WHEN, Keyword.NOT, Keyword.MATCHED, Keyword.THEN, Keyword.INSERT).openParenthesis().commaSeparatedExpressions(values2.keySet()).closeParenthesis().space().keyword(Keyword.VALUES).openParenthesis().commaSeparated(values2.keySet(), new QueryBuilder.Appender<Expression<?>>(){

            @Override
            public void append(QueryBuilder qb, Expression<?> value) {
                qb.aliasAttribute("val", (Attribute)((Object)value));
            }
        }).closeParenthesis();
    }

    protected void appendUsing(final Output writer, final Map<Expression<?>, Object> values2) {
        QueryBuilder qb = writer.builder();
        qb.openParenthesis().keyword(Keyword.VALUES).openParenthesis().commaSeparated(values2.keySet(), new QueryBuilder.Appender<Expression>(){

            @Override
            public void append(QueryBuilder qb, Expression expression) {
                qb.append("?");
                writer.parameters().add(expression, values2.get(expression));
            }
        }).closeParenthesis().closeParenthesis().space().keyword(Keyword.AS).append("val").openParenthesis().commaSeparatedExpressions(values2.keySet()).closeParenthesis().space();
    }
}

