/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.check;

import eu.pretix.libpretixsync.DummySentryImplementation;
import eu.pretix.libpretixsync.SentryInterface;
import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.check.AsyncCheckProvider;
import eu.pretix.libpretixsync.check.CheckException;
import eu.pretix.libpretixsync.check.TicketCheckProvider;
import eu.pretix.libpretixsync.config.ConfigStore;
import eu.pretix.libpretixsync.crypto.sig1.TicketProtos;
import eu.pretix.libpretixsync.db.Answer;
import eu.pretix.libpretixsync.db.BlockedTicketSecret;
import eu.pretix.libpretixsync.db.CheckIn;
import eu.pretix.libpretixsync.db.CheckInList;
import eu.pretix.libpretixsync.db.CheckInList_Item;
import eu.pretix.libpretixsync.db.Event;
import eu.pretix.libpretixsync.db.Item;
import eu.pretix.libpretixsync.db.ItemVariation;
import eu.pretix.libpretixsync.db.NonceGenerator;
import eu.pretix.libpretixsync.db.Order;
import eu.pretix.libpretixsync.db.OrderPosition;
import eu.pretix.libpretixsync.db.Question;
import eu.pretix.libpretixsync.db.QuestionLike;
import eu.pretix.libpretixsync.db.QueuedCall;
import eu.pretix.libpretixsync.db.QueuedCheckIn;
import eu.pretix.libpretixsync.db.ReusableMedium;
import eu.pretix.libpretixsync.db.RevokedTicketSecret;
import eu.pretix.libpretixsync.db.SubEvent;
import eu.pretix.libpretixsync.utils.InputUtilsKt;
import eu.pretix.libpretixsync.utils.codec.binary.Base64;
import eu.pretix.libpretixsync.utils.logic.JsonLogic;
import eu.pretix.libpretixsync.utils.logic.UtilsKt;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.kotlin.Logical;
import io.requery.meta.NumericAttributeDelegate;
import io.requery.meta.QueryAttribute;
import io.requery.meta.QueryExpression;
import io.requery.query.Condition;
import io.requery.query.DistinctSelection;
import io.requery.query.Expression;
import io.requery.query.JoinOn;
import io.requery.query.LogicalCondition;
import io.requery.query.Result;
import io.requery.query.Return;
import io.requery.query.Scalar;
import io.requery.query.Tuple;
import io.requery.query.WhereAndOr;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.IllegalInstantException;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001:\u0002NOB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J0\u0010\f\u001a\u0014\u0012\u0010\b\u0001\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\u000e0\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J$\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u0010\u001b\u001a\u00020\u0019H\u0016Jf\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u00112\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u00192\u0006\u0010$\u001a\u00020\u0014H\u0016Jd\u0010%\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u0010&\u001a\u00020\u00192\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00112\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u00112\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u00192\u0006\u0010$\u001a\u00020\u0014H\u0002JN\u0010)\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u00112\b\u0010#\u001a\u0004\u0018\u00010\u00192\u0006\u0010$\u001a\u00020\u0014H\u0002J\u001a\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0019H\u0003J*\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u00112\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J \u00104\u001a\u0002052\u0006\u0010,\u001a\u00020-2\u0006\u00106\u001a\u00020\u001a2\u0006\u00107\u001a\u000208H\u0002J\b\u00109\u001a\u00020\tH\u0002J2\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\u00112\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\u0006\u0010<\u001a\u00020\u00192\u0006\u0010=\u001a\u00020\u000fH\u0016J\u000e\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\tJ\u0010\u0010A\u001a\u00020?2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u00192\u0006\u0010E\u001a\u00020\u001aH\u0016Jo\u0010F\u001a\u00020?2\u0006\u0010D\u001a\u00020\u00192\u0006\u0010E\u001a\u00020\u001a2\u0006\u0010G\u001a\u00020\u00192\u0006\u0010H\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\n\b\u0002\u0010I\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010J\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010K\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010L\u001a\u0004\u0018\u00010\u001a2\b\u0010#\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0002\u0010MR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Leu/pretix/libpretixsync/check/AsyncCheckProvider;", "Leu/pretix/libpretixsync/check/TicketCheckProvider;", "config", "Leu/pretix/libpretixsync/config/ConfigStore;", "dataStore", "Lio/requery/BlockingEntityStore;", "Lio/requery/Persistable;", "(Leu/pretix/libpretixsync/config/ConfigStore;Lio/requery/BlockingEntityStore;)V", "overrideNow", "Lorg/joda/time/DateTime;", "sentry", "Leu/pretix/libpretixsync/SentryInterface;", "basePositionQuery", "Lio/requery/query/WhereAndOr;", "Lio/requery/query/Scalar;", "", "lists", "", "Leu/pretix/libpretixsync/db/CheckInList;", "onlyCheckedIn", "", "check", "Leu/pretix/libpretixsync/check/TicketCheckProvider$CheckResult;", "eventsAndCheckinLists", "", "", "", "ticketid", "source_type", "answers", "Leu/pretix/libpretixsync/db/Answer;", "ignore_unpaid", "with_badge_data", "type", "Leu/pretix/libpretixsync/check/TicketCheckProvider$CheckInType;", "nonce", "allowQuestions", "checkOfflineWithData", "secret", "tickets", "Leu/pretix/libpretixsync/db/OrderPosition;", "checkOfflineWithoutData", "decodePretixSig1", "Leu/pretix/libpretixsync/check/AsyncCheckProvider$SignedTicketData;", "event", "Leu/pretix/libpretixsync/db/Event;", "qrcode", "extractRequiredShownAnswers", "Leu/pretix/libpretixsync/check/AsyncCheckProvider$RSAResult;", "questions", "Leu/pretix/libpretixsync/db/Question;", "answerMap", "initJsonLogic", "Leu/pretix/libpretixsync/utils/logic/JsonLogic;", "subeventId", "tz", "Lorg/joda/time/DateTimeZone;", "now", "search", "Leu/pretix/libpretixsync/check/TicketCheckProvider$SearchResult;", "query", "page", "setNow", "", "d", "setSentry", "status", "Leu/pretix/libpretixsync/check/TicketCheckProvider$StatusResult;", "eventSlug", "listId", "storeFailedCheckin", "error_reason", "raw_barcode", "position", "item", "variation", "subevent", "(Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;Leu/pretix/libpretixsync/check/TicketCheckProvider$CheckInType;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/String;)V", "RSAResult", "SignedTicketData", "libpretixsync"})
@SourceDebugExtension(value={"SMAP\nAsyncCheckProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncCheckProvider.kt\neu/pretix/libpretixsync/check/AsyncCheckProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1143:1\n819#2:1144\n847#2,2:1145\n766#2:1147\n857#2,2:1148\n766#2:1150\n857#2,2:1151\n766#2:1153\n857#2,2:1154\n766#2:1156\n857#2,2:1157\n1549#2:1159\n1620#2,3:1160\n766#2:1163\n857#2,2:1164\n1549#2:1166\n1620#2,3:1167\n1726#2,3:1170\n766#2:1173\n857#2,2:1174\n1549#2:1176\n1620#2,3:1177\n766#2:1180\n857#2,2:1181\n819#2:1183\n847#2,2:1184\n766#2:1186\n857#2,2:1187\n766#2:1189\n857#2,2:1190\n766#2:1192\n857#2,2:1193\n766#2:1195\n857#2,2:1196\n1549#2:1198\n1620#2,3:1199\n766#2:1202\n857#2,2:1203\n1549#2:1205\n1620#2,3:1206\n1726#2,3:1209\n1549#2:1212\n1620#2,3:1213\n*S KotlinDebug\n*F\n+ 1 AsyncCheckProvider.kt\neu/pretix/libpretixsync/check/AsyncCheckProvider\n*L\n368#1:1144\n368#1:1145,2\n372#1:1147\n372#1:1148,2\n390#1:1150\n390#1:1151,2\n391#1:1153\n391#1:1154,2\n418#1:1156\n418#1:1157,2\n418#1:1159\n418#1:1160,3\n421#1:1163\n421#1:1164,2\n421#1:1166\n421#1:1167,3\n498#1:1170,3\n628#1:1173\n628#1:1174,2\n634#1:1176\n634#1:1177,3\n635#1:1180\n635#1:1181,2\n696#1:1183\n696#1:1184,2\n701#1:1186\n701#1:1187,2\n780#1:1189\n780#1:1190,2\n781#1:1192\n781#1:1193,2\n808#1:1195\n808#1:1196,2\n808#1:1198\n808#1:1199,3\n811#1:1202\n811#1:1203,2\n811#1:1205\n811#1:1206,3\n893#1:1209,3\n1059#1:1212\n1059#1:1213,3\n*E\n"})
public final class AsyncCheckProvider
implements TicketCheckProvider {
    @NotNull
    private final ConfigStore config;
    @NotNull
    private final BlockingEntityStore<Persistable> dataStore;
    @NotNull
    private SentryInterface sentry;
    @Nullable
    private DateTime overrideNow;

    public AsyncCheckProvider(@NotNull ConfigStore config, @NotNull BlockingEntityStore<Persistable> dataStore) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(dataStore, "dataStore");
        this.config = config;
        this.dataStore = dataStore;
        this.sentry = new DummySentryImplementation();
    }

    @Override
    public void setSentry(@NotNull SentryInterface sentry) {
        Intrinsics.checkNotNullParameter(sentry, "sentry");
        this.sentry = sentry;
    }

    private final void storeFailedCheckin(String eventSlug, long listId, String error_reason, String raw_barcode, TicketCheckProvider.CheckInType type2, Long position, Long item, Long variation, Long subevent, String nonce) {
        String string;
        DateTime dt = this.now();
        JSONObject jdoc = new JSONObject();
        jdoc.put("datetime", QueuedCheckIn.formatDatetime(dt.toDate()));
        Object object = raw_barcode;
        if (new Regex("[\\p{C}]").containsMatchIn((CharSequence)object)) {
            Object object2 = raw_barcode;
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue(charset, "defaultCharset(...)");
            byte[] byArray = ((String)object2).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
            byte[] byArray2 = Base64.encodeBase64(byArray);
            Intrinsics.checkNotNullExpressionValue(byArray2, "encodeBase64(...)");
            object = byArray2;
            Charset charset2 = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue(charset2, "defaultCharset(...)");
            object2 = charset2;
            jdoc.put("raw_barcode", "binary:" + new String((byte[])object, (Charset)object2));
        } else {
            jdoc.put("raw_barcode", raw_barcode);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
            case 1: {
                string = "entry";
                break;
            }
            case 2: {
                string = "exit";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        jdoc.put("type", string);
        jdoc.put("error_reason", error_reason);
        if (nonce != null) {
            jdoc.put("nonce", nonce);
        }
        if (position != null && position > 0L) {
            jdoc.put("position", position);
        }
        if (item != null && item > 0L) {
            jdoc.put("item", item);
        }
        if (variation != null && variation > 0L) {
            jdoc.put("variation", variation);
        }
        if (subevent != null && subevent > 0L) {
            jdoc.put("subevent", subevent);
        }
        QueuedCall qo = new QueuedCall();
        PretixApi api = PretixApi.Companion.fromConfig(this.config);
        qo.setUrl(api.eventResourceUrl(eventSlug, "checkinlists") + listId + "/failed_checkins/");
        qo.setBody(jdoc.toString());
        qo.setIdempotency_key(NonceGenerator.nextNonce());
        this.dataStore.insert(qo);
    }

    static /* synthetic */ void storeFailedCheckin$default(AsyncCheckProvider asyncCheckProvider, String string, long l, String string2, String string3, TicketCheckProvider.CheckInType checkInType, Long l2, Long l3, Long l4, Long l5, String string4, int n, Object object) {
        if ((n & 0x20) != 0) {
            l2 = null;
        }
        if ((n & 0x40) != 0) {
            l3 = null;
        }
        if ((n & 0x80) != 0) {
            l4 = null;
        }
        if ((n & 0x100) != 0) {
            l5 = null;
        }
        asyncCheckProvider.storeFailedCheckin(string, l, string2, string3, checkInType, l2, l3, l4, l5, string4);
    }

    private final JsonLogic initJsonLogic(Event event, long subeventId, DateTimeZone tz) {
        JsonLogic jsonLogic = new JsonLogic();
        jsonLogic.addOperation("objectList", initJsonLogic.1.INSTANCE);
        jsonLogic.addOperation("lookup", initJsonLogic.2.INSTANCE);
        jsonLogic.addOperation("inList", initJsonLogic.3.INSTANCE);
        jsonLogic.addOperation("entries_since", initJsonLogic.4.INSTANCE);
        jsonLogic.addOperation("entries_before", initJsonLogic.5.INSTANCE);
        jsonLogic.addOperation("entries_days_since", initJsonLogic.6.INSTANCE);
        jsonLogic.addOperation("entries_days_before", initJsonLogic.7.INSTANCE);
        jsonLogic.addOperation("isAfter", initJsonLogic.8.INSTANCE);
        jsonLogic.addOperation("isBefore", initJsonLogic.9.INSTANCE);
        jsonLogic.addOperation("buildTime", (Function2<? super List<? extends Object>, Object, ? extends Object>)new Function2<List<? extends Object>, Object, Object>(event, subeventId, this, tz){
            final /* synthetic */ Event $event;
            final /* synthetic */ long $subeventId;
            final /* synthetic */ AsyncCheckProvider this$0;
            final /* synthetic */ DateTimeZone $tz;
            {
                this.$event = $event;
                this.$subeventId = $subeventId;
                this.this$0 = $receiver;
                this.$tz = $tz;
                super(2);
            }

            @Nullable
            public final Object invoke(@Nullable List<? extends Object> l, @Nullable Object d) {
                DateTime dateTime;
                List<? extends Object> list = l;
                Object t = list != null ? CollectionsKt.getOrNull(list, 0) : null;
                JSONObject evjson = this.$event.getJSON();
                if (this.$subeventId != 0L) {
                    SubEvent subevent = (SubEvent)((Result)((WhereAndOr)AsyncCheckProvider.access$getDataStore$p(this.this$0).select(SubEvent.class, new QueryAttribute[0]).where((Condition)SubEvent.EVENT_SLUG.eq((Object)this.$event.slug)).and((Condition)SubEvent.SERVER_ID.eq((Object)this.$subeventId))).get()).first();
                    evjson = subevent.getJSON();
                }
                if (Intrinsics.areEqual(t, "custom")) {
                    dateTime = ISODateTimeFormat.dateTimeParser().parseDateTime((String)CollectionsKt.getOrNull(l, 1));
                } else if (Intrinsics.areEqual(t, "customtime")) {
                    DateTime dateTime2;
                    LocalTime time = ISODateTimeFormat.timeParser().parseLocalTime((String)CollectionsKt.getOrNull(l, 1));
                    LocalDate today = new DateTime(AsyncCheckProvider.access$now(this.this$0)).withZone(this.$tz).toLocalDate();
                    try {
                        dateTime2 = today.toLocalDateTime(time).toDateTime(this.$tz);
                    }
                    catch (IllegalInstantException e) {
                        dateTime2 = today.toLocalDateTime(time.minusHours(1)).toDateTime(this.$tz);
                    }
                    dateTime = dateTime2;
                } else if (Intrinsics.areEqual(t, "date_from")) {
                    dateTime = ISODateTimeFormat.dateTimeParser().parseDateTime(evjson.getString("date_from"));
                } else if (Intrinsics.areEqual(t, "date_to")) {
                    dateTime = ISODateTimeFormat.dateTimeParser().parseDateTime(evjson.optString("date_to"));
                } else if (Intrinsics.areEqual(t, "date_admission")) {
                    DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTimeParser();
                    String string = evjson.optString("date_admission");
                    if (string == null) {
                        string = evjson.getString("date_from");
                    }
                    dateTime = dateTimeFormatter.parseDateTime(string);
                } else {
                    dateTime = null;
                }
                return dateTime;
            }
        });
        return jsonLogic;
    }

    @ExperimentalUnsignedTypes
    private final SignedTicketData decodePretixSig1(Event event, String qrcode) {
        byte[] rawbytes = null;
        try {
            String string = ((Object)StringsKt.reversed((CharSequence)qrcode)).toString();
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue(charset, "defaultCharset(...)");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
            byte[] byArray2 = Base64.decodeBase64(byArray);
            Intrinsics.checkNotNullExpressionValue(byArray2, "decodeBase64(...)");
            rawbytes = byArray2;
        }
        catch (Exception e) {
            return null;
        }
        if (rawbytes.length == 0) {
            return null;
        }
        int version = UByte.constructor-impl(rawbytes[0]) & 0xFF;
        if (version != 1) {
            return null;
        }
        int payloadLength = ((UByte.constructor-impl(rawbytes[1]) & 0xFF) << 2) + (UByte.constructor-impl(rawbytes[2]) & 0xFF);
        int signatureLength = ((UByte.constructor-impl(rawbytes[3]) & 0xFF) << 2) + (UByte.constructor-impl(rawbytes[4]) & 0xFF);
        byte[] byArray = rawbytes;
        int n = 5;
        int n2 = 5 + payloadLength;
        byte[] payload = ArraysKt.copyOfRange(byArray, n, n2);
        byte[] byArray3 = rawbytes;
        n2 = 5 + payloadLength;
        int n3 = 5 + payloadLength + signatureLength;
        byte[] signature2 = ArraysKt.copyOfRange(byArray3, n2, n3);
        JSONObject jSONObject = event.getValidKeys();
        JSONArray jSONArray = jSONObject != null ? jSONObject.optJSONArray("pretix_sig1") : null;
        if (jSONArray == null) {
            return null;
        }
        JSONArray validKeys = jSONArray;
        n3 = validKeys.length();
        for (int vki = 0; vki < n3; ++vki) {
            byte[] byArray4;
            String vk = validKeys.getString(vki);
            Intrinsics.checkNotNull(vk);
            Object object = vk;
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue(charset, "defaultCharset(...)");
            byte[] byArray5 = ((String)object).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue(byArray5, "getBytes(...)");
            Intrinsics.checkNotNullExpressionValue(Base64.decodeBase64(byArray5), "decodeBase64(...)");
            Charset charset2 = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue(charset2, "defaultCharset(...)");
            object = charset2;
            if (!eu.pretix.libpretixsync.crypto.UtilsKt.isValidSignature(payload, signature2, eu.pretix.libpretixsync.crypto.UtilsKt.readPubkeyFromPem(new String(byArray4, (Charset)object)))) continue;
            TicketProtos.Ticket ticket = TicketProtos.Ticket.parseFrom(payload);
            String string = ticket.getSeed();
            Intrinsics.checkNotNullExpressionValue(string, "getSeed(...)");
            return new SignedTicketData(string, ticket.getItem(), ticket.getVariation(), ticket.getSubevent(), ticket.hasValidFromUnixTime() && ticket.getValidFromUnixTime() > 0L ? new DateTime(ticket.getValidFromUnixTime() * (long)1000) : null, ticket.hasValidUntilUnixTime() && ticket.getValidUntilUnixTime() > 0L ? new DateTime(ticket.getValidUntilUnixTime() * (long)1000) : null);
        }
        return null;
    }

    private final RSAResult extractRequiredShownAnswers(List<? extends Question> questions, Map<Long, String> answerMap) {
        JSONArray givenAnswers = new JSONArray();
        List requiredAnswers = new ArrayList();
        List shownAnswers = new ArrayList();
        boolean askQuestions = false;
        for (Question question : questions) {
            String answer;
            block10: {
                if (!question.isAskDuringCheckin() && !question.isShowDuringCheckin()) continue;
                answer = "";
                if (answerMap.containsKey(question.getServer_id())) {
                    answer = answerMap.get(question.getServer_id());
                    try {
                        answer = question.clean_answer(answer, question.getOptions(), false);
                        JSONObject jo = new JSONObject();
                        jo.put("answer", answer);
                        Long l = question.getServer_id();
                        Intrinsics.checkNotNullExpressionValue(l, "getServer_id(...)");
                        jo.put("question", ((Number)l).longValue());
                        if (question.isAskDuringCheckin()) {
                            givenAnswers.put(jo);
                        }
                        if (question.isShowDuringCheckin()) {
                            shownAnswers.add(new TicketCheckProvider.QuestionAnswer(question, answer));
                        }
                        break block10;
                    }
                    catch (QuestionLike.ValidationException e) {
                        answer = "";
                        if (question.isAskDuringCheckin()) {
                            askQuestions = true;
                        }
                        break block10;
                    }
                    catch (JSONException e) {
                        answer = "";
                        if (question.isAskDuringCheckin()) {
                            askQuestions = true;
                        }
                        break block10;
                    }
                }
                if (question.isAskDuringCheckin()) {
                    askQuestions = true;
                }
            }
            if (!question.isAskDuringCheckin()) continue;
            requiredAnswers.add(new TicketCheckProvider.QuestionAnswer(question, answer));
        }
        return new RSAResult(givenAnswers, requiredAnswers, shownAnswers, askQuestions);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final TicketCheckProvider.CheckResult checkOfflineWithoutData(Map<String, Long> eventsAndCheckinLists, String ticketid, TicketCheckProvider.CheckInType type, List<Answer> answers, String nonce, boolean allowQuestions) {
        block53: {
            block50: {
                block52: {
                    block51: {
                        dt = this.now();
                        events = ((Result)this.dataStore.select(Event.class, new QueryAttribute[0]).where((Condition)Event.SLUG.in(CollectionsKt.toList((Iterable)eventsAndCheckinLists.keySet()))).get()).toList();
                        decoded = null;
                        event = null;
                        for (Event e : events) {
                            Intrinsics.checkNotNull(e);
                            decoded = this.decodePretixSig1(e, ticketid);
                            event = e;
                            if (decoded == null) continue;
                        }
                        if (decoded == null || event == null) {
                            firstentry = (Map.Entry)CollectionsKt.first((Iterable)eventsAndCheckinLists.entrySet());
                            AsyncCheckProvider.storeFailedCheckin$default(this, (String)firstentry.getKey(), ((Number)firstentry.getValue()).longValue(), "invalid", ticketid, type, null, null, null, null, nonce, 480, null);
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.INVALID, true);
                        }
                        v0 = eventsAndCheckinLists.get(event.slug);
                        if (v0 == null) {
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, "Check-in list not set for event", true);
                        }
                        listId = v0;
                        eventSlug = event.slug;
                        var15_15 = (CheckInList)((Result)((WhereAndOr)this.dataStore.select(CheckInList.class, new QueryAttribute[0]).where((Condition)CheckInList.SERVER_ID.eq((Object)listId)).and((Condition)CheckInList.EVENT_SLUG.eq((Object)eventSlug))).get()).firstOrNull();
                        if (var15_15 == null) {
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, "Check-in list not found", true);
                        }
                        list = var15_15;
                        is_revoked = (Integer)((Scalar)this.dataStore.count(RevokedTicketSecret.class).where((Condition)RevokedTicketSecret.SECRET.eq((Object)ticketid)).get()).value();
                        Intrinsics.checkNotNull(is_revoked);
                        if (is_revoked > 0) {
                            Intrinsics.checkNotNull(eventSlug);
                            AsyncCheckProvider.storeFailedCheckin$default(this, eventSlug, listId, "revoked", ticketid, type, null, null, null, null, nonce, 480, null);
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.REVOKED, true);
                        }
                        is_blocked = (Integer)((Scalar)((WhereAndOr)this.dataStore.count(BlockedTicketSecret.class).where((Condition)BlockedTicketSecret.SECRET.eq((Object)ticketid)).and((Condition)BlockedTicketSecret.BLOCKED.eq((Object)true))).get()).value();
                        Intrinsics.checkNotNull(is_blocked);
                        if (is_blocked > 0) {
                            Intrinsics.checkNotNull(eventSlug);
                            AsyncCheckProvider.storeFailedCheckin$default(this, eventSlug, listId, "blocked", ticketid, type, null, null, null, null, nonce, 480, null);
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.BLOCKED, true);
                        }
                        if (type != TicketCheckProvider.CheckInType.EXIT) {
                            v1 = decoded.getValidFrom();
                            v2 = v1 != null ? v1.isAfter(this.now()) : false;
                            if (v2) {
                                Intrinsics.checkNotNull(eventSlug);
                                AsyncCheckProvider.storeFailedCheckin$default(this, eventSlug, listId, "invalid_time", ticketid, type, null, decoded.getItem(), decoded.getVariation(), decoded.getSubevent(), nonce, 32, null);
                                return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.INVALID_TIME, true);
                            }
                            v3 = decoded.getValidUntil();
                            v4 = v3 != null ? v3.isBefore(this.now()) : false;
                            if (v4) {
                                Intrinsics.checkNotNull(eventSlug);
                                AsyncCheckProvider.storeFailedCheckin$default(this, eventSlug, listId, "invalid_time", ticketid, type, null, decoded.getItem(), decoded.getVariation(), decoded.getSubevent(), nonce, 32, null);
                                return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.INVALID_TIME, true);
                            }
                        }
                        if (!list.all_items) {
                            v5 = this.dataStore.count(CheckInList_Item.class).leftJoin(Item.class);
                            v6 = Item.ID;
                            Intrinsics.checkNotNullExpressionValue(v6, "ID");
                            v7 = is_in_list = (Integer)((Scalar)((WhereAndOr)v5.on((Condition)CheckInList_Item.ITEM_ID.eq(v6)).where((Condition)Item.SERVER_ID.eq((Object)decoded.getItem())).and((Condition)CheckInList_Item.CHECK_IN_LIST_ID.eq((Object)list.getId()))).get()).value();
                            if (v7 != null && v7 == 0) {
                                Intrinsics.checkNotNull(eventSlug);
                                AsyncCheckProvider.storeFailedCheckin$default(this, eventSlug, listId, "product", ticketid, type, null, null, null, decoded.getSubevent(), nonce, 224, null);
                                return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.PRODUCT, true);
                            }
                        }
                        if (list.getSubevent_id() != null) {
                            v8 = list.getSubevent_id();
                            Intrinsics.checkNotNullExpressionValue(v8, "getSubevent_id(...)");
                            if (((Number)v8).longValue() > 0L && !Intrinsics.areEqual(list.getSubevent_id(), decoded.getSubevent())) {
                                Intrinsics.checkNotNull(eventSlug);
                                AsyncCheckProvider.storeFailedCheckin$default(this, eventSlug, listId, "invalid", ticketid, type, null, null, null, null, nonce, 480, null);
                                return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.INVALID, true);
                            }
                        }
                        if ((item = (Item)((Result)((WhereAndOr)this.dataStore.select(Item.class, new QueryAttribute[0]).where((Condition)Item.SERVER_ID.eq((Object)decoded.getItem())).and((Condition)Item.EVENT_SLUG.eq((Object)eventSlug))).get()).firstOrNull()) == null) {
                            Intrinsics.checkNotNull(eventSlug);
                            AsyncCheckProvider.storeFailedCheckin$default(this, eventSlug, listId, "product", ticketid, type, null, null, null, decoded.getSubevent(), nonce, 224, null);
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, "Item not found", true);
                        }
                        res = new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, true);
                        res.setEventSlug(eventSlug);
                        res.setScanType(type);
                        res.setTicket(item.getInternalName());
                        if (decoded.getVariation() == null) ** GOTO lbl-1000
                        v9 = decoded.getVariation();
                        Intrinsics.checkNotNull(v9);
                        if (v9 > 0L) {
                            try {
                                v10 = item.getVariation(decoded.getVariation());
                                if (v10 == null) {
                                    v10 = null;
                                }
                                var20_20 = v10;
                            }
                            catch (JSONException e) {
                                this.sentry.captureException(e);
                                var20_20 = null;
                            }
                            v11 = var20_20;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v11 = variation = null;
                        }
                        if (variation != null) {
                            res.setVariation(variation.getStringValue());
                        }
                        require_attention = false;
                        try {
                            require_attention = item.getJSON().optBoolean("checkin_attention", false);
                        }
                        catch (JSONException e) {
                            this.sentry.captureException(e);
                        }
                        if (require_attention) ** GOTO lbl-1000
                        v12 = variation;
                        v13 = v12 != null ? v12.isCheckin_attention() : false;
                        if (v13) lbl-1000:
                        // 2 sources

                        {
                            v14 = true;
                        } else {
                            v14 = false;
                        }
                        res.setRequireAttention(v14);
                        e /* !! */  = new String[2];
                        v15 = variation;
                        e /* !! */ [0] = v15 != null && (v15 = v15.getCheckin_text()) != null ? StringsKt.trim((CharSequence)v15).toString() : null;
                        v16 = item.checkin_text;
                        e /* !! */ [1] = v16 != null ? StringsKt.trim((CharSequence)v16).toString() : null;
                        e /* !! */  = CollectionsKt.listOfNotNull(e /* !! */ );
                        var36_26 = res;
                        $i$f$filterNot = false;
                        var23_29 = $this$filterNot$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>();
                        $i$f$filterNotTo = false;
                        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                            it = (String)element$iv$iv;
                            $i$a$-filterNot-AsyncCheckProvider$checkOfflineWithoutData$1 = false;
                            if (StringsKt.isBlank(it)) continue;
                            destination$iv$iv /* !! */ .add(element$iv$iv);
                        }
                        $this$filterNot$iv = (List)destination$iv$iv /* !! */ ;
                        $i$f$filterNot = false;
                        $this$filterNotTo$iv$iv = $this$filterNot$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>();
                        $i$f$filterNotTo = false;
                        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                            it = (String)element$iv$iv;
                            $i$a$-filterNot-AsyncCheckProvider$checkOfflineWithoutData$2 = false;
                            if (StringsKt.isBlank(it) != false || Intrinsics.areEqual(it, "null") != false) continue;
                            destination$iv$iv /* !! */ .add(element$iv$iv);
                        }
                        var36_26.setCheckinTexts((List)destination$iv$iv /* !! */ );
                        v17 = ((Result)this.dataStore.select(QueuedCheckIn.class, new QueryAttribute[0]).where((Condition)QueuedCheckIn.SECRET.eq((Object)ticketid)).get()).toList();
                        Intrinsics.checkNotNullExpressionValue(v17, "toList(...)");
                        $this$filter$iv = (Function1[])v17;
                        $i$f$filter = false;
                        destination$iv$iv /* !! */  = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (E element$iv$iv : $this$filterTo$iv$iv) {
                            it = (QueuedCheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$checkOfflineWithoutData$queuedCheckIns$1 = false;
                            v18 = it.getCheckinListId();
                            var31_58 = listId;
                            if (!(v18 != null && v18 == var31_58)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = new Function1[]{checkOfflineWithoutData.queuedCheckIns.2.INSTANCE, checkOfflineWithoutData.queuedCheckIns.3.INSTANCE};
                        queuedCheckIns = CollectionsKt.sortedWith((List)destination$iv$iv, ComparisonsKt.compareBy($this$filter$iv));
                        rules = list.getRules();
                        if (type != TicketCheckProvider.CheckInType.ENTRY || rules == null || rules.length() <= 0) break block51;
                        data = new LinkedHashMap<K, V>();
                        tz = DateTimeZone.forID(event.getTimezone());
                        v19 = decoded.getSubevent();
                        v20 = v19 != null ? v19 : 0L;
                        Intrinsics.checkNotNull(tz);
                        jsonLogic = this.initJsonLogic(event, v20, tz);
                        data.put("product", String.valueOf(item.getServer_id()));
                        if (decoded.getVariation() == null) ** GOTO lbl-1000
                        v21 = decoded.getVariation();
                        Intrinsics.checkNotNull(v21);
                        if (v21 > 0L) {
                            v22 = String.valueOf(decoded.getVariation());
                        } else lbl-1000:
                        // 2 sources

                        {
                            v22 = "";
                        }
                        data.put("variation", v22);
                        data.put("gate", String.valueOf(this.config.getDeviceKnownGateID()));
                        data.put("now", dt);
                        data.put("now_isoweekday", dt.withZone(tz).dayOfWeek().get());
                        $i$f$filterTo = queuedCheckIns;
                        var37_63 = "entries_number";
                        var36_26 = data;
                        $i$f$filter = false;
                        element$iv$iv = $this$filter$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (QueuedCheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$checkOfflineWithoutData$3 = false;
                            if (!Intrinsics.areEqual(it.type, "entry")) continue;
                            destination$iv$iv /* !! */ .add(element$iv$iv);
                        }
                        var38_70 = (List)destination$iv$iv /* !! */ ;
                        var36_26.put(var37_63, var38_70.size());
                        $this$filter$iv = queuedCheckIns;
                        var37_63 = "entries_today";
                        var36_26 = data;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (QueuedCheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$checkOfflineWithoutData$4 = false;
                            if (!(Intrinsics.areEqual(new DateTime(it.getFullDatetime()).withZone(tz).toLocalDate(), dt.withZone(tz).toLocalDate()) != false && Intrinsics.areEqual(it.type, "entry") != false)) continue;
                            destination$iv$iv /* !! */ .add(element$iv$iv);
                        }
                        var38_70 = (List)destination$iv$iv /* !! */ ;
                        var36_26.put(var37_63, var38_70.size());
                        data.put("entries_since", new Function1<DateTime, Integer>(queuedCheckIns, tz){
                            final /* synthetic */ List<QueuedCheckIn> $queuedCheckIns;
                            final /* synthetic */ DateTimeZone $tz;
                            {
                                this.$queuedCheckIns = $queuedCheckIns;
                                this.$tz = $tz;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final Integer invoke(@NotNull DateTime cutoff) {
                                void $this$filterTo$iv$iv;
                                void $this$filter$iv;
                                Intrinsics.checkNotNullParameter(cutoff, "cutoff");
                                Iterable iterable = this.$queuedCheckIns;
                                DateTimeZone dateTimeZone = this.$tz;
                                boolean $i$f$filter = false;
                                void var5_5 = $this$filter$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$filterTo = false;
                                for (T element$iv$iv : $this$filterTo$iv$iv) {
                                    QueuedCheckIn it = (QueuedCheckIn)element$iv$iv;
                                    boolean bl = false;
                                    if (!(new DateTime(it.getFullDatetime()).withZone(dateTimeZone).isAfter(cutoff.minus(Duration.millis(1L))) && Intrinsics.areEqual(it.type, "entry"))) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                return ((List)destination$iv$iv).size();
                            }
                        });
                        data.put("entries_before", new Function1<DateTime, Integer>(queuedCheckIns, tz){
                            final /* synthetic */ List<QueuedCheckIn> $queuedCheckIns;
                            final /* synthetic */ DateTimeZone $tz;
                            {
                                this.$queuedCheckIns = $queuedCheckIns;
                                this.$tz = $tz;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final Integer invoke(@NotNull DateTime cutoff) {
                                void $this$filterTo$iv$iv;
                                void $this$filter$iv;
                                Intrinsics.checkNotNullParameter(cutoff, "cutoff");
                                Iterable iterable = this.$queuedCheckIns;
                                DateTimeZone dateTimeZone = this.$tz;
                                boolean $i$f$filter = false;
                                void var5_5 = $this$filter$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$filterTo = false;
                                for (T element$iv$iv : $this$filterTo$iv$iv) {
                                    QueuedCheckIn it = (QueuedCheckIn)element$iv$iv;
                                    boolean bl = false;
                                    if (!(new DateTime(it.getFullDatetime()).withZone(dateTimeZone).isBefore(cutoff) && Intrinsics.areEqual(it.type, "entry"))) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                return ((List)destination$iv$iv).size();
                            }
                        });
                        data.put("entries_days_since", new Function1<DateTime, Integer>(queuedCheckIns, tz){
                            final /* synthetic */ List<QueuedCheckIn> $queuedCheckIns;
                            final /* synthetic */ DateTimeZone $tz;
                            {
                                this.$queuedCheckIns = $queuedCheckIns;
                                this.$tz = $tz;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final Integer invoke(@NotNull DateTime cutoff) {
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                QueuedCheckIn it;
                                void $this$filterTo$iv$iv;
                                Iterable $this$filter$iv;
                                Intrinsics.checkNotNullParameter(cutoff, "cutoff");
                                Iterable iterable = this.$queuedCheckIns;
                                DateTimeZone dateTimeZone = this.$tz;
                                boolean $i$f$filter = false;
                                void var5_5 = $this$filter$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$filterTo = false;
                                for (T element$iv$iv : $this$filterTo$iv$iv) {
                                    it = (QueuedCheckIn)element$iv$iv;
                                    boolean bl = false;
                                    if (!(new DateTime(it.getFullDatetime()).withZone(dateTimeZone).isAfter(cutoff.minus(Duration.millis(1L))) && Intrinsics.areEqual(it.type, "entry"))) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                $this$filter$iv = (List)destination$iv$iv;
                                dateTimeZone = this.$tz;
                                boolean $i$f$map = false;
                                $this$filterTo$iv$iv = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    it = (QueuedCheckIn)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(new DateTime(it.getFullDatetime()).withZone(dateTimeZone).toLocalDate());
                                }
                                return CollectionsKt.toHashSet((List)destination$iv$iv).size();
                            }
                        });
                        data.put("entries_days_before", new Function1<DateTime, Integer>(queuedCheckIns, tz){
                            final /* synthetic */ List<QueuedCheckIn> $queuedCheckIns;
                            final /* synthetic */ DateTimeZone $tz;
                            {
                                this.$queuedCheckIns = $queuedCheckIns;
                                this.$tz = $tz;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final Integer invoke(@NotNull DateTime cutoff) {
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                QueuedCheckIn it;
                                void $this$filterTo$iv$iv;
                                Iterable $this$filter$iv;
                                Intrinsics.checkNotNullParameter(cutoff, "cutoff");
                                Iterable iterable = this.$queuedCheckIns;
                                DateTimeZone dateTimeZone = this.$tz;
                                boolean $i$f$filter = false;
                                void var5_5 = $this$filter$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$filterTo = false;
                                for (T element$iv$iv : $this$filterTo$iv$iv) {
                                    it = (QueuedCheckIn)element$iv$iv;
                                    boolean bl = false;
                                    if (!(new DateTime(it.getFullDatetime()).withZone(dateTimeZone).isBefore(cutoff) && Intrinsics.areEqual(it.type, "entry"))) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                $this$filter$iv = (List)destination$iv$iv;
                                dateTimeZone = this.$tz;
                                boolean $i$f$map = false;
                                $this$filterTo$iv$iv = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    it = (QueuedCheckIn)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(new DateTime(it.getFullDatetime()).withZone(dateTimeZone).toLocalDate());
                                }
                                return CollectionsKt.toHashSet((List)destination$iv$iv).size();
                            }
                        });
                        $this$filter$iv = queuedCheckIns;
                        var37_63 = "entries_days";
                        var36_26 = data;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (QueuedCheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$checkOfflineWithoutData$9 = false;
                            if (!Intrinsics.areEqual(it.type, "entry")) continue;
                            destination$iv$iv /* !! */ .add(element$iv$iv);
                        }
                        var38_70 = (List)destination$iv$iv /* !! */ ;
                        $this$filter$iv = var38_70;
                        $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            it = (QueuedCheckIn)item$iv$iv;
                            var38_70 = destination$iv$iv /* !! */ ;
                            $i$a$-map-AsyncCheckProvider$checkOfflineWithoutData$10 = false;
                            var38_70.add(new DateTime(it.getFullDatetime()).withZone(tz).toLocalDate());
                        }
                        var38_70 = (List)destination$iv$iv /* !! */ ;
                        var36_26.put(var37_63, CollectionsKt.toHashSet((Iterable)var38_70).size());
                        $this$filter$iv = queuedCheckIns;
                        $i$f$filter = false;
                        destination$iv$iv /* !! */  = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (QueuedCheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$checkOfflineWithoutData$minutes_since_entries$1 = false;
                            if (!Intrinsics.areEqual(it.type, "entry")) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            it = (QueuedCheckIn)item$iv$iv;
                            var36_26 = destination$iv$iv;
                            $i$a$-map-AsyncCheckProvider$checkOfflineWithoutData$minutes_since_entries$2 = false;
                            var36_26.add(new Duration(new DateTime(it.getFullDatetime()).withZone(tz), dt).toStandardMinutes().getMinutes());
                        }
                        minutes_since_entries = (List)destination$iv$iv;
                        v23 = (Integer)CollectionsKt.minOrNull(minutes_since_entries);
                        data.put("minutes_since_last_entry", v23 != null ? v23 : -1);
                        v24 = (Integer)CollectionsKt.maxOrNull(minutes_since_entries);
                        data.put("minutes_since_first_entry", v24 != null ? v24 : -1);
                        v25 = (QueuedCheckIn)CollectionsKt.lastOrNull(queuedCheckIns);
                        data.put("entry_status", Intrinsics.areEqual(v25 != null ? v25.getType() : null, "entry") != false ? "present" : "absent");
                        try {
                            if (!UtilsKt.getTruthy(jsonLogic.applyString(rules.toString(), data, false))) {
                                res.setType(TicketCheckProvider.CheckResult.Type.RULES);
                                res.setCheckinAllowed(false);
                                Intrinsics.checkNotNull(eventSlug);
                                AsyncCheckProvider.storeFailedCheckin$default(this, eventSlug, listId, "rules", ticketid, type, null, decoded.getItem(), decoded.getVariation(), decoded.getSubevent(), nonce, 32, null);
                                return res;
                            }
                        }
                        catch (Throwable e) {
                            res.setType(TicketCheckProvider.CheckResult.Type.RULES);
                            res.setCheckinAllowed(false);
                            res.setReasonExplanation("Custom rule evaluation failed (" + e + ")");
                            Intrinsics.checkNotNull(eventSlug);
                            AsyncCheckProvider.storeFailedCheckin$default(this, eventSlug, listId, "rules", ticketid, type, null, decoded.getItem(), decoded.getVariation(), decoded.getSubevent(), nonce, 32, null);
                            return res;
                        }
                    }
                    questions = item.getQuestions();
                    answerMap = new LinkedHashMap<K, V>();
                    if (answers != null) {
                        for (Answer a : answers) {
                            e = answerMap;
                            v26 = a.getQuestion();
                            Intrinsics.checkNotNull(v26, "null cannot be cast to non-null type eu.pretix.libpretixsync.db.Question");
                            Intrinsics.checkNotNullExpressionValue(((Question)v26).getServer_id(), "getServer_id(...)");
                            $this$mapTo$iv$iv = a.getValue();
                            e.put($i$f$map, $this$mapTo$iv$iv);
                        }
                    }
                    givenAnswers = new JSONArray();
                    required_answers = (List<TicketCheckProvider.QuestionAnswer>)new ArrayList<E>();
                    shown_answers = (List<TicketCheckProvider.QuestionAnswer>)new ArrayList<E>();
                    ask_questions = false;
                    if (type != TicketCheckProvider.CheckInType.EXIT && allowQuestions) {
                        Intrinsics.checkNotNull(questions);
                        rsa = this.extractRequiredShownAnswers(questions, answerMap);
                        givenAnswers = rsa.getGivenAnswers();
                        required_answers = rsa.getRequiredAnswers();
                        shown_answers = rsa.getShownAnswers();
                        ask_questions = rsa.getAskQuestions();
                    }
                    res.setShownAnswers(shown_answers);
                    if (!ask_questions || required_answers.size() <= 0) break block52;
                    res.setCheckinAllowed(true);
                    res.setType(TicketCheckProvider.CheckResult.Type.ANSWERS_REQUIRED);
                    res.setRequiredAnswers(required_answers);
                    break block53;
                }
                if (type == TicketCheckProvider.CheckInType.EXIT || list.isAllowMultipleEntries() || queuedCheckIns.isEmpty()) ** GOTO lbl-1000
                $this$all$iv = queuedCheckIns;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v27 = true;
                } else {
                    for (T element$iv : $this$all$iv) {
                        it = (QueuedCheckIn)element$iv;
                        $i$a$-all-AsyncCheckProvider$checkOfflineWithoutData$entry_allowed$1 = false;
                        if (Intrinsics.areEqual(it.type, "exit")) continue;
                        v27 = false;
                        break block50;
                    }
                    v27 = true;
                }
            }
            if (v27 || list.isAllowEntryAfterExit() && Intrinsics.areEqual(((QueuedCheckIn)CollectionsKt.last(queuedCheckIns)).type, "exit")) lbl-1000:
            // 2 sources

            {
                v28 = true;
            } else {
                v28 = entry_allowed = false;
            }
            if (!entry_allowed) {
                res.setCheckinAllowed(false);
                res.setFirstScanned(((QueuedCheckIn)CollectionsKt.first(queuedCheckIns)).getFullDatetime());
                res.setType(TicketCheckProvider.CheckResult.Type.USED);
                Intrinsics.checkNotNull(eventSlug);
                AsyncCheckProvider.storeFailedCheckin$default(this, eventSlug, listId, "already_redeemed", ticketid, type, null, decoded.getItem(), decoded.getVariation(), decoded.getSubevent(), nonce, 32, null);
            } else {
                res.setCheckinAllowed(true);
                res.setType(TicketCheckProvider.CheckResult.Type.VALID);
                qci = new QueuedCheckIn();
                if (nonce != null) {
                    qci.setNonce(nonce);
                } else {
                    qci.generateNonce();
                }
                qci.setSecret(ticketid);
                qci.setDatetime(dt.toDate());
                qci.setDatetime_string(QueuedCheckIn.formatDatetime(dt.toDate()));
                qci.setAnswers(givenAnswers.toString());
                qci.setEvent_slug(eventSlug);
                var31_62 = type.toString();
                v29 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(v29, "getDefault(...)");
                v30 = var31_62.toLowerCase(v29);
                Intrinsics.checkNotNullExpressionValue(v30, "toLowerCase(...)");
                qci.setType(v30);
                qci.setCheckinListId(listId);
                this.dataStore.insert(qci);
            }
        }
        return res;
    }

    @Override
    @NotNull
    public TicketCheckProvider.CheckResult check(@NotNull Map<String, Long> eventsAndCheckinLists, @NotNull String ticketid) {
        Intrinsics.checkNotNullParameter(eventsAndCheckinLists, "eventsAndCheckinLists");
        Intrinsics.checkNotNullParameter(ticketid, "ticketid");
        return TicketCheckProvider.DefaultImpls.check$default(this, eventsAndCheckinLists, ticketid, "barcode", new ArrayList(), false, true, TicketCheckProvider.CheckInType.ENTRY, null, false, 384, null);
    }

    @Override
    @NotNull
    public TicketCheckProvider.CheckResult check(@NotNull Map<String, Long> eventsAndCheckinLists, @NotNull String ticketid, @NotNull String source_type, @Nullable List<Answer> answers, boolean ignore_unpaid, boolean with_badge_data, @NotNull TicketCheckProvider.CheckInType type2, @Nullable String nonce, boolean allowQuestions) {
        Intrinsics.checkNotNullParameter(eventsAndCheckinLists, "eventsAndCheckinLists");
        Intrinsics.checkNotNullParameter(ticketid, "ticketid");
        Intrinsics.checkNotNullParameter(source_type, "source_type");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        String ticketid_cleaned = InputUtilsKt.cleanInput(ticketid, source_type);
        this.sentry.addBreadcrumb("provider.check", "offline check started");
        JoinOn joinOn = this.dataStore.select(OrderPosition.class, new QueryAttribute[0]).leftJoin(Order.class);
        QueryExpression<Long> queryExpression = OrderPosition.ORDER_ID;
        Intrinsics.checkNotNullExpressionValue(queryExpression, "ORDER_ID");
        List tickets = ((Result)((WhereAndOr)joinOn.on((Condition)Order.ID.eq(queryExpression)).where((Condition)OrderPosition.SECRET.eq((Object)ticketid_cleaned)).and((Condition)Order.EVENT_SLUG.in((Collection)CollectionsKt.toList((Iterable)eventsAndCheckinLists.keySet())))).get()).toList();
        if (tickets.size() == 0) {
            JoinOn joinOn2 = this.dataStore.select(ReusableMedium.class, new QueryAttribute[0]).leftJoin(OrderPosition.class);
            NumericAttributeDelegate<ReusableMedium, Long> numericAttributeDelegate = ReusableMedium.LINKED_ORDERPOSITION_ID;
            Intrinsics.checkNotNullExpressionValue(numericAttributeDelegate, "LINKED_ORDERPOSITION_ID");
            JoinOn joinOn3 = joinOn2.on((Condition)OrderPosition.SERVER_ID.eq(numericAttributeDelegate)).leftJoin(Order.class);
            QueryExpression<Long> queryExpression2 = OrderPosition.ORDER_ID;
            Intrinsics.checkNotNullExpressionValue(queryExpression2, "ORDER_ID");
            ReusableMedium medium = (ReusableMedium)((Result)((WhereAndOr)((WhereAndOr)joinOn3.on((Condition)Order.ID.eq(queryExpression2)).where((Condition)ReusableMedium.IDENTIFIER.eq((Object)ticketid_cleaned)).and((Condition)ReusableMedium.TYPE.eq((Object)source_type))).and((Condition)Order.EVENT_SLUG.in((Collection)CollectionsKt.toList((Iterable)eventsAndCheckinLists.keySet())))).get()).firstOrNull();
            if (medium != null) {
                JoinOn joinOn4 = this.dataStore.select(OrderPosition.class, new QueryAttribute[0]).leftJoin(Order.class);
                QueryExpression<Long> queryExpression3 = OrderPosition.ORDER_ID;
                Intrinsics.checkNotNullExpressionValue(queryExpression3, "ORDER_ID");
                List tickets2 = ((Result)((WhereAndOr)joinOn4.on((Condition)Order.ID.eq(queryExpression3)).where((Condition)OrderPosition.SERVER_ID.eq((Object)medium.getLinked_orderposition_id())).and((Condition)Order.EVENT_SLUG.in((Collection)CollectionsKt.toList((Iterable)eventsAndCheckinLists.keySet())))).get()).toList();
                Intrinsics.checkNotNull(tickets2);
                return this.checkOfflineWithData(eventsAndCheckinLists, ticketid_cleaned, tickets2, answers, ignore_unpaid, type2, nonce, allowQuestions);
            }
            List<Answer> list = answers;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return this.checkOfflineWithoutData(eventsAndCheckinLists, ticketid_cleaned, type2, list, nonce, allowQuestions);
        }
        if (tickets.size() > 1) {
            String eventSlug = ((OrderPosition)tickets.get(0)).getOrder().getEvent_slug();
            Intrinsics.checkNotNull(eventSlug);
            Long l = eventsAndCheckinLists.get(eventSlug);
            if (l == null) {
                return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, "No check-in list selected", true);
            }
            this.storeFailedCheckin(eventSlug, l, "ambiguous", ticketid_cleaned, type2, ((OrderPosition)tickets.get(0)).getServer_id(), ((OrderPosition)tickets.get(0)).getItem().getServer_id(), ((OrderPosition)tickets.get(0)).getVariation_id(), ((OrderPosition)tickets.get(0)).getSubevent_id(), nonce);
            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.AMBIGUOUS, false, 2, null);
        }
        Intrinsics.checkNotNull(tickets);
        return this.checkOfflineWithData(eventsAndCheckinLists, ticketid_cleaned, tickets, answers, ignore_unpaid, type2, nonce, allowQuestions);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final TicketCheckProvider.CheckResult checkOfflineWithData(Map<String, Long> eventsAndCheckinLists, String secret, List<? extends OrderPosition> tickets, List<Answer> answers, boolean ignore_unpaid, TicketCheckProvider.CheckInType type, String nonce, boolean allowQuestions) {
        block60: {
            block58: {
                block59: {
                    dt = this.now();
                    eventSlug = tickets.get(0).getOrder().getEvent_slug();
                    var12_11 = (Event)((Result)this.dataStore.select(Event.class, new QueryAttribute[0]).where((Condition)Event.SLUG.eq((Object)eventSlug)).get()).firstOrNull();
                    if (var12_11 == null) {
                        return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, "Event not found", true);
                    }
                    event = var12_11;
                    v0 = eventsAndCheckinLists.get(eventSlug);
                    if (v0 == null) {
                        return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, "No check-in list selected", true);
                    }
                    listId = v0;
                    var15_14 = (CheckInList)((Result)((WhereAndOr)this.dataStore.select(CheckInList.class, new QueryAttribute[0]).where((Condition)CheckInList.SERVER_ID.eq((Object)listId)).and((Condition)CheckInList.EVENT_SLUG.eq((Object)eventSlug))).get()).firstOrNull();
                    if (var15_14 == null) {
                        return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, "Check-in list not found", true);
                    }
                    list = var15_14;
                    if (list.isAddonMatch()) {
                        var17_16 /* !! */  = new OrderPosition[]{tickets.get(0)};
                        candidates = CollectionsKt.mutableListOf(var17_16 /* !! */ );
                        v1 = tickets.get(0).getOrder().getPositions();
                        Intrinsics.checkNotNullExpressionValue(v1, "getPositions(...)");
                        var17_16 /* !! */  = v1;
                        var39_18 = candidates;
                        $i$f$filter = false;
                        var19_22 = $this$filter$iv;
                        destination$iv$iv = (Expression[])new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (OrderPosition)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$checkOfflineWithData$position$1 = false;
                            if (!Intrinsics.areEqual(it.getAddonToId(), tickets.get(0).getServer_id())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        var39_18.addAll((List)destination$iv$iv);
                        if (!list.all_items) {
                            destination$iv$iv = new Expression[]{CheckInList_Item.ITEM_ID};
                            v2 = ((Result)this.dataStore.select(destination$iv$iv).where((Condition)CheckInList_Item.CHECK_IN_LIST_ID.eq((Object)list.getId())).get()).toList();
                            Intrinsics.checkNotNullExpressionValue(v2, "toList(...)");
                            $this$map$iv = v2;
                            $i$f$map = false;
                            $i$f$filterTo = $this$map$iv;
                            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                            $i$f$mapTo = false;
                            it = $this$mapTo$iv$iv.iterator();
                            while (it.hasNext()) {
                                item$iv$iv = it.next();
                                var26_44 = (Tuple)item$iv$iv;
                                var39_18 = destination$iv$iv;
                                $i$a$-map-AsyncCheckProvider$checkOfflineWithData$position$filteredCandidates$items$1 = false;
                                var39_18.add((Long)it.get(0));
                            }
                            items = CollectionsKt.toHashSet((List)destination$iv$iv);
                            $this$filter$iv = candidates;
                            $i$f$filter = false;
                            $this$mapTo$iv$iv = $this$filter$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                candidate = (OrderPosition)element$iv$iv;
                                $i$a$-filter-AsyncCheckProvider$checkOfflineWithData$position$filteredCandidates$1 = false;
                                if (!items.contains(candidate.getItem().getId())) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            v3 = (List)destination$iv$iv;
                        } else {
                            v3 = filteredCandidates = candidates;
                        }
                        if (filteredCandidates.isEmpty()) {
                            Intrinsics.checkNotNull(eventSlug);
                            v4 = list.getServer_id();
                            Intrinsics.checkNotNullExpressionValue(v4, "getServer_id(...)");
                            this.storeFailedCheckin(eventSlug, ((Number)v4).longValue(), "product", secret, type, tickets.get(0).getServer_id(), tickets.get(0).getItem().getServer_id(), tickets.get(0).getVariation_id(), tickets.get(0).getSubevent_id(), nonce);
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.PRODUCT, true);
                        }
                        if (filteredCandidates.size() > 1) {
                            Intrinsics.checkNotNull(eventSlug);
                            v5 = list.getServer_id();
                            Intrinsics.checkNotNullExpressionValue(v5, "getServer_id(...)");
                            this.storeFailedCheckin(eventSlug, ((Number)v5).longValue(), "ambiguous", secret, type, tickets.get(0).getServer_id(), tickets.get(0).getItem().getServer_id(), tickets.get(0).getVariation_id(), tickets.get(0).getSubevent_id(), nonce);
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.AMBIGUOUS, true);
                        }
                        v6 = filteredCandidates.get(0);
                    } else {
                        v6 = tickets.get(0);
                    }
                    position = v6;
                    item = position.getItem();
                    order = position.getOrder();
                    jPosition = null;
                    try {
                        $this$filter$iv = position.getJSON();
                        Intrinsics.checkNotNull($this$filter$iv);
                    }
                    catch (JSONException e) {
                        this.sentry.captureException(e);
                        Intrinsics.checkNotNull(eventSlug);
                        v7 = list.getServer_id();
                        Intrinsics.checkNotNullExpressionValue(v7, "getServer_id(...)");
                        v8 = ((Number)v7).longValue();
                        v9 = position.secret;
                        Intrinsics.checkNotNullExpressionValue(v9, "secret");
                        this.storeFailedCheckin(eventSlug, v8, "error", v9, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id(), nonce);
                        return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, true);
                    }
                    jPosition = $this$filter$iv;
                    res = new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.ERROR, true);
                    res.setScanType(type);
                    res.setTicket(position.getItem().getInternalName());
                    varid = position.getVariationId();
                    if (varid != null) {
                        try {
                            destination$iv$iv = item.getVariation(varid);
                        }
                        catch (JSONException e) {
                            this.sentry.captureException(e);
                            destination$iv$iv = null;
                        }
                        v10 = destination$iv$iv;
                    } else {
                        v10 = variation = null;
                    }
                    if (variation != null) {
                        res.setVariation(variation.getStringValue());
                    }
                    res.setAttendee_name(position.attendee_name);
                    res.setSeat(position.getSeatName());
                    res.setOrderCode(position.getOrder().getCode());
                    res.setPositionId(position.getPositionid());
                    res.setPosition(jPosition);
                    res.setEventSlug(list.event_slug);
                    require_attention = position.getOrder().isCheckin_attention();
                    try {
                        require_attention = require_attention != false || item.getJSON().optBoolean("checkin_attention", false) != false;
                    }
                    catch (JSONException e) {
                        this.sentry.captureException(e);
                    }
                    if (require_attention) ** GOTO lbl-1000
                    v11 = variation;
                    v12 = v11 != null ? v11.isCheckin_attention() : false;
                    if (v12) lbl-1000:
                    // 2 sources

                    {
                        v13 = true;
                    } else {
                        v13 = false;
                    }
                    res.setRequireAttention(v13);
                    e /* !! */  = new String[3];
                    v14 = order.checkin_text;
                    e /* !! */ [0] = v14 != null ? StringsKt.trim((CharSequence)v14).toString() : null;
                    v15 = variation;
                    e /* !! */ [1] = v15 != null && (v15 = v15.getCheckin_text()) != null ? StringsKt.trim((CharSequence)v15).toString() : null;
                    v16 = item.checkin_text;
                    e /* !! */ [2] = v16 != null ? StringsKt.trim((CharSequence)v16).toString() : null;
                    e /* !! */  = CollectionsKt.listOfNotNull(e /* !! */ );
                    var39_18 = res;
                    $i$f$filterNot = false;
                    element$iv$iv = $this$filterNot$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterNotTo = false;
                    for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                        it = (String)element$iv$iv;
                        $i$a$-filterNot-AsyncCheckProvider$checkOfflineWithData$1 = false;
                        if (StringsKt.isBlank(it) != false || Intrinsics.areEqual(it, "null") != false) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    var39_18.setCheckinTexts((List)destination$iv$iv);
                    storedCheckIns = ((Result)this.dataStore.select(CheckIn.class, new QueryAttribute[0]).where((Condition)CheckIn.POSITION_ID.eq(position.getId())).get()).toList();
                    Intrinsics.checkNotNull(storedCheckIns);
                    $this$filter$iv = (Function1[])storedCheckIns;
                    $i$f$filter = false;
                    $i$f$filterNotTo = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (E element$iv$iv : $this$filterTo$iv$iv) {
                        it = (CheckIn)element$iv$iv;
                        $i$a$-filter-AsyncCheckProvider$checkOfflineWithData$checkIns$1 = false;
                        v17 = it.getListId();
                        var34_72 = listId;
                        if (!(v17 != null && v17 == var34_72)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = new Function1[]{checkOfflineWithData.checkIns.2.INSTANCE, checkOfflineWithData.checkIns.3.INSTANCE};
                    checkIns = CollectionsKt.sortedWith((List)destination$iv$iv, ComparisonsKt.compareBy($this$filter$iv));
                    if (!Intrinsics.areEqual(order.getStatus(), "p") && !Intrinsics.areEqual(order.getStatus(), "n")) {
                        res.setType(TicketCheckProvider.CheckResult.Type.CANCELED);
                        res.setCheckinAllowed(false);
                        Intrinsics.checkNotNull(eventSlug);
                        v18 = list.getServer_id();
                        Intrinsics.checkNotNullExpressionValue(v18, "getServer_id(...)");
                        v19 = ((Number)v18).longValue();
                        v20 = position.secret;
                        Intrinsics.checkNotNullExpressionValue(v20, "secret");
                        this.storeFailedCheckin(eventSlug, v19, "canceled", v20, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id(), nonce);
                        return res;
                    }
                    if (position.isBlocked()) {
                        res.setType(TicketCheckProvider.CheckResult.Type.BLOCKED);
                        res.setCheckinAllowed(false);
                        Intrinsics.checkNotNull(eventSlug);
                        v21 = list.getServer_id();
                        Intrinsics.checkNotNullExpressionValue(v21, "getServer_id(...)");
                        v22 = ((Number)v21).longValue();
                        v23 = position.secret;
                        Intrinsics.checkNotNullExpressionValue(v23, "secret");
                        this.storeFailedCheckin(eventSlug, v22, "blocked", v23, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id(), nonce);
                        return res;
                    }
                    if (!Intrinsics.areEqual(order.status, "p") && order.isRequireApproval()) {
                        res.setType(TicketCheckProvider.CheckResult.Type.UNAPPROVED);
                        res.setCheckinAllowed(false);
                        Intrinsics.checkNotNull(eventSlug);
                        v24 = list.getServer_id();
                        Intrinsics.checkNotNullExpressionValue(v24, "getServer_id(...)");
                        v25 = ((Number)v24).longValue();
                        v26 = position.secret;
                        Intrinsics.checkNotNullExpressionValue(v26, "secret");
                        this.storeFailedCheckin(eventSlug, v25, "unapproved", v26, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id(), nonce);
                        return res;
                    }
                    if (type != TicketCheckProvider.CheckInType.EXIT) {
                        validFrom = position.getValidFrom();
                        if (validFrom != null && validFrom.isAfter(this.now())) {
                            res.setType(TicketCheckProvider.CheckResult.Type.INVALID_TIME);
                            res.setCheckinAllowed(false);
                            Intrinsics.checkNotNull(eventSlug);
                            v27 = list.getServer_id();
                            Intrinsics.checkNotNullExpressionValue(v27, "getServer_id(...)");
                            v28 = ((Number)v27).longValue();
                            v29 = position.secret;
                            Intrinsics.checkNotNullExpressionValue(v29, "secret");
                            this.storeFailedCheckin(eventSlug, v28, "invalid_time", v29, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id(), nonce);
                            return res;
                        }
                        validUntil = position.getValidUntil();
                        if (validUntil != null && validUntil.isBefore(this.now())) {
                            res.setType(TicketCheckProvider.CheckResult.Type.INVALID_TIME);
                            res.setCheckinAllowed(false);
                            Intrinsics.checkNotNull(eventSlug);
                            v30 = list.getServer_id();
                            Intrinsics.checkNotNullExpressionValue(v30, "getServer_id(...)");
                            v31 = ((Number)v30).longValue();
                            v32 = position.secret;
                            Intrinsics.checkNotNullExpressionValue(v32, "secret");
                            this.storeFailedCheckin(eventSlug, v31, "invalid_time", v32, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id(), nonce);
                            return res;
                        }
                    }
                    if (!list.all_items) {
                        v33 = is_in_list = (Integer)((Scalar)((WhereAndOr)this.dataStore.count(CheckInList_Item.class).where((Condition)CheckInList_Item.ITEM_ID.eq((Object)item.getId())).and((Condition)CheckInList_Item.CHECK_IN_LIST_ID.eq((Object)list.getId()))).get()).value();
                        if (v33 != null && v33 == 0) {
                            Intrinsics.checkNotNull(eventSlug);
                            v34 = list.getServer_id();
                            Intrinsics.checkNotNullExpressionValue(v34, "getServer_id(...)");
                            v35 = ((Number)v34).longValue();
                            v36 = position.secret;
                            Intrinsics.checkNotNullExpressionValue(v36, "secret");
                            this.storeFailedCheckin(eventSlug, v35, "product", v36, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id(), nonce);
                            res.setType(TicketCheckProvider.CheckResult.Type.PRODUCT);
                            res.setCheckinAllowed(false);
                            return res;
                        }
                    }
                    if (list.getSubevent_id() != null) {
                        v37 = list.getSubevent_id();
                        Intrinsics.checkNotNullExpressionValue(v37, "getSubevent_id(...)");
                        if (((Number)v37).longValue() > 0L && !Intrinsics.areEqual(list.getSubevent_id(), position.getSubeventId())) {
                            Intrinsics.checkNotNull(eventSlug);
                            v38 = list.getServer_id();
                            Intrinsics.checkNotNullExpressionValue(v38, "getServer_id(...)");
                            v39 = ((Number)v38).longValue();
                            v40 = position.secret;
                            Intrinsics.checkNotNullExpressionValue(v40, "secret");
                            this.storeFailedCheckin(eventSlug, v39, "invalid", v40, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id(), nonce);
                            return new TicketCheckProvider.CheckResult(TicketCheckProvider.CheckResult.Type.INVALID, true);
                        }
                    }
                    if (!(order.isValidStatus() || ignore_unpaid && list.include_pending)) {
                        res.setType(TicketCheckProvider.CheckResult.Type.UNPAID);
                        res.setCheckinAllowed(list.include_pending != false && order.isValid_if_pending() == false);
                        Intrinsics.checkNotNull(eventSlug);
                        v41 = list.getServer_id();
                        Intrinsics.checkNotNullExpressionValue(v41, "getServer_id(...)");
                        v42 = ((Number)v41).longValue();
                        v43 = position.secret;
                        Intrinsics.checkNotNullExpressionValue(v43, "secret");
                        this.storeFailedCheckin(eventSlug, v42, "unpaid", v43, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id(), nonce);
                        return res;
                    }
                    rules = list.getRules();
                    if (type == TicketCheckProvider.CheckInType.ENTRY && rules != null && rules.length() > 0) {
                        data = new LinkedHashMap<K, V>();
                        tz = DateTimeZone.forID(event.getTimezone());
                        v44 = position.getSubevent_id();
                        Intrinsics.checkNotNullExpressionValue(v44, "getSubevent_id(...)");
                        v45 = ((Number)v44).longValue();
                        Intrinsics.checkNotNull(tz);
                        jsonLogic = this.initJsonLogic(event, v45, tz);
                        data.put("product", String.valueOf(position.getItem().getServer_id()));
                        data.put("variation", String.valueOf(position.getVariation_id()));
                        data.put("gate", String.valueOf(this.config.getDeviceKnownGateID()));
                        data.put("now", dt);
                        data.put("now_isoweekday", dt.withZone(tz).dayOfWeek().get());
                        $i$f$filterTo = checkIns;
                        var40_77 = "entries_number";
                        var39_18 = data;
                        $i$f$filter = false;
                        element$iv$iv = $this$filter$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (CheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$checkOfflineWithData$2 = false;
                            if (!Intrinsics.areEqual(it.type, "entry")) continue;
                            destination$iv$iv /* !! */ .add(element$iv$iv);
                        }
                        var41_84 = (List)destination$iv$iv /* !! */ ;
                        var39_18.put(var40_77, var41_84.size());
                        $this$filter$iv = checkIns;
                        var40_77 = "entries_today";
                        var39_18 = data;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (CheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$checkOfflineWithData$3 = false;
                            if (!(Intrinsics.areEqual(new DateTime(it.getFullDatetime()).withZone(tz).toLocalDate(), dt.withZone(tz).toLocalDate()) != false && Intrinsics.areEqual(it.type, "entry") != false)) continue;
                            destination$iv$iv /* !! */ .add(element$iv$iv);
                        }
                        var41_84 = (List)destination$iv$iv /* !! */ ;
                        var39_18.put(var40_77, var41_84.size());
                        data.put("entries_since", new Function1<DateTime, Integer>(checkIns, tz){
                            final /* synthetic */ List<CheckIn> $checkIns;
                            final /* synthetic */ DateTimeZone $tz;
                            {
                                this.$checkIns = $checkIns;
                                this.$tz = $tz;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final Integer invoke(@NotNull DateTime cutoff) {
                                void $this$filterTo$iv$iv;
                                void $this$filter$iv;
                                Intrinsics.checkNotNullParameter(cutoff, "cutoff");
                                Iterable iterable = this.$checkIns;
                                DateTimeZone dateTimeZone = this.$tz;
                                boolean $i$f$filter = false;
                                void var5_5 = $this$filter$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$filterTo = false;
                                for (T element$iv$iv : $this$filterTo$iv$iv) {
                                    CheckIn it = (CheckIn)element$iv$iv;
                                    boolean bl = false;
                                    if (!(new DateTime(it.getFullDatetime()).withZone(dateTimeZone).isAfter(cutoff.minus(Duration.millis(1L))) && Intrinsics.areEqual(it.type, "entry"))) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                return ((List)destination$iv$iv).size();
                            }
                        });
                        data.put("entries_days_since", new Function1<DateTime, Integer>(checkIns, tz){
                            final /* synthetic */ List<CheckIn> $checkIns;
                            final /* synthetic */ DateTimeZone $tz;
                            {
                                this.$checkIns = $checkIns;
                                this.$tz = $tz;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final Integer invoke(@NotNull DateTime cutoff) {
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                CheckIn it;
                                void $this$filterTo$iv$iv;
                                Iterable $this$filter$iv;
                                Intrinsics.checkNotNullParameter(cutoff, "cutoff");
                                Iterable iterable = this.$checkIns;
                                DateTimeZone dateTimeZone = this.$tz;
                                boolean $i$f$filter = false;
                                void var5_5 = $this$filter$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$filterTo = false;
                                for (T element$iv$iv : $this$filterTo$iv$iv) {
                                    it = (CheckIn)element$iv$iv;
                                    boolean bl = false;
                                    if (!(new DateTime(it.getFullDatetime()).withZone(dateTimeZone).isAfter(cutoff.minus(Duration.millis(1L))) && Intrinsics.areEqual(it.type, "entry"))) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                $this$filter$iv = (List)destination$iv$iv;
                                dateTimeZone = this.$tz;
                                boolean $i$f$map = false;
                                $this$filterTo$iv$iv = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    it = (CheckIn)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(new DateTime(it.getFullDatetime()).withZone(dateTimeZone).toLocalDate());
                                }
                                return CollectionsKt.toHashSet((List)destination$iv$iv).size();
                            }
                        });
                        data.put("entries_before", new Function1<DateTime, Integer>(checkIns, tz){
                            final /* synthetic */ List<CheckIn> $checkIns;
                            final /* synthetic */ DateTimeZone $tz;
                            {
                                this.$checkIns = $checkIns;
                                this.$tz = $tz;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final Integer invoke(@NotNull DateTime cutoff) {
                                void $this$filterTo$iv$iv;
                                void $this$filter$iv;
                                Intrinsics.checkNotNullParameter(cutoff, "cutoff");
                                Iterable iterable = this.$checkIns;
                                DateTimeZone dateTimeZone = this.$tz;
                                boolean $i$f$filter = false;
                                void var5_5 = $this$filter$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$filterTo = false;
                                for (T element$iv$iv : $this$filterTo$iv$iv) {
                                    CheckIn it = (CheckIn)element$iv$iv;
                                    boolean bl = false;
                                    if (!(new DateTime(it.getFullDatetime()).withZone(dateTimeZone).isBefore(cutoff) && Intrinsics.areEqual(it.type, "entry"))) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                return ((List)destination$iv$iv).size();
                            }
                        });
                        data.put("entries_days_before", new Function1<DateTime, Integer>(checkIns, tz){
                            final /* synthetic */ List<CheckIn> $checkIns;
                            final /* synthetic */ DateTimeZone $tz;
                            {
                                this.$checkIns = $checkIns;
                                this.$tz = $tz;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final Integer invoke(@NotNull DateTime cutoff) {
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                CheckIn it;
                                void $this$filterTo$iv$iv;
                                Iterable $this$filter$iv;
                                Intrinsics.checkNotNullParameter(cutoff, "cutoff");
                                Iterable iterable = this.$checkIns;
                                DateTimeZone dateTimeZone = this.$tz;
                                boolean $i$f$filter = false;
                                void var5_5 = $this$filter$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$filterTo = false;
                                for (T element$iv$iv : $this$filterTo$iv$iv) {
                                    it = (CheckIn)element$iv$iv;
                                    boolean bl = false;
                                    if (!(new DateTime(it.getFullDatetime()).withZone(dateTimeZone).isBefore(cutoff) && Intrinsics.areEqual(it.type, "entry"))) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                $this$filter$iv = (List)destination$iv$iv;
                                dateTimeZone = this.$tz;
                                boolean $i$f$map = false;
                                $this$filterTo$iv$iv = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    it = (CheckIn)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(new DateTime(it.getFullDatetime()).withZone(dateTimeZone).toLocalDate());
                                }
                                return CollectionsKt.toHashSet((List)destination$iv$iv).size();
                            }
                        });
                        $this$filter$iv = checkIns;
                        var40_77 = "entries_days";
                        var39_18 = data;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (CheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$checkOfflineWithData$8 = false;
                            if (!Intrinsics.areEqual(it.type, "entry")) continue;
                            destination$iv$iv /* !! */ .add(element$iv$iv);
                        }
                        var41_84 = (List)destination$iv$iv /* !! */ ;
                        $this$filter$iv = var41_84;
                        $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            it = (CheckIn)item$iv$iv;
                            var41_84 = destination$iv$iv /* !! */ ;
                            $i$a$-map-AsyncCheckProvider$checkOfflineWithData$9 = false;
                            var41_84.add(new DateTime(it.getFullDatetime()).withZone(tz).toLocalDate());
                        }
                        var41_84 = (List)destination$iv$iv /* !! */ ;
                        var39_18.put(var40_77, CollectionsKt.toHashSet((Iterable)var41_84).size());
                        $this$filter$iv = checkIns;
                        $i$f$filter = false;
                        destination$iv$iv /* !! */  = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (CheckIn)element$iv$iv;
                            $i$a$-filter-AsyncCheckProvider$checkOfflineWithData$minutes_since_entries$1 = false;
                            if (!Intrinsics.areEqual(it.type, "entry")) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        $i$f$mapTo = false;
                        var35_78 = $this$mapTo$iv$iv.iterator();
                        while (var35_78.hasNext()) {
                            item$iv$iv = var35_78.next();
                            it = (CheckIn)item$iv$iv;
                            var39_18 = destination$iv$iv;
                            $i$a$-map-AsyncCheckProvider$checkOfflineWithData$minutes_since_entries$2 = false;
                            var39_18.add(new Duration(new DateTime(it.getFullDatetime()).withZone(tz), dt).toStandardMinutes().getMinutes());
                        }
                        minutes_since_entries = (List)destination$iv$iv;
                        v46 = (Integer)CollectionsKt.minOrNull(minutes_since_entries);
                        data.put("minutes_since_last_entry", v46 != null ? v46 : -1);
                        v47 = (Integer)CollectionsKt.maxOrNull(minutes_since_entries);
                        data.put("minutes_since_first_entry", v47 != null ? v47 : -1);
                        v48 = (CheckIn)CollectionsKt.lastOrNull(checkIns);
                        data.put("entry_status", Intrinsics.areEqual(v48 != null ? v48.getType() : null, "entry") != false ? "present" : "absent");
                        try {
                            if (!UtilsKt.getTruthy(jsonLogic.applyString(rules.toString(), data, false))) {
                                res.setType(TicketCheckProvider.CheckResult.Type.RULES);
                                res.setCheckinAllowed(false);
                                Intrinsics.checkNotNull(eventSlug);
                                v49 = list.getServer_id();
                                Intrinsics.checkNotNullExpressionValue(v49, "getServer_id(...)");
                                v50 = ((Number)v49).longValue();
                                v51 = position.secret;
                                Intrinsics.checkNotNullExpressionValue(v51, "secret");
                                this.storeFailedCheckin(eventSlug, v50, "rules", v51, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id(), nonce);
                                return res;
                            }
                        }
                        catch (Throwable e) {
                            res.setType(TicketCheckProvider.CheckResult.Type.RULES);
                            res.setCheckinAllowed(false);
                            res.setReasonExplanation("Custom rule evaluation failed (" + e + ")");
                            Intrinsics.checkNotNull(eventSlug);
                            v52 = list.getServer_id();
                            Intrinsics.checkNotNullExpressionValue(v52, "getServer_id(...)");
                            v53 = ((Number)v52).longValue();
                            v54 = position.secret;
                            Intrinsics.checkNotNullExpressionValue(v54, "secret");
                            this.storeFailedCheckin(eventSlug, v53, "rules", v54, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id(), nonce);
                            return res;
                        }
                    }
                    questions = item.getQuestions();
                    answerMap = position.getAnswers();
                    if (answers != null) {
                        for (Answer a : answers) {
                            Intrinsics.checkNotNull(answerMap);
                            e = answerMap;
                            v55 = a.getQuestion();
                            Intrinsics.checkNotNull(v55, "null cannot be cast to non-null type eu.pretix.libpretixsync.db.Question");
                            $i$f$map = ((Question)v55).getServer_id();
                            $this$mapTo$iv$iv = a.getValue();
                            e.put($i$f$map, $this$mapTo$iv$iv);
                        }
                    }
                    givenAnswers = new JSONArray();
                    required_answers = (List<TicketCheckProvider.QuestionAnswer>)new ArrayList<E>();
                    shown_answers = (List<TicketCheckProvider.QuestionAnswer>)new ArrayList<E>();
                    ask_questions = false;
                    if (type != TicketCheckProvider.CheckInType.EXIT && allowQuestions) {
                        Intrinsics.checkNotNull(questions);
                        Intrinsics.checkNotNull(answerMap);
                        rsa = this.extractRequiredShownAnswers(questions, answerMap);
                        givenAnswers = rsa.getGivenAnswers();
                        required_answers = rsa.getRequiredAnswers();
                        shown_answers = rsa.getShownAnswers();
                        ask_questions = rsa.getAskQuestions();
                    }
                    res.setShownAnswers(shown_answers);
                    if (!ask_questions || required_answers.size() <= 0) break block59;
                    res.setCheckinAllowed(true);
                    res.setType(TicketCheckProvider.CheckResult.Type.ANSWERS_REQUIRED);
                    res.setRequiredAnswers(required_answers);
                    break block60;
                }
                if (type == TicketCheckProvider.CheckInType.EXIT || list.isAllowMultipleEntries() || checkIns.isEmpty()) ** GOTO lbl-1000
                $this$all$iv = checkIns;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v56 = true;
                } else {
                    for (T element$iv : $this$all$iv) {
                        it = (CheckIn)element$iv;
                        $i$a$-all-AsyncCheckProvider$checkOfflineWithData$entry_allowed$1 = false;
                        if (Intrinsics.areEqual(it.type, "exit")) continue;
                        v56 = false;
                        break block58;
                    }
                    v56 = true;
                }
            }
            if (v56 || list.isAllowEntryAfterExit() && Intrinsics.areEqual(((CheckIn)CollectionsKt.last(checkIns)).type, "exit")) lbl-1000:
            // 2 sources

            {
                v57 = true;
            } else {
                v57 = entry_allowed = false;
            }
            if (!entry_allowed) {
                res.setCheckinAllowed(false);
                res.setFirstScanned(((CheckIn)CollectionsKt.first(checkIns)).getFullDatetime());
                res.setType(TicketCheckProvider.CheckResult.Type.USED);
                Intrinsics.checkNotNull(eventSlug);
                v58 = list.getServer_id();
                Intrinsics.checkNotNullExpressionValue(v58, "getServer_id(...)");
                v59 = ((Number)v58).longValue();
                v60 = position.secret;
                Intrinsics.checkNotNullExpressionValue(v60, "secret");
                this.storeFailedCheckin(eventSlug, v59, "already_redeemed", v60, type, position.getServer_id(), position.getItem().getServer_id(), position.getVariation_id(), position.getSubevent_id(), nonce);
            } else {
                res.setCheckinAllowed(true);
                res.setType(TicketCheckProvider.CheckResult.Type.VALID);
                qci = new QueuedCheckIn();
                if (nonce != null) {
                    qci.setNonce(nonce);
                } else {
                    qci.generateNonce();
                }
                qci.setSecret(position.secret);
                qci.setDatetime(dt.toDate());
                qci.setDatetime_string(QueuedCheckIn.formatDatetime(dt.toDate()));
                qci.setAnswers(givenAnswers.toString());
                qci.setEvent_slug(eventSlug);
                $i$f$all = type.toString();
                v61 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(v61, "getDefault(...)");
                v62 = $i$f$all.toLowerCase(v61);
                Intrinsics.checkNotNullExpressionValue(v62, "toLowerCase(...)");
                qci.setType(v62);
                qci.setCheckinListId(listId);
                this.dataStore.insert(qci);
                ci = new CheckIn();
                ci.setListId(listId);
                ci.setPosition(position);
                var35_78 = type.toString();
                v63 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(v63, "getDefault(...)");
                v64 = var35_78.toLowerCase(v63);
                Intrinsics.checkNotNullExpressionValue(v64, "toLowerCase(...)");
                ci.setType(v64);
                ci.setDatetime(dt.toDate());
                var35_78 = type.toString();
                v65 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(v65, "getDefault(...)");
                v66 = var35_78.toLowerCase(v65);
                Intrinsics.checkNotNullExpressionValue(v66, "toLowerCase(...)");
                ci.setJson_data("{\"local\": true, \"type\": \"" + v66 + "\", \"datetime\": \"" + QueuedCheckIn.formatDatetime(dt.toDate()) + "\"}");
                this.dataStore.insert(ci);
            }
        }
        return res;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public List<TicketCheckProvider.SearchResult> search(@NotNull Map<String, Long> eventsAndCheckinLists, @NotNull String query, int page) throws CheckException {
        Intrinsics.checkNotNullParameter(eventsAndCheckinLists, "eventsAndCheckinLists");
        Intrinsics.checkNotNullParameter(query, "query");
        var5_4 = query;
        v0 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(v0, "getDefault(...)");
        v1 = var5_4.toUpperCase(v0);
        Intrinsics.checkNotNullExpressionValue(v1, "toUpperCase(...)");
        query = v1;
        this.sentry.addBreadcrumb("provider.search", "offline search started");
        results = new ArrayList<E>();
        if (query.length() < 4) {
            return results;
        }
        search = null;
        v2 = ((LogicalCondition)((LogicalCondition)((LogicalCondition)OrderPosition.SECRET.upper().like(query + "%").or((Condition)OrderPosition.ATTENDEE_NAME.upper().like("%" + query + "%"))).or((Condition)OrderPosition.ATTENDEE_EMAIL.upper().like("%" + query + "%"))).or((Condition)Order.EMAIL.upper().like("%" + query + "%"))).or((Condition)Order.CODE.upper().like(query + "%"));
        Intrinsics.checkNotNullExpressionValue(v2, "or(...)");
        search = (LogicalCondition)v2;
        listfilters = null;
        for (Map.Entry<String, Long> entry : eventsAndCheckinLists.entrySet()) {
            var11_11 = (CheckInList)((Result)((WhereAndOr)this.dataStore.select(CheckInList.class, new QueryAttribute[0]).where((Condition)CheckInList.SERVER_ID.eq((Object)entry.getValue())).and((Condition)CheckInList.EVENT_SLUG.eq((Object)entry.getKey()))).get()).firstOrNull();
            if (var11_11 == null) {
                throw new CheckException("Check-in list not found", null, 2, null);
            }
            list = var11_11;
            listfilter = Order.EVENT_SLUG.eq((Object)entry.getKey());
            if (!list.all_items) {
                itemids = new ArrayList<E>();
                for (Item item : list.getItems()) {
                    v3 = item.getId();
                    Intrinsics.checkNotNullExpressionValue(v3, "getId(...)");
                    itemids.add(v3);
                }
                listfilter = (Logical)Item.ID.in((Collection)itemids).and((Condition)listfilter);
            }
            if (list.getSubevent_id() != null) {
                v4 = list.getSubevent_id();
                Intrinsics.checkNotNullExpressionValue(v4, "getSubevent_id(...)");
                if (((Number)v4).longValue() > 0L) {
                    listfilter = (Logical)OrderPosition.SUBEVENT_ID.eq((Object)list.getSubevent_id()).and((Condition)listfilter);
                }
            }
            if (listfilters == null) {
                listfilters = listfilter;
                continue;
            }
            listfilters = (Logical)listfilter.or((Condition)listfilters);
        }
        v5 = search.and((Condition)listfilters);
        Intrinsics.checkNotNullExpressionValue(v5, "and(...)");
        search = (LogicalCondition)v5;
        positions = null;
        v6 = this.dataStore.select(OrderPosition.class, new QueryAttribute[0]).leftJoin(Order.class);
        v7 = OrderPosition.ORDER_ID;
        Intrinsics.checkNotNullExpressionValue(v7, "ORDER_ID");
        v8 = Order.ID.eq(v7);
        Intrinsics.checkNotNull(v8, "null cannot be cast to non-null type io.requery.query.Condition<*, *>");
        v9 = v6.on((Condition)v8).leftJoin(Item.class);
        v10 = OrderPosition.ITEM_ID;
        Intrinsics.checkNotNullExpressionValue(v10, "ITEM_ID");
        v11 = v9.on((Condition)Item.ID.eq(v10)).where(search).limit(50).offset(50 * (page - 1)).get();
        Intrinsics.checkNotNull(v11, "null cannot be cast to non-null type io.requery.query.Result<eu.pretix.libpretixsync.db.OrderPosition>");
        v12 = ((Result)v11).toList();
        Intrinsics.checkNotNullExpressionValue(v12, "toList(...)");
        positions = v12;
        for (OrderPosition position : positions) {
            item = position.getItem();
            order = position.getOrder();
            sr = new TicketCheckProvider.SearchResult();
            sr.setTicket(item.getInternalName());
            try {
                if (position.getVariationId() == null) ** GOTO lbl-1000
                v13 = position.getVariationId();
                Intrinsics.checkNotNullExpressionValue(v13, "getVariationId(...)");
                if (((Number)v13).longValue() > 0L) {
                    v14 = item.getVariation(position.getVariationId());
                } else lbl-1000:
                // 2 sources

                {
                    v14 = null;
                }
                var15_16 = v14;
            }
            catch (JSONException e) {
                this.sentry.captureException(e);
                var15_16 = null;
            }
            variation = var15_16;
            if (variation != null) {
                sr.setVariation(variation.getStringValue());
            }
            sr.setAttendee_name(position.attendee_name);
            sr.setSeat(position.getSeatName());
            sr.setOrderCode(order.getCode());
            sr.setPositionId(position.getPositionid());
            sr.setSecret(position.getSecret());
            queuedCheckIns = ((Number)((Scalar)((WhereAndOr)this.dataStore.count(QueuedCheckIn.class).where((Condition)QueuedCheckIn.SECRET.eq((Object)position.getSecret())).and((Condition)QueuedCheckIn.CHECKIN_LIST_ID.in(CollectionsKt.toList((Iterable)eventsAndCheckinLists.values())))).get()).value()).intValue();
            is_checked_in = queuedCheckIns > 0L;
            for (CheckIn ci : position.getCheckins()) {
                if (!eventsAndCheckinLists.containsValue(ci.getListId())) continue;
                is_checked_in = true;
                break;
            }
            sr.setRedeemed(is_checked_in);
            if (Intrinsics.areEqual(order.getStatus(), "p")) {
                sr.setStatus(TicketCheckProvider.SearchResult.Status.PAID);
            } else if (Intrinsics.areEqual(order.getStatus(), "n")) {
                sr.setStatus(TicketCheckProvider.SearchResult.Status.PENDING);
            } else {
                sr.setStatus(TicketCheckProvider.SearchResult.Status.CANCELED);
            }
            require_attention = order.isCheckin_attention();
            try {
                if (require_attention || item.getJSON().optBoolean("checkin_attention", false)) ** GOTO lbl-1000
                v15 = variation;
                v16 = v15 != null ? v15.isCheckin_attention() : false;
                if (v16) lbl-1000:
                // 2 sources

                {
                    v17 = true;
                } else {
                    v17 = false;
                }
                require_attention = v17;
            }
            catch (JSONException e) {
                this.sentry.captureException(e);
            }
            sr.setRequireAttention(require_attention);
            sr.setPosition(position.getJSON());
            results.add(sr);
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private final WhereAndOr<? extends Scalar<Integer>> basePositionQuery(List<? extends CheckInList> lists, boolean onlyCheckedIn) {
        WhereAndOr q = ((DistinctSelection)this.dataStore.count(OrderPosition.class).distinct()).leftJoin(Order.class).on((Condition)OrderPosition.ORDER_ID.eq((Expression)Order.ID)).where((Condition)OrderPosition.SERVER_ID.eq((Object)-1L));
        for (CheckInList checkInList : lists) {
            Object lq = Order.EVENT_SLUG.eq((Object)checkInList.getEvent_slug());
            if (checkInList.include_pending) {
                String[] stringArray = new String[]{"p", "n"};
                lq = (Logical)lq.and((Condition)Order.STATUS.in(CollectionsKt.listOf(stringArray)));
            } else {
                lq = (Logical)lq.and((Condition)Order.STATUS.eq((Object)"p").or((Condition)Order.STATUS.eq((Object)"n").and((Condition)Order.VALID_IF_PENDING.eq((Object)true))));
            }
            if (checkInList.getSubevent_id() != null) {
                Long l = checkInList.getSubevent_id();
                Intrinsics.checkNotNullExpressionValue(l, "getSubevent_id(...)");
                if (((Number)l).longValue() > 0L) {
                    lq = (Logical)lq.and((Condition)OrderPosition.SUBEVENT_ID.eq((Object)checkInList.getSubevent_id()));
                }
            }
            if (!checkInList.isAll_items()) {
                void $this$mapTo$iv$iv;
                Expression[] expressionArray = new Expression[]{CheckInList_Item.ITEM_ID};
                List list = ((Result)this.dataStore.select(expressionArray).where((Condition)CheckInList_Item.CHECK_IN_LIST_ID.eq((Object)checkInList.getId())).get()).toList();
                Intrinsics.checkNotNullExpressionValue(list, "toList(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Tuple tuple = (Tuple)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((Long)it.get(0));
                }
                List product_ids = (List)destination$iv$iv;
                Object q2 = OrderPosition.ITEM_ID.in(product_ids);
                Intrinsics.checkNotNullExpressionValue(q2, "in(...)");
                lq = (Logical)lq.and((Condition)q2);
            }
            if (onlyCheckedIn) {
                Expression[] expressionArray = new Expression[]{CheckIn.POSITION_ID};
                Object q3 = this.dataStore.select(expressionArray).where((Condition)CheckIn.LIST_ID.eq((Object)checkInList.getServer_id())).and((Condition)CheckIn.TYPE.eq((Object)"entry"));
                Intrinsics.checkNotNullExpressionValue(q3, "and(...)");
                lq = (Logical)lq.and((Condition)OrderPosition.ID.in((Return)q3));
            }
            q = (WhereAndOr)q.or((Condition)lq);
        }
        WhereAndOr whereAndOr = q;
        Intrinsics.checkNotNull(whereAndOr);
        return whereAndOr;
    }

    @Override
    @NotNull
    public TicketCheckProvider.StatusResult status(@NotNull String eventSlug, long listId) throws CheckException {
        List<Item> list;
        List<Item> list2;
        Intrinsics.checkNotNullParameter(eventSlug, "eventSlug");
        this.sentry.addBreadcrumb("provider.status", "offline status started");
        List items = new ArrayList();
        CheckInList checkInList = (CheckInList)((Result)((WhereAndOr)this.dataStore.select(CheckInList.class, new QueryAttribute[0]).where((Condition)CheckInList.SERVER_ID.eq((Object)listId)).and((Condition)CheckInList.EVENT_SLUG.eq((Object)eventSlug))).get()).firstOrNull();
        if (checkInList == null) {
            throw new CheckException("Check-in list not found", null, 2, null);
        }
        CheckInList list3 = checkInList;
        List<Item> products = null;
        if (list3.all_items) {
            list2 = ((Result)this.dataStore.select(Item.class, new QueryAttribute[0]).where((Condition)Item.EVENT_SLUG.eq((Object)eventSlug)).get()).toList();
            Intrinsics.checkNotNull(list2);
            list = list2;
        } else {
            list2 = list3.getItems();
            Intrinsics.checkNotNull(list2);
            list = list2;
        }
        products = list;
        int sum_pos = 0;
        int sum_ci = 0;
        for (Item product : products) {
            List variations = new ArrayList();
            try {
                for (ItemVariation var : product.getVariations()) {
                    Object r = ((WhereAndOr)((WhereAndOr)this.basePositionQuery(CollectionsKt.listOf(list3), false).and((Condition)OrderPosition.ITEM_ID.eq(product.id))).and((Condition)OrderPosition.VARIATION_ID.eq((Object)var.getServer_id()))).get();
                    Intrinsics.checkNotNull(r);
                    Object e = ((Scalar)r).value();
                    Intrinsics.checkNotNull(e);
                    int position_count = ((Number)e).intValue();
                    Object r2 = ((WhereAndOr)((WhereAndOr)this.basePositionQuery(CollectionsKt.listOf(list3), true).and((Condition)OrderPosition.ITEM_ID.eq(product.id))).and((Condition)OrderPosition.VARIATION_ID.eq((Object)var.getServer_id()))).get();
                    Intrinsics.checkNotNull(r2);
                    Object e2 = ((Scalar)r2).value();
                    Intrinsics.checkNotNull(e2);
                    int ci_count = ((Number)e2).intValue();
                    Long l = var.getServer_id();
                    Intrinsics.checkNotNullExpressionValue(l, "getServer_id(...)");
                    variations.add(new TicketCheckProvider.StatusResultItemVariation(((Number)l).longValue(), var.getStringValue(), position_count, ci_count));
                }
                Object r = ((WhereAndOr)this.basePositionQuery(CollectionsKt.listOf(list3), false).and((Condition)OrderPosition.ITEM_ID.eq(product.id))).get();
                Intrinsics.checkNotNull(r);
                Object e = ((Scalar)r).value();
                Intrinsics.checkNotNull(e);
                int position_count = ((Number)e).intValue();
                Object r3 = ((WhereAndOr)this.basePositionQuery(CollectionsKt.listOf(list3), true).and((Condition)OrderPosition.ITEM_ID.eq(product.id))).get();
                Intrinsics.checkNotNull(r3);
                Object e3 = ((Scalar)r3).value();
                Intrinsics.checkNotNull(e3);
                int ci_count = ((Number)e3).intValue();
                Long l = product.getServer_id();
                Intrinsics.checkNotNullExpressionValue(l, "getServer_id(...)");
                items.add(new TicketCheckProvider.StatusResultItem(((Number)l).longValue(), product.getInternalName(), position_count, ci_count, variations, product.isAdmission()));
                sum_pos += position_count;
                sum_ci += ci_count;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return new TicketCheckProvider.StatusResult(list3.name, sum_pos, sum_ci, null, items);
    }

    public final void setNow(@NotNull DateTime d) {
        Intrinsics.checkNotNullParameter(d, "d");
        this.overrideNow = d;
    }

    private final DateTime now() {
        DateTime dateTime = this.overrideNow;
        if (dateTime == null) {
            dateTime = new DateTime();
        }
        return dateTime;
    }

    public static final /* synthetic */ BlockingEntityStore access$getDataStore$p(AsyncCheckProvider $this) {
        return $this.dataStore;
    }

    public static final /* synthetic */ DateTime access$now(AsyncCheckProvider $this) {
        return $this.now();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\tH\u00c6\u0003J=\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u001d"}, d2={"Leu/pretix/libpretixsync/check/AsyncCheckProvider$RSAResult;", "", "givenAnswers", "Lorg/json/JSONArray;", "requiredAnswers", "", "Leu/pretix/libpretixsync/check/TicketCheckProvider$QuestionAnswer;", "shownAnswers", "askQuestions", "", "(Lorg/json/JSONArray;Ljava/util/List;Ljava/util/List;Z)V", "getAskQuestions", "()Z", "getGivenAnswers", "()Lorg/json/JSONArray;", "getRequiredAnswers", "()Ljava/util/List;", "getShownAnswers", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "libpretixsync"})
    public static final class RSAResult {
        @NotNull
        private final JSONArray givenAnswers;
        @NotNull
        private final List<TicketCheckProvider.QuestionAnswer> requiredAnswers;
        @NotNull
        private final List<TicketCheckProvider.QuestionAnswer> shownAnswers;
        private final boolean askQuestions;

        public RSAResult(@NotNull JSONArray givenAnswers, @NotNull List<TicketCheckProvider.QuestionAnswer> requiredAnswers, @NotNull List<TicketCheckProvider.QuestionAnswer> shownAnswers, boolean askQuestions) {
            Intrinsics.checkNotNullParameter(givenAnswers, "givenAnswers");
            Intrinsics.checkNotNullParameter(requiredAnswers, "requiredAnswers");
            Intrinsics.checkNotNullParameter(shownAnswers, "shownAnswers");
            this.givenAnswers = givenAnswers;
            this.requiredAnswers = requiredAnswers;
            this.shownAnswers = shownAnswers;
            this.askQuestions = askQuestions;
        }

        @NotNull
        public final JSONArray getGivenAnswers() {
            return this.givenAnswers;
        }

        @NotNull
        public final List<TicketCheckProvider.QuestionAnswer> getRequiredAnswers() {
            return this.requiredAnswers;
        }

        @NotNull
        public final List<TicketCheckProvider.QuestionAnswer> getShownAnswers() {
            return this.shownAnswers;
        }

        public final boolean getAskQuestions() {
            return this.askQuestions;
        }

        @NotNull
        public final JSONArray component1() {
            return this.givenAnswers;
        }

        @NotNull
        public final List<TicketCheckProvider.QuestionAnswer> component2() {
            return this.requiredAnswers;
        }

        @NotNull
        public final List<TicketCheckProvider.QuestionAnswer> component3() {
            return this.shownAnswers;
        }

        public final boolean component4() {
            return this.askQuestions;
        }

        @NotNull
        public final RSAResult copy(@NotNull JSONArray givenAnswers, @NotNull List<TicketCheckProvider.QuestionAnswer> requiredAnswers, @NotNull List<TicketCheckProvider.QuestionAnswer> shownAnswers, boolean askQuestions) {
            Intrinsics.checkNotNullParameter(givenAnswers, "givenAnswers");
            Intrinsics.checkNotNullParameter(requiredAnswers, "requiredAnswers");
            Intrinsics.checkNotNullParameter(shownAnswers, "shownAnswers");
            return new RSAResult(givenAnswers, requiredAnswers, shownAnswers, askQuestions);
        }

        public static /* synthetic */ RSAResult copy$default(RSAResult rSAResult, JSONArray jSONArray, List list, List list2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                jSONArray = rSAResult.givenAnswers;
            }
            if ((n & 2) != 0) {
                list = rSAResult.requiredAnswers;
            }
            if ((n & 4) != 0) {
                list2 = rSAResult.shownAnswers;
            }
            if ((n & 8) != 0) {
                bl = rSAResult.askQuestions;
            }
            return rSAResult.copy(jSONArray, list, list2, bl);
        }

        @NotNull
        public String toString() {
            return "RSAResult(givenAnswers=" + this.givenAnswers + ", requiredAnswers=" + this.requiredAnswers + ", shownAnswers=" + this.shownAnswers + ", askQuestions=" + this.askQuestions + ")";
        }

        public int hashCode() {
            int result2 = this.givenAnswers.hashCode();
            result2 = result2 * 31 + ((Object)this.requiredAnswers).hashCode();
            result2 = result2 * 31 + ((Object)this.shownAnswers).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.askQuestions);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RSAResult)) {
                return false;
            }
            RSAResult rSAResult = (RSAResult)other;
            if (!Intrinsics.areEqual(this.givenAnswers, rSAResult.givenAnswers)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.requiredAnswers, rSAResult.requiredAnswers)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.shownAnswers, rSAResult.shownAnswers)) {
                return false;
            }
            return this.askQuestions == rSAResult.askQuestions;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0011J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\tH\u00c6\u0003JR\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0016\u0010\u0011\u00a8\u0006%"}, d2={"Leu/pretix/libpretixsync/check/AsyncCheckProvider$SignedTicketData;", "", "seed", "", "item", "", "variation", "subevent", "validFrom", "Lorg/joda/time/DateTime;", "validUntil", "(Ljava/lang/String;JLjava/lang/Long;Ljava/lang/Long;Lorg/joda/time/DateTime;Lorg/joda/time/DateTime;)V", "getItem", "()J", "getSeed", "()Ljava/lang/String;", "getSubevent", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getValidFrom", "()Lorg/joda/time/DateTime;", "getValidUntil", "getVariation", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(Ljava/lang/String;JLjava/lang/Long;Ljava/lang/Long;Lorg/joda/time/DateTime;Lorg/joda/time/DateTime;)Leu/pretix/libpretixsync/check/AsyncCheckProvider$SignedTicketData;", "equals", "", "other", "hashCode", "", "toString", "libpretixsync"})
    private static final class SignedTicketData {
        @NotNull
        private final String seed;
        private final long item;
        @Nullable
        private final Long variation;
        @Nullable
        private final Long subevent;
        @Nullable
        private final DateTime validFrom;
        @Nullable
        private final DateTime validUntil;

        public SignedTicketData(@NotNull String seed, long item, @Nullable Long variation, @Nullable Long subevent, @Nullable DateTime validFrom, @Nullable DateTime validUntil) {
            Intrinsics.checkNotNullParameter(seed, "seed");
            this.seed = seed;
            this.item = item;
            this.variation = variation;
            this.subevent = subevent;
            this.validFrom = validFrom;
            this.validUntil = validUntil;
        }

        @NotNull
        public final String getSeed() {
            return this.seed;
        }

        public final long getItem() {
            return this.item;
        }

        @Nullable
        public final Long getVariation() {
            return this.variation;
        }

        @Nullable
        public final Long getSubevent() {
            return this.subevent;
        }

        @Nullable
        public final DateTime getValidFrom() {
            return this.validFrom;
        }

        @Nullable
        public final DateTime getValidUntil() {
            return this.validUntil;
        }

        @NotNull
        public final String component1() {
            return this.seed;
        }

        public final long component2() {
            return this.item;
        }

        @Nullable
        public final Long component3() {
            return this.variation;
        }

        @Nullable
        public final Long component4() {
            return this.subevent;
        }

        @Nullable
        public final DateTime component5() {
            return this.validFrom;
        }

        @Nullable
        public final DateTime component6() {
            return this.validUntil;
        }

        @NotNull
        public final SignedTicketData copy(@NotNull String seed, long item, @Nullable Long variation, @Nullable Long subevent, @Nullable DateTime validFrom, @Nullable DateTime validUntil) {
            Intrinsics.checkNotNullParameter(seed, "seed");
            return new SignedTicketData(seed, item, variation, subevent, validFrom, validUntil);
        }

        public static /* synthetic */ SignedTicketData copy$default(SignedTicketData signedTicketData, String string, long l, Long l2, Long l3, DateTime dateTime, DateTime dateTime2, int n, Object object) {
            if ((n & 1) != 0) {
                string = signedTicketData.seed;
            }
            if ((n & 2) != 0) {
                l = signedTicketData.item;
            }
            if ((n & 4) != 0) {
                l2 = signedTicketData.variation;
            }
            if ((n & 8) != 0) {
                l3 = signedTicketData.subevent;
            }
            if ((n & 0x10) != 0) {
                dateTime = signedTicketData.validFrom;
            }
            if ((n & 0x20) != 0) {
                dateTime2 = signedTicketData.validUntil;
            }
            return signedTicketData.copy(string, l, l2, l3, dateTime, dateTime2);
        }

        @NotNull
        public String toString() {
            return "SignedTicketData(seed=" + this.seed + ", item=" + this.item + ", variation=" + this.variation + ", subevent=" + this.subevent + ", validFrom=" + this.validFrom + ", validUntil=" + this.validUntil + ")";
        }

        public int hashCode() {
            int result2 = this.seed.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.item);
            result2 = result2 * 31 + (this.variation == null ? 0 : ((Object)this.variation).hashCode());
            result2 = result2 * 31 + (this.subevent == null ? 0 : ((Object)this.subevent).hashCode());
            result2 = result2 * 31 + (this.validFrom == null ? 0 : this.validFrom.hashCode());
            result2 = result2 * 31 + (this.validUntil == null ? 0 : this.validUntil.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SignedTicketData)) {
                return false;
            }
            SignedTicketData signedTicketData = (SignedTicketData)other;
            if (!Intrinsics.areEqual(this.seed, signedTicketData.seed)) {
                return false;
            }
            if (this.item != signedTicketData.item) {
                return false;
            }
            if (!Intrinsics.areEqual(this.variation, signedTicketData.variation)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.subevent, signedTicketData.subevent)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.validFrom, signedTicketData.validFrom)) {
                return false;
            }
            return Intrinsics.areEqual(this.validUntil, signedTicketData.validUntil);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TicketCheckProvider.CheckInType.values().length];
            try {
                nArray[TicketCheckProvider.CheckInType.ENTRY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TicketCheckProvider.CheckInType.EXIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

