/*
 * Decompiled with CFR 0.152.
 */
package io.requery.proxy;

import io.requery.meta.Attribute;
import io.requery.meta.Type;
import io.requery.proxy.BooleanProperty;
import io.requery.proxy.ByteProperty;
import io.requery.proxy.CompositeEntityStateListener;
import io.requery.proxy.CompositeKey;
import io.requery.proxy.DoubleProperty;
import io.requery.proxy.EntityStateEventListenable;
import io.requery.proxy.EntityStateListener;
import io.requery.proxy.FloatProperty;
import io.requery.proxy.Gettable;
import io.requery.proxy.IntProperty;
import io.requery.proxy.LongProperty;
import io.requery.proxy.Property;
import io.requery.proxy.PropertyLoader;
import io.requery.proxy.PropertyState;
import io.requery.proxy.Settable;
import io.requery.proxy.ShortProperty;
import io.requery.util.Objects;
import java.util.LinkedHashMap;

public class EntityProxy<E>
implements Gettable<E>,
Settable<E>,
EntityStateListener {
    private final Type<E> type;
    private final E entity;
    private final boolean stateless;
    private PropertyLoader<E> loader;
    private CompositeEntityStateListener<E> listeners;
    private Object key;
    private boolean regenerateKey;

    public EntityProxy(E entity, Type<E> type2) {
        this.entity = entity;
        this.type = type2;
        this.stateless = type2.isStateless();
    }

    private PropertyState loadProperty(Attribute<E, ?> attribute) {
        if (!this.stateless) {
            PropertyState state = this.getState(attribute);
            if (state == PropertyState.FETCH && this.loader != null) {
                this.loader.load(this.entity, this, attribute);
            }
            return state;
        }
        return null;
    }

    @Override
    public <V> V get(Attribute<E, V> attribute) {
        return this.get(attribute, true);
    }

    @Override
    public <V> V get(Attribute<E, V> attribute, boolean fetch) {
        PropertyState state = fetch ? this.loadProperty(attribute) : this.getState(attribute);
        V value = attribute.getProperty().get(this.entity);
        if (value == null && (state == PropertyState.FETCH || this.stateless) && attribute.getInitializer() != null) {
            value = attribute.getInitializer().initialize(this, attribute);
            this.set(attribute, value, PropertyState.FETCH);
        }
        return value;
    }

    @Override
    public int getInt(Attribute<E, Integer> attribute) {
        IntProperty property = (IntProperty)attribute.getProperty();
        this.loadProperty(attribute);
        return property.getInt(this.entity);
    }

    @Override
    public long getLong(Attribute<E, Long> attribute) {
        LongProperty property = (LongProperty)attribute.getProperty();
        this.loadProperty(attribute);
        return property.getLong(this.entity);
    }

    @Override
    public short getShort(Attribute<E, Short> attribute) {
        ShortProperty property = (ShortProperty)attribute.getProperty();
        this.loadProperty(attribute);
        return property.getShort(this.entity);
    }

    @Override
    public byte getByte(Attribute<E, Byte> attribute) {
        ByteProperty property = (ByteProperty)attribute.getProperty();
        this.loadProperty(attribute);
        return property.getByte(this.entity);
    }

    @Override
    public float getFloat(Attribute<E, Float> attribute) {
        FloatProperty property = (FloatProperty)attribute.getProperty();
        this.loadProperty(attribute);
        return property.getFloat(this.entity);
    }

    @Override
    public double getDouble(Attribute<E, Double> attribute) {
        DoubleProperty property = (DoubleProperty)attribute.getProperty();
        this.loadProperty(attribute);
        return property.getDouble(this.entity);
    }

    @Override
    public boolean getBoolean(Attribute<E, Boolean> attribute) {
        BooleanProperty property = (BooleanProperty)attribute.getProperty();
        this.loadProperty(attribute);
        return property.getBoolean(this.entity);
    }

    @Override
    public <V> void set(Attribute<E, V> attribute, V value) {
        this.set(attribute, value, PropertyState.MODIFIED);
    }

    @Override
    public <V> void set(Attribute<E, V> attribute, V value, PropertyState state) {
        attribute.getProperty().set(this.entity, value);
        this.setState(attribute, state);
        this.checkRegenerateKey(attribute);
    }

    @Override
    public void setObject(Attribute<E, ?> attribute, Object value, PropertyState state) {
        Property<E, ?> property = attribute.getProperty();
        property.set(this.entity, value);
        this.setState(attribute, state);
        this.checkRegenerateKey(attribute);
    }

    @Override
    public void setInt(Attribute<E, Integer> attribute, int value, PropertyState state) {
        IntProperty property = (IntProperty)attribute.getProperty();
        property.setInt(this.entity, value);
        this.setState(attribute, state);
        this.checkRegenerateKey(attribute);
    }

    @Override
    public void setLong(Attribute<E, Long> attribute, long value, PropertyState state) {
        LongProperty property = (LongProperty)attribute.getProperty();
        property.setLong(this.entity, value);
        this.setState(attribute, state);
        this.checkRegenerateKey(attribute);
    }

    @Override
    public void setShort(Attribute<E, Short> attribute, short value, PropertyState state) {
        ShortProperty property = (ShortProperty)attribute.getProperty();
        property.setShort(this.entity, value);
        this.setState(attribute, state);
    }

    @Override
    public void setByte(Attribute<E, Byte> attribute, byte value, PropertyState state) {
        ByteProperty property = (ByteProperty)attribute.getProperty();
        property.setByte(this.entity, value);
        this.setState(attribute, state);
    }

    @Override
    public void setFloat(Attribute<E, Float> attribute, float value, PropertyState state) {
        FloatProperty property = (FloatProperty)attribute.getProperty();
        property.setFloat(this.entity, value);
        this.setState(attribute, state);
    }

    @Override
    public void setDouble(Attribute<E, Double> attribute, double value, PropertyState state) {
        DoubleProperty property = (DoubleProperty)attribute.getProperty();
        property.setDouble(this.entity, value);
        this.setState(attribute, state);
    }

    @Override
    public void setBoolean(Attribute<E, Boolean> attribute, boolean value, PropertyState state) {
        BooleanProperty property = (BooleanProperty)attribute.getProperty();
        property.setBoolean(this.entity, value);
        this.setState(attribute, state);
    }

    private void checkRegenerateKey(Attribute<E, ?> attribute) {
        if (attribute.isKey()) {
            this.regenerateKey = true;
        }
    }

    public void setState(Attribute<E, ?> attribute, PropertyState state) {
        if (!this.stateless) {
            attribute.getPropertyState().set(this.entity, state);
        }
    }

    public PropertyState getState(Attribute<E, ?> attribute) {
        if (this.stateless) {
            return null;
        }
        PropertyState state = attribute.getPropertyState().get(this.entity);
        return state == null ? PropertyState.FETCH : state;
    }

    public Object key() {
        if (this.regenerateKey || this.key == null) {
            if (this.type.getSingleKeyAttribute() != null) {
                this.key = this.getKey(this.type.getSingleKeyAttribute());
            } else if (this.type.getKeyAttributes().size() > 1) {
                LinkedHashMap keys2 = new LinkedHashMap(this.type.getKeyAttributes().size());
                for (Attribute<E, ?> attribute : this.type.getKeyAttributes()) {
                    keys2.put(attribute, this.getKey(attribute));
                }
                this.key = new CompositeKey(keys2);
            } else {
                this.key = this;
            }
        }
        return this.key;
    }

    public Object getKey(Attribute<E, ?> attribute) {
        if (attribute.isAssociation()) {
            Attribute referenced = attribute.getReferencedAttribute().get();
            Object association = this.get(attribute, false);
            if (association != null) {
                Type type2 = referenced.getDeclaringType();
                EntityProxy proxy = type2.getProxyProvider().apply(association);
                return proxy == null ? null : proxy.get(referenced, false);
            }
            return null;
        }
        return this.get(attribute, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLinked() {
        Object object = this.syncObject();
        synchronized (object) {
            return this.loader != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void link(PropertyLoader<E> loader) {
        Object object = this.syncObject();
        synchronized (object) {
            this.loader = loader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlink() {
        Object object = this.syncObject();
        synchronized (object) {
            this.loader = null;
        }
    }

    public E copy() {
        E copy2 = this.type.getFactory().get();
        EntityProxy<E> proxy = this.type.getProxyProvider().apply(copy2);
        proxy.link(this.loader);
        for (Attribute<E, ?> attribute : this.type.getAttributes()) {
            PropertyState state;
            if (attribute.isAssociation() || (state = this.getState(attribute)) != PropertyState.LOADED && state != PropertyState.MODIFIED) continue;
            Object value = this.get(attribute, false);
            Attribute<E, ?> a = attribute;
            proxy.set(a, value, state);
        }
        return copy2;
    }

    public Type<E> type() {
        return this.type;
    }

    public Object syncObject() {
        return this;
    }

    public EntityStateEventListenable<E> modifyListeners() {
        if (this.listeners == null) {
            this.listeners = new CompositeEntityStateListener<E>(this.entity);
        }
        return this.listeners;
    }

    private EntityStateListener stateListener() {
        return this.listeners == null ? EntityStateListener.EMPTY : this.listeners;
    }

    @Override
    public void preUpdate() {
        this.stateListener().preUpdate();
    }

    @Override
    public void postUpdate() {
        this.stateListener().postUpdate();
    }

    @Override
    public void preInsert() {
        this.stateListener().preInsert();
    }

    @Override
    public void postInsert() {
        this.stateListener().postInsert();
    }

    @Override
    public void preDelete() {
        this.stateListener().preDelete();
    }

    @Override
    public void postDelete() {
        this.stateListener().postDelete();
    }

    @Override
    public void postLoad() {
        this.stateListener().postLoad();
    }

    public boolean equals(Object obj) {
        if (obj instanceof EntityProxy) {
            EntityProxy other = (EntityProxy)obj;
            if (other.entity.getClass().equals(this.entity.getClass())) {
                for (Attribute<E, ?> attribute : this.type.getAttributes()) {
                    Object otherValue;
                    Object value;
                    if (attribute.isAssociation() || Objects.equals(value = this.get(attribute, false), otherValue = other.get(attribute, false))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 31;
        for (Attribute<E, ?> attribute : this.type.getAttributes()) {
            if (attribute.isAssociation()) continue;
            hash = 31 * hash + Objects.hashCode(this.get(attribute, false));
        }
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type.getName());
        sb.append(" [");
        int index = 0;
        for (Attribute<E, ?> attribute : this.type.getAttributes()) {
            Object value;
            if (index > 0) {
                sb.append(", ");
            }
            if ((value = this.get(attribute, false)) == null) {
                sb.append("null");
            } else if (attribute.isAssociation()) {
                sb.append(value.getClass().getName());
            } else {
                sb.append(value.toString());
            }
            ++index;
        }
        sb.append("]");
        return sb.toString();
    }
}

