/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.TransactionIsolation;
import io.requery.TransactionListener;
import io.requery.meta.Type;
import io.requery.util.function.Supplier;
import java.util.HashSet;
import java.util.Set;

class CompositeTransactionListener
extends HashSet<TransactionListener>
implements TransactionListener {
    CompositeTransactionListener(Set<Supplier<TransactionListener>> listenerFactories) {
        for (Supplier<TransactionListener> supplier : listenerFactories) {
            TransactionListener listener = supplier.get();
            if (listener == null) continue;
            this.add(listener);
        }
    }

    @Override
    public void beforeBegin(TransactionIsolation isolation) {
        for (TransactionListener listener : this) {
            listener.beforeBegin(isolation);
        }
    }

    @Override
    public void afterBegin(TransactionIsolation isolation) {
        for (TransactionListener listener : this) {
            listener.afterBegin(isolation);
        }
    }

    @Override
    public void beforeCommit(Set<Type<?>> types) {
        for (TransactionListener listener : this) {
            listener.beforeCommit(types);
        }
    }

    @Override
    public void afterCommit(Set<Type<?>> types) {
        for (TransactionListener listener : this) {
            listener.afterCommit(types);
        }
    }

    @Override
    public void beforeRollback(Set<Type<?>> types) {
        for (TransactionListener listener : this) {
            listener.beforeRollback(types);
        }
    }

    @Override
    public void afterRollback(Set<Type<?>> types) {
        for (TransactionListener listener : this) {
            listener.afterRollback(types);
        }
    }
}

