/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.db;

import eu.pretix.libpretixsync.db.RemoteObject;
import eu.pretix.libpretixsync.utils.I18nString;
import io.requery.Column;
import io.requery.Entity;
import io.requery.Generated;
import io.requery.Key;
import io.requery.Nullable;
import java.math.BigDecimal;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Entity(cacheable=false)
public class AbstractSubEvent
implements RemoteObject {
    @Generated
    @Key
    public Long id;
    public Long server_id;
    public String event_slug;
    public Date date_from;
    @Nullable
    public Date date_to;
    public boolean active;
    @Column(definition="TEXT")
    public String json_data;

    @Override
    public JSONObject getJSON() throws JSONException {
        return new JSONObject(this.json_data);
    }

    public boolean hasSeating() {
        try {
            return !this.getJSON().isNull("seating_plan");
        }
        catch (JSONException e) {
            return false;
        }
    }

    public String getName() {
        try {
            return I18nString.toString(this.getJSON().getJSONObject("name"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "";
        }
    }

    public BigDecimal getPriceForItem(Long item_id, BigDecimal original_price) throws JSONException {
        JSONObject jd = this.getJSON();
        JSONArray ja = jd.getJSONArray("item_price_overrides");
        for (int i = 0; i < ja.length(); ++i) {
            JSONObject or = ja.getJSONObject(i);
            if (or.getLong("item") != item_id.longValue()) continue;
            if (or.isNull("price")) {
                return original_price;
            }
            return new BigDecimal(or.getString("price"));
        }
        return original_price;
    }

    public BigDecimal getPriceForVariation(Long var_id, BigDecimal original_price) throws JSONException {
        JSONObject jd = this.getJSON();
        JSONArray ja = jd.getJSONArray("variation_price_overrides");
        for (int i = 0; i < ja.length(); ++i) {
            JSONObject or = ja.getJSONObject(i);
            if (or.getLong("variation") != var_id.longValue()) continue;
            if (or.isNull("price")) {
                return original_price;
            }
            return new BigDecimal(or.getString("price"));
        }
        return original_price;
    }

    public ItemOverride getOverrideForItem(Long item_id) throws JSONException {
        JSONObject jd = this.getJSON();
        JSONArray ja = jd.getJSONArray("item_price_overrides");
        for (int i = 0; i < ja.length(); ++i) {
            JSONObject or = ja.getJSONObject(i);
            if (or.getLong("item") != item_id.longValue()) continue;
            return new ItemOverride(or.optString("available_from"), or.optString("available_until"), or.isNull("price") ? null : new BigDecimal(or.optString("price")), or.optBoolean("disabled", false));
        }
        return new ItemOverride(null, null, null, false);
    }

    public ItemOverride getOverrideForVariation(Long var_id) throws JSONException {
        JSONObject jd = this.getJSON();
        JSONArray ja = jd.getJSONArray("variation_price_overrides");
        for (int i = 0; i < ja.length(); ++i) {
            JSONObject or = ja.getJSONObject(i);
            if (or.getLong("variation") != var_id.longValue()) continue;
            return new ItemOverride(or.optString("available_from"), or.optString("available_until"), or.isNull("price") ? null : new BigDecimal(or.optString("price")), or.optBoolean("disabled", false));
        }
        return new ItemOverride(null, null, null, false);
    }

    public class ItemOverride {
        private String available_from;
        private String available_until;
        private BigDecimal price;
        private boolean disabled;

        public ItemOverride(String available_from, String available_until, BigDecimal price, boolean disabled) {
            this.available_from = available_from;
            this.available_until = available_until;
            this.price = price;
            this.disabled = disabled;
        }

        public String getAvailable_from() {
            return this.available_from;
        }

        public void setAvailable_from(String available_from) {
            this.available_from = available_from;
        }

        public String getAvailable_until() {
            return this.available_until;
        }

        public void setAvailable_until(String available_until) {
            this.available_until = available_until;
        }

        public BigDecimal getPrice() {
            return this.price;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public void setDisabled(boolean disabled) {
            this.disabled = disabled;
        }

        public boolean availableByTime() {
            DateTime af;
            if (this.available_from != null && this.available_from.length() > 5 && (af = ISODateTimeFormat.dateTimeParser().parseDateTime(this.available_from)).isAfterNow()) {
                return false;
            }
            return this.available_until == null || this.available_until.length() <= 5 || !(af = ISODateTimeFormat.dateTimeParser().parseDateTime(this.available_until)).isBeforeNow();
        }
    }
}

