/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.db;

import eu.pretix.libpretixsync.db.RemoteObject;
import io.requery.Column;
import io.requery.Entity;
import io.requery.Generated;
import io.requery.Key;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.json.JSONException;
import org.json.JSONObject;

@Entity(cacheable=false)
public class AbstractTaxRule
implements RemoteObject {
    @Generated
    @Key
    public Long id;
    public Long server_id;
    public String event_slug;
    @Column(definition="TEXT")
    public String json_data;

    public boolean includesTax() {
        try {
            return this.getJSON().getBoolean("price_includes_tax");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    public BigDecimal getRate() {
        try {
            return new BigDecimal(this.getJSON().getString("rate"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new BigDecimal(0.0);
        }
    }

    public BigDecimal calculatePrice(BigDecimal price) {
        MathContext mc = new MathContext(10, RoundingMode.HALF_UP);
        if (this.includesTax()) {
            return price;
        }
        BigDecimal gross = price.multiply(this.getRate().divide(new BigDecimal("100.00", mc), mc).add(new BigDecimal("1.00", mc), mc), mc).setScale(2, RoundingMode.HALF_UP);
        return gross;
    }

    public BigDecimal calculateTaxFromNet(BigDecimal price) {
        MathContext mc = new MathContext(10, RoundingMode.HALF_UP);
        BigDecimal gross = price.multiply(this.getRate().divide(new BigDecimal("100.00", mc), mc).add(new BigDecimal("1.00", mc), mc), mc).setScale(2, RoundingMode.HALF_UP);
        return gross.subtract(price);
    }

    public BigDecimal calculateTaxFromGross(BigDecimal price) {
        MathContext mc = new MathContext(10, RoundingMode.HALF_UP);
        BigDecimal net = price.subtract(price.multiply(new BigDecimal("1.00", mc).subtract(new BigDecimal("100.00", mc).divide(new BigDecimal("100.00", mc).add(this.getRate(), mc), mc), mc), mc), mc).setScale(2, RoundingMode.HALF_UP);
        return price.subtract(net);
    }

    public BigDecimal calculateTax(BigDecimal price) {
        if (this.includesTax()) {
            return this.calculateTaxFromGross(price);
        }
        return this.calculateTaxFromNet(price);
    }

    @Override
    public JSONObject getJSON() throws JSONException {
        return new JSONObject(this.json_data);
    }
}

