/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.sync;

import eu.pretix.libpretixsync.sync.BatchEmptyException;
import io.requery.util.CloseableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BatchedQueryIterator<K, T>
implements Iterator<T> {
    private static final int BATCH_SIZE = 500;
    private Iterator<K> allParameters;
    private List<T> buffer = new ArrayList<T>();
    private BatchedQueryCall<K, T> callBack;

    public BatchedQueryIterator(Iterator<K> allParameters, BatchedQueryCall<K, T> callBack) {
        this.allParameters = allParameters;
        this.callBack = callBack;
    }

    @Override
    public boolean hasNext() {
        return this.buffer.size() > 0 || this.allParameters.hasNext();
    }

    @Override
    public T next() {
        if (this.buffer.size() == 0) {
            ArrayList<K> batch = new ArrayList<K>();
            for (int i = 0; i < 500 && this.allParameters.hasNext(); ++i) {
                batch.add(this.allParameters.next());
            }
            CloseableIterator<T> batchResult = this.callBack.runBatch(batch);
            while (batchResult.hasNext()) {
                this.buffer.add(batchResult.next());
            }
            batchResult.close();
            if (this.buffer.size() == 0) {
                throw new BatchEmptyException();
            }
        }
        return this.buffer.remove(0);
    }

    public static interface BatchedQueryCall<K, T> {
        public CloseableIterator<T> runBatch(List<K> var1);
    }
}

