/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql.platform;

import io.requery.meta.Attribute;
import io.requery.query.Expression;
import io.requery.query.function.Function;
import io.requery.query.function.Now;
import io.requery.query.function.Random;
import io.requery.sql.BaseType;
import io.requery.sql.GeneratedColumnDefinition;
import io.requery.sql.IdentityColumnDefinition;
import io.requery.sql.Keyword;
import io.requery.sql.Mapping;
import io.requery.sql.QueryBuilder;
import io.requery.sql.gen.Generator;
import io.requery.sql.gen.Output;
import io.requery.sql.gen.UpsertMergeGenerator;
import io.requery.sql.platform.Generic;
import io.requery.sql.type.PrimitiveBooleanType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class Oracle
extends Generic {
    private final OracleIdentityColumnDefinition generatedColumn = new OracleIdentityColumnDefinition();
    private final UpsertMergeGenerator upsertMergeWriter = new UpsertMergeDual();

    @Override
    public void addMappings(Mapping mapping) {
        super.addMappings(mapping);
        mapping.replaceType(-2, new RawType(-2));
        mapping.replaceType(-3, new RawType(-3));
        mapping.replaceType(16, new NumericBooleanType());
        mapping.aliasFunction(new Function.Name("dbms_random.value", true), Random.class);
        mapping.aliasFunction(new Function.Name("current_date", true), Now.class);
    }

    @Override
    public boolean supportsIfExists() {
        return false;
    }

    @Override
    public GeneratedColumnDefinition generatedColumnDefinition() {
        return this.generatedColumn;
    }

    @Override
    public boolean supportsOnUpdateCascade() {
        return false;
    }

    @Override
    public Generator<Map<Expression<?>, Object>> upsertGenerator() {
        return this.upsertMergeWriter;
    }

    private static class OracleIdentityColumnDefinition
    extends IdentityColumnDefinition {
        private OracleIdentityColumnDefinition() {
        }

        @Override
        public void appendGeneratedSequence(QueryBuilder qb, Attribute attribute) {
            int start2 = 1;
            int increment = 1;
            qb.keyword(Keyword.GENERATED, Keyword.ALWAYS, Keyword.AS, Keyword.IDENTITY);
            qb.openParenthesis().keyword(Keyword.START, Keyword.WITH).value(start2).keyword(Keyword.INCREMENT, Keyword.BY).value(increment).closeParenthesis().space();
        }
    }

    private static class NumericBooleanType
    extends BaseType<Boolean>
    implements PrimitiveBooleanType {
        NumericBooleanType() {
            super(Boolean.class, 2);
        }

        @Override
        public boolean hasLength() {
            return true;
        }

        @Override
        public Integer getDefaultLength() {
            return 1;
        }

        @Override
        public String getIdentifier() {
            return "number";
        }

        @Override
        public Boolean read(ResultSet results, int column) throws SQLException {
            Boolean value = results.getBoolean(column);
            if (results.wasNull()) {
                return null;
            }
            return value;
        }

        @Override
        public boolean readBoolean(ResultSet results, int column) throws SQLException {
            return results.getBoolean(column);
        }

        @Override
        public void writeBoolean(PreparedStatement statement, int index, boolean value) throws SQLException {
            statement.setBoolean(index, value);
        }
    }

    private static class RawType
    extends BaseType<byte[]> {
        RawType(int jdbcType) {
            super(byte[].class, jdbcType);
        }

        @Override
        public boolean hasLength() {
            return this.getSqlType() == -3;
        }

        @Override
        public String getIdentifier() {
            return "raw";
        }

        @Override
        public byte[] read(ResultSet results, int column) throws SQLException {
            byte[] value = results.getBytes(column);
            if (results.wasNull()) {
                return null;
            }
            return value;
        }
    }

    private static class UpsertMergeDual
    extends UpsertMergeGenerator {
        private UpsertMergeDual() {
        }

        @Override
        protected void appendUsing(final Output context, final Map<Expression<?>, Object> values2) {
            QueryBuilder qb = context.builder();
            qb.openParenthesis().keyword(Keyword.SELECT).commaSeparated(values2.keySet(), new QueryBuilder.Appender<Expression<?>>(){

                @Override
                public void append(QueryBuilder qb, Expression expression) {
                    qb.append("? ");
                    context.parameters().add(expression, values2.get(expression));
                    qb.append(expression.getName());
                }
            }).space().keyword(Keyword.FROM).append("DUAL ").closeParenthesis().append(" val ");
        }
    }
}

