/*
 * Decompiled with CFR 0.152.
 */
package java8.util;

import java.util.Comparator;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.locks.ReentrantLock;
import java8.util.Objects;
import java8.util.Spliterator;
import java8.util.Spliterators;
import java8.util.UnsafeAccess;
import java8.util.function.Consumer;
import sun.misc.Unsafe;

final class LBDSpliterator<E>
implements Spliterator<E> {
    private static final int MAX_BATCH = 0x2000000;
    private final LinkedBlockingDeque<E> queue;
    private final ReentrantLock queueLock;
    private Object current;
    private int batch;
    private boolean exhausted;
    private long est;
    private static final Unsafe U = UnsafeAccess.unsafe;
    private static final long FIRST_OFF;
    private static final long LOCK_OFF;
    private static final long NODE_ITEM_OFF;
    private static final long NODE_NEXT_OFF;

    private LBDSpliterator(LinkedBlockingDeque<E> queue) {
        this.queue = queue;
        this.est = queue.size();
        this.queueLock = LBDSpliterator.getQueueLock(queue);
    }

    static <T> Spliterator<T> spliterator(LinkedBlockingDeque<T> queue) {
        return new LBDSpliterator<T>(queue);
    }

    Object succ(Object p) {
        return p == (p = LBDSpliterator.getNextNode(p)) ? LBDSpliterator.getQueueFirst(this.queue) : p;
    }

    @Override
    public int characteristics() {
        return 4368;
    }

    @Override
    public long estimateSize() {
        return this.est;
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        if (!this.exhausted) {
            this.exhausted = true;
            Object p = this.current;
            this.current = null;
            this.forEachFrom(action, p);
        }
    }

    @Override
    public Comparator<? super E> getComparator() {
        return Spliterators.getComparator(this);
    }

    @Override
    public long getExactSizeIfKnown() {
        return Spliterators.getExactSizeIfKnown(this);
    }

    @Override
    public boolean hasCharacteristics(int characteristics) {
        return Spliterators.hasCharacteristics(this, characteristics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        if (!this.exhausted) {
            Object e = null;
            ReentrantLock lock = this.queueLock;
            lock.lock();
            try {
                Object p = this.current;
                if (p != null || (p = LBDSpliterator.getQueueFirst(this.queue)) != null) {
                    do {
                        e = LBDSpliterator.getNodeItem(p);
                        p = this.succ(p);
                    } while (e == null && p != null);
                }
                if ((this.current = p) == null) {
                    this.exhausted = true;
                }
            }
            finally {
                lock.unlock();
            }
            if (e != null) {
                action.accept(e);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Spliterator<E> trySplit() {
        Object h2;
        LinkedBlockingDeque<E> q = this.queue;
        if (!(this.exhausted || (h2 = this.current) == null && (h2 = LBDSpliterator.getQueueFirst(q)) == null || LBDSpliterator.getNextNode(h2) == null)) {
            int n = this.batch = Math.min(this.batch + 1, 0x2000000);
            Object[] a = new Object[n];
            ReentrantLock lock = this.queueLock;
            int i = 0;
            Object p = this.current;
            lock.lock();
            try {
                if (p != null || (p = LBDSpliterator.getQueueFirst(q)) != null) {
                    while (p != null && i < n) {
                        a[i] = LBDSpliterator.getNodeItem(p);
                        if (a[i] != null) {
                            ++i;
                        }
                        p = this.succ(p);
                    }
                }
            }
            finally {
                lock.unlock();
            }
            this.current = p;
            if (this.current == null) {
                this.est = 0L;
                this.exhausted = true;
            } else if ((this.est -= (long)i) < 0L) {
                this.est = 0L;
            }
            if (i > 0) {
                return Spliterators.spliterator(a, 0, i, 4368);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forEachFrom(Consumer<? super E> action, Object p) {
        int n;
        ReentrantLock lock = this.queueLock;
        int batchSize = 64;
        Object[] es = null;
        int len = 0;
        do {
            lock.lock();
            try {
                if (es == null) {
                    if (p == null) {
                        p = LBDSpliterator.getQueueFirst(this.queue);
                    }
                    Object q = p;
                    while (q != null && (LBDSpliterator.getNodeItem(q) == null || ++len != 64)) {
                        q = this.succ(q);
                    }
                    es = new Object[len];
                }
                n = 0;
                while (p != null && n < len) {
                    es[n] = LBDSpliterator.getNodeItem(p);
                    if (es[n] != null) {
                        ++n;
                    }
                    p = this.succ(p);
                }
            }
            finally {
                lock.unlock();
            }
            for (int i = 0; i < n; ++i) {
                Object e = es[i];
                action.accept(e);
            }
        } while (n > 0 && p != null);
    }

    private static ReentrantLock getQueueLock(LinkedBlockingDeque<?> queue) {
        return (ReentrantLock)U.getObject(queue, LOCK_OFF);
    }

    private static Object getQueueFirst(LinkedBlockingDeque<?> queue) {
        return U.getObject(queue, FIRST_OFF);
    }

    private static Object getNextNode(Object node) {
        return U.getObject(node, NODE_NEXT_OFF);
    }

    private static <T> T getNodeItem(Object node) {
        return (T)U.getObject(node, NODE_ITEM_OFF);
    }

    static {
        try {
            Class<?> nc = Class.forName("java.util.concurrent.LinkedBlockingDeque$Node");
            FIRST_OFF = U.objectFieldOffset(LinkedBlockingDeque.class.getDeclaredField("first"));
            LOCK_OFF = U.objectFieldOffset(LinkedBlockingDeque.class.getDeclaredField("lock"));
            NODE_ITEM_OFF = U.objectFieldOffset(nc.getDeclaredField("item"));
            NODE_NEXT_OFF = U.objectFieldOffset(nc.getDeclaredField("next"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

