/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.sync;

import eu.pretix.libpretixsync.api.ApiException;
import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.db.BadgeLayout;
import eu.pretix.libpretixsync.sync.BaseDownloadSyncAdapter;
import eu.pretix.libpretixsync.sync.FileStorage;
import eu.pretix.libpretixsync.sync.SyncManager;
import eu.pretix.libpretixsync.utils.HashUtils;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.meta.QueryAttribute;
import io.requery.query.Result;
import io.requery.query.Tuple;
import io.requery.query.WhereAndOr;
import io.requery.util.CloseableIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class BadgeLayoutSyncAdapter
extends BaseDownloadSyncAdapter<BadgeLayout, Long> {
    public BadgeLayoutSyncAdapter(BlockingEntityStore<Persistable> store, FileStorage fileStorage2, String eventSlug, PretixApi api, String syncCycleId, SyncManager.ProgressFeedback feedback) {
        super(store, fileStorage2, eventSlug, api, syncCycleId, feedback);
    }

    @Override
    public void updateObject(BadgeLayout obj, JSONObject jsonobj) throws JSONException {
        obj.setEvent_slug(this.eventSlug);
        obj.setIs_default(jsonobj.getBoolean("default"));
        obj.setServer_id(jsonobj.getLong("id"));
        obj.setJson_data(jsonobj.toString());
        String remote_filename = jsonobj.optString("background");
        if (remote_filename != null && remote_filename.startsWith("http")) {
            String hash = HashUtils.toSHA1(remote_filename.getBytes());
            String local_filename = "badgelayout_" + obj.getServer_id() + "_" + hash + ".pdf";
            if (obj.getBackground_filename() != null && !obj.getBackground_filename().equals(local_filename)) {
                this.fileStorage.delete(obj.getBackground_filename());
                obj.setBackground_filename(null);
            }
            if (!this.fileStorage.contains(local_filename)) {
                try {
                    int byteread;
                    PretixApi.ApiResponse file = this.api.downloadFile(remote_filename);
                    OutputStream os = this.fileStorage.writeStream(local_filename);
                    InputStream is = file.getResponse().body().byteStream();
                    byte[] buffer = new byte[1444];
                    while ((byteread = is.read(buffer)) != -1) {
                        os.write(buffer, 0, byteread);
                    }
                    is.close();
                    os.close();
                    obj.setBackground_filename(local_filename);
                }
                catch (ApiException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.fileStorage.delete(local_filename);
                }
            } else {
                obj.setBackground_filename(local_filename);
            }
        } else if (obj.getBackground_filename() != null) {
            this.fileStorage.delete(obj.getBackground_filename());
            obj.setBackground_filename(null);
        }
    }

    @Override
    protected void prepareDelete(BadgeLayout obj) {
        super.prepareDelete(obj);
        if (obj.getBackground_filename() != null) {
            this.fileStorage.delete(obj.getBackground_filename());
        }
    }

    @Override
    public CloseableIterator<BadgeLayout> runBatch(List<Long> ids) {
        return ((Result)((WhereAndOr)this.store.select(BadgeLayout.class, new QueryAttribute[0]).where(BadgeLayout.EVENT_SLUG.eq((Object)this.eventSlug)).and(BadgeLayout.SERVER_ID.in(ids))).get()).iterator();
    }

    @Override
    CloseableIterator<Tuple> getKnownIDsIterator() {
        return ((Result)this.store.select(BadgeLayout.SERVER_ID).where(BadgeLayout.EVENT_SLUG.eq((Object)this.eventSlug)).get()).iterator();
    }

    @Override
    String getResourceName() {
        return "badgelayouts";
    }

    @Override
    Long getId(JSONObject obj) throws JSONException {
        return obj.getLong("id");
    }

    @Override
    Long getId(BadgeLayout obj) {
        return obj.getServer_id();
    }

    @Override
    BadgeLayout newEmptyObject() {
        return new BadgeLayout();
    }
}

