/*
 * Decompiled with CFR 0.152.
 */
package io.requery.converter;

import io.requery.Converter;

public class EnumOrdinalConverter<E extends Enum>
implements Converter<E, Integer> {
    private final Class<E> enumClass;

    public EnumOrdinalConverter(Class<E> enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    public Class<E> getMappedType() {
        return this.enumClass;
    }

    @Override
    public Class<Integer> getPersistedType() {
        return Integer.class;
    }

    @Override
    public Integer getPersistedSize() {
        return null;
    }

    @Override
    public Integer convertToPersisted(E value) {
        return value == null ? null : Integer.valueOf(((Enum)value).ordinal());
    }

    @Override
    public E convertToMapped(Class<? extends E> type2, Integer value) {
        if (value == null) {
            return null;
        }
        return (E)((Enum[])this.getMappedType().getEnumConstants())[value];
    }
}

