/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.setup;

import eu.pretix.libpretixsync.utils.I18nString;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001d\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u0010\u0010#\u001a\u0004\u0018\u00010\nH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010$\u001a\u0004\u0018\u00010\nH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\t\u0010%\u001a\u00020\rH\u00c6\u0003JZ\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001\u00a2\u0006\u0002\u0010'J\u0013\u0010(\u001a\u00020\r2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020\u0005H\u00d6\u0001R\u0015\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0015\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u0018\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001aR\u0015\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u001e\u0010\u0010\u00a8\u0006-"}, d2={"Leu/pretix/libpretixsync/setup/RemoteEvent;", "", "name_i18n", "Lorg/json/JSONObject;", "slug", "", "date_from", "Lorg/joda/time/DateTime;", "date_to", "subevent_id", "", "best_availability_state", "live", "", "(Lorg/json/JSONObject;Ljava/lang/String;Lorg/joda/time/DateTime;Lorg/joda/time/DateTime;Ljava/lang/Long;Ljava/lang/Long;Z)V", "getBest_availability_state", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getDate_from", "()Lorg/joda/time/DateTime;", "getDate_to", "isRunning", "()Z", "getLive", "name", "getName", "()Ljava/lang/String;", "getName_i18n", "()Lorg/json/JSONObject;", "getSlug", "getSubevent_id", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(Lorg/json/JSONObject;Ljava/lang/String;Lorg/joda/time/DateTime;Lorg/joda/time/DateTime;Ljava/lang/Long;Ljava/lang/Long;Z)Leu/pretix/libpretixsync/setup/RemoteEvent;", "equals", "other", "hashCode", "", "toString", "libpretixsync"})
public final class RemoteEvent {
    @NotNull
    private final JSONObject name_i18n;
    @NotNull
    private final String slug;
    @NotNull
    private final DateTime date_from;
    @Nullable
    private final DateTime date_to;
    @Nullable
    private final Long subevent_id;
    @Nullable
    private final Long best_availability_state;
    private final boolean live;

    public RemoteEvent(@NotNull JSONObject name_i18n, @NotNull String slug, @NotNull DateTime date_from, @Nullable DateTime date_to, @Nullable Long subevent_id, @Nullable Long best_availability_state, boolean live) {
        Intrinsics.checkNotNullParameter(name_i18n, "name_i18n");
        Intrinsics.checkNotNullParameter(slug, "slug");
        Intrinsics.checkNotNullParameter(date_from, "date_from");
        this.name_i18n = name_i18n;
        this.slug = slug;
        this.date_from = date_from;
        this.date_to = date_to;
        this.subevent_id = subevent_id;
        this.best_availability_state = best_availability_state;
        this.live = live;
    }

    @NotNull
    public final JSONObject getName_i18n() {
        return this.name_i18n;
    }

    @NotNull
    public final String getSlug() {
        return this.slug;
    }

    @NotNull
    public final DateTime getDate_from() {
        return this.date_from;
    }

    @Nullable
    public final DateTime getDate_to() {
        return this.date_to;
    }

    @Nullable
    public final Long getSubevent_id() {
        return this.subevent_id;
    }

    @Nullable
    public final Long getBest_availability_state() {
        return this.best_availability_state;
    }

    public final boolean getLive() {
        return this.live;
    }

    @NotNull
    public final String getName() {
        String string = I18nString.toString(this.name_i18n);
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isRunning() {
        if (!this.date_from.isBeforeNow()) return false;
        DateTime dateTime = this.date_to;
        if (dateTime == null) return false;
        if (!dateTime.isAfterNow()) return false;
        return true;
    }

    @NotNull
    public final JSONObject component1() {
        return this.name_i18n;
    }

    @NotNull
    public final String component2() {
        return this.slug;
    }

    @NotNull
    public final DateTime component3() {
        return this.date_from;
    }

    @Nullable
    public final DateTime component4() {
        return this.date_to;
    }

    @Nullable
    public final Long component5() {
        return this.subevent_id;
    }

    @Nullable
    public final Long component6() {
        return this.best_availability_state;
    }

    public final boolean component7() {
        return this.live;
    }

    @NotNull
    public final RemoteEvent copy(@NotNull JSONObject name_i18n, @NotNull String slug, @NotNull DateTime date_from, @Nullable DateTime date_to, @Nullable Long subevent_id, @Nullable Long best_availability_state, boolean live) {
        Intrinsics.checkNotNullParameter(name_i18n, "name_i18n");
        Intrinsics.checkNotNullParameter(slug, "slug");
        Intrinsics.checkNotNullParameter(date_from, "date_from");
        return new RemoteEvent(name_i18n, slug, date_from, date_to, subevent_id, best_availability_state, live);
    }

    public static /* synthetic */ RemoteEvent copy$default(RemoteEvent remoteEvent, JSONObject jSONObject, String string, DateTime dateTime, DateTime dateTime2, Long l, Long l2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            jSONObject = remoteEvent.name_i18n;
        }
        if ((n & 2) != 0) {
            string = remoteEvent.slug;
        }
        if ((n & 4) != 0) {
            dateTime = remoteEvent.date_from;
        }
        if ((n & 8) != 0) {
            dateTime2 = remoteEvent.date_to;
        }
        if ((n & 0x10) != 0) {
            l = remoteEvent.subevent_id;
        }
        if ((n & 0x20) != 0) {
            l2 = remoteEvent.best_availability_state;
        }
        if ((n & 0x40) != 0) {
            bl = remoteEvent.live;
        }
        return remoteEvent.copy(jSONObject, string, dateTime, dateTime2, l, l2, bl);
    }

    @NotNull
    public String toString() {
        return "RemoteEvent(name_i18n=" + this.name_i18n + ", slug=" + this.slug + ", date_from=" + this.date_from + ", date_to=" + this.date_to + ", subevent_id=" + this.subevent_id + ", best_availability_state=" + this.best_availability_state + ", live=" + this.live + ")";
    }

    public int hashCode() {
        int result2 = this.name_i18n.hashCode();
        result2 = result2 * 31 + this.slug.hashCode();
        result2 = result2 * 31 + this.date_from.hashCode();
        result2 = result2 * 31 + (this.date_to == null ? 0 : this.date_to.hashCode());
        result2 = result2 * 31 + (this.subevent_id == null ? 0 : ((Object)this.subevent_id).hashCode());
        result2 = result2 * 31 + (this.best_availability_state == null ? 0 : ((Object)this.best_availability_state).hashCode());
        result2 = result2 * 31 + Boolean.hashCode(this.live);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RemoteEvent)) {
            return false;
        }
        RemoteEvent remoteEvent = (RemoteEvent)other;
        if (!Intrinsics.areEqual(this.name_i18n, remoteEvent.name_i18n)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.slug, remoteEvent.slug)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.date_from, remoteEvent.date_from)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.date_to, remoteEvent.date_to)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.subevent_id, remoteEvent.subevent_id)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.best_availability_state, remoteEvent.best_availability_state)) {
            return false;
        }
        return this.live == remoteEvent.live;
    }
}

