/*
 * Decompiled with CFR 0.152.
 */
package io.requery.meta;

import io.requery.meta.AttributeBuilder;
import io.requery.meta.ImmutableAttribute;
import io.requery.meta.StringAttribute;
import io.requery.query.Expression;
import io.requery.query.LogicalCondition;
import io.requery.query.NamedExpression;
import io.requery.query.function.Lower;
import io.requery.query.function.Substr;
import io.requery.query.function.Trim;
import io.requery.query.function.Upper;

final class ImmutableStringAttribute<T, V>
extends ImmutableAttribute<T, V>
implements StringAttribute<T, V> {
    ImmutableStringAttribute(AttributeBuilder<T, V> builder) {
        super(builder);
    }

    @Override
    public LogicalCondition<? extends Expression<V>, ? extends Expression<V>> equalsIgnoreCase(CharSequence string) {
        Upper<String> expression = NamedExpression.ofString(string.toString()).upper();
        return Upper.upper(this).eq((Expression)expression);
    }

    @Override
    public Trim<V> trim(String chars) {
        return Trim.trim(this, chars);
    }

    @Override
    public Trim<V> trim() {
        return this.trim(null);
    }

    @Override
    public Substr<V> substr(int offset, int length) {
        return Substr.substr(this, offset, length);
    }

    @Override
    public Upper<V> upper() {
        return Upper.upper(this);
    }

    @Override
    public Lower<V> lower() {
        return Lower.lower(this);
    }
}

