/*
 * Decompiled with CFR 0.152.
 */
package io.requery.query.function;

import io.requery.query.Expression;
import io.requery.query.ExpressionType;
import io.requery.query.FieldExpression;
import io.requery.query.NamedExpression;
import io.requery.util.Objects;

public abstract class Function<V>
extends FieldExpression<V> {
    private final Name name;
    private final Class<V> type;
    private String alias;

    public Function(String name, Class<V> type2) {
        this.name = new Name(name);
        this.type = type2;
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.FUNCTION;
    }

    @Override
    public Function<V> as(String alias) {
        this.alias = alias;
        return this;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public Class<V> getClassType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name.toString();
    }

    public Name getFunctionName() {
        return this.name;
    }

    public abstract Object[] arguments();

    public Expression<?> expressionForArgument(int i) {
        Object value = this.arguments()[i];
        if (value instanceof Expression) {
            return (Expression)value;
        }
        if (value == null) {
            return NamedExpression.of("null", this.type);
        }
        return new ArgumentExpression(value.getClass());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Function) {
            Function other = (Function)obj;
            return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getClassType(), other.getClassType()) && Objects.equals(this.getAlias(), other.getAlias()) && Objects.equals(this.arguments(), other.arguments());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getName(), this.getClassType(), this.getAlias(), this.arguments());
    }

    private static class ArgumentExpression<X>
    implements Expression<X> {
        private final Class<X> type;

        ArgumentExpression(Class<X> type2) {
            this.type = type2;
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public Class<X> getClassType() {
            return this.type;
        }

        @Override
        public ExpressionType getExpressionType() {
            return ExpressionType.FUNCTION;
        }

        @Override
        public Expression<X> getInnerExpression() {
            return null;
        }
    }

    public static class Name {
        private final String name;
        private final boolean isConstant;

        public Name(String name) {
            this(name, false);
        }

        public Name(String name, boolean isConstant) {
            this.name = name;
            this.isConstant = isConstant;
        }

        public String getName() {
            return this.name;
        }

        public boolean isConstant() {
            return this.isConstant;
        }

        public String toString() {
            return this.name;
        }
    }
}

