/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.CascadeAction;
import io.requery.EntityCache;
import io.requery.PersistenceException;
import io.requery.Queryable;
import io.requery.ReferentialAction;
import io.requery.meta.Attribute;
import io.requery.meta.EntityModel;
import io.requery.meta.QueryAttribute;
import io.requery.meta.Type;
import io.requery.proxy.CollectionChanges;
import io.requery.proxy.EntityProxy;
import io.requery.proxy.PropertyState;
import io.requery.proxy.Settable;
import io.requery.query.Condition;
import io.requery.query.Deletion;
import io.requery.query.Expression;
import io.requery.query.FieldExpression;
import io.requery.query.MutableResult;
import io.requery.query.Scalar;
import io.requery.query.Where;
import io.requery.query.element.QueryElement;
import io.requery.query.element.QueryType;
import io.requery.sql.Attributes;
import io.requery.sql.BatchUpdateOperation;
import io.requery.sql.EntityContext;
import io.requery.sql.EntityReader;
import io.requery.sql.EntityUpdateOperation;
import io.requery.sql.GeneratedKeys;
import io.requery.sql.GeneratedResultReader;
import io.requery.sql.Mapping;
import io.requery.sql.MissingKeyException;
import io.requery.sql.MissingVersionException;
import io.requery.sql.OptimisticLockException;
import io.requery.sql.ParameterBinder;
import io.requery.sql.RowCountException;
import io.requery.sql.UpdateOperation;
import io.requery.sql.VersionColumnDefinition;
import io.requery.util.Objects;
import io.requery.util.ObservableCollection;
import io.requery.util.function.Function;
import io.requery.util.function.Predicate;
import io.requery.util.function.Supplier;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class EntityWriter<E extends S, S>
implements ParameterBinder<E> {
    private final EntityCache cache;
    private final EntityModel model;
    private final Type<E> type;
    private final EntityContext<S> context;
    private final Mapping mapping;
    private final Queryable<S> queryable;
    private final boolean hasGeneratedKey;
    private final boolean hasForeignKeys;
    private final int keyCount;
    private final Attribute<E, ?> keyAttribute;
    private final Attribute<E, ?> versionAttribute;
    private final Attribute<E, ?>[] bindableAttributes;
    private final Attribute<E, ?>[] whereAttributes;
    private final Attribute<E, ?>[] associativeAttributes;
    private final String[] generatedColumnNames;
    private final Class<E> entityClass;
    private final Function<E, EntityProxy<E>> proxyProvider;
    private final boolean cacheable;
    private final boolean stateless;
    private final boolean hasDefaultValues;

    EntityWriter(Type<E> type2, EntityContext<S> context, Queryable<S> queryable) {
        this.type = Objects.requireNotNull(type2);
        this.context = Objects.requireNotNull(context);
        this.queryable = Objects.requireNotNull(queryable);
        this.cache = this.context.getCache();
        this.model = this.context.getModel();
        this.mapping = this.context.getMapping();
        boolean hasGeneratedKey = false;
        boolean hasForeignKeys = false;
        boolean hasDefaultValues = false;
        Attribute<E, ?> versionAttribute = null;
        for (Attribute<E, ?> attribute : type2.getAttributes()) {
            if (attribute.isKey() && attribute.isGenerated()) {
                hasGeneratedKey = true;
            }
            if (attribute.isVersion()) {
                versionAttribute = attribute;
            }
            if (attribute.isForeignKey()) {
                hasForeignKeys = true;
            }
            if (attribute.getDefaultValue() == null) continue;
            hasDefaultValues = true;
        }
        this.hasGeneratedKey = hasGeneratedKey;
        this.hasForeignKeys = hasForeignKeys;
        this.versionAttribute = versionAttribute;
        this.hasDefaultValues = hasDefaultValues;
        this.keyAttribute = type2.getSingleKeyAttribute();
        this.keyCount = type2.getKeyAttributes().size();
        Set<Attribute<E, ?>> keys2 = type2.getKeyAttributes();
        ArrayList<String> generatedKeyNames = new ArrayList<String>();
        for (Attribute attribute : keys2) {
            if (!attribute.isGenerated()) continue;
            generatedKeyNames.add(attribute.getName());
        }
        this.generatedColumnNames = generatedKeyNames.toArray(new String[generatedKeyNames.size()]);
        this.entityClass = type2.getClassType();
        this.proxyProvider = type2.getProxyProvider();
        this.cacheable = !type2.getKeyAttributes().isEmpty() && type2.isCacheable();
        this.stateless = type2.isStateless();
        Predicate bindable = new Predicate<Attribute<E, ?>>(){

            @Override
            public boolean test(Attribute<E, ?> value) {
                boolean isGeneratedKey = value.isGenerated() && value.isKey();
                boolean isSystemVersion = value.isVersion() && EntityWriter.this.hasSystemVersionColumn();
                boolean isAssociation = value.isAssociation() && !value.isForeignKey() && !value.isKey();
                boolean isReadOnly = value.isReadOnly();
                return !isGeneratedKey && !isSystemVersion && !isAssociation && !isReadOnly;
            }
        };
        this.bindableAttributes = Attributes.toArray(type2.getAttributes(), bindable);
        this.associativeAttributes = Attributes.toArray(type2.getAttributes(), new Predicate<Attribute<E, ?>>(){

            @Override
            public boolean test(Attribute<E, ?> value) {
                return value.isAssociation();
            }
        });
        if (this.keyCount == 0) {
            this.whereAttributes = Attributes.newArray(type2.getAttributes().size());
            type2.getAttributes().toArray(this.whereAttributes);
        } else {
            boolean bl = versionAttribute != null;
            this.whereAttributes = Attributes.newArray(this.keyCount + (bl ? 1 : 0));
            int index = 0;
            for (Attribute attribute : keys2) {
                this.whereAttributes[index++] = attribute;
            }
            if (bl) {
                this.whereAttributes[index] = versionAttribute;
            }
        }
    }

    private void checkRowsAffected(int count, E entity, EntityProxy<E> proxy) {
        if (proxy != null && this.versionAttribute != null && count == 0) {
            throw new OptimisticLockException(entity, proxy.get(this.versionAttribute));
        }
        if (count != 1) {
            throw new RowCountException(entity.getClass(), 1L, count);
        }
    }

    private boolean hasSystemVersionColumn() {
        return !this.context.getPlatform().versionColumnDefinition().createColumn();
    }

    private boolean canBatchInStatement() {
        if (this.hasDefaultValues) {
            return false;
        }
        boolean canBatchStatement = this.context.supportsBatchUpdates();
        boolean canBatchGeneratedKey = this.context.getPlatform().supportsGeneratedKeysInBatchUpdate();
        return this.hasGeneratedKey ? canBatchStatement && canBatchGeneratedKey : canBatchStatement;
    }

    private void cascadeBatch(Map<Class<? extends S>, List<S>> map) {
        for (Map.Entry<Class<S>, List<S>> entry : map.entrySet()) {
            Class<? extends S> key = entry.getKey();
            this.context.write(key).batchInsert((Iterable)entry.getValue(), false);
        }
    }

    private S foreignKeyReference(EntityProxy<E> proxy, Attribute<E, ?> attribute) {
        if (attribute.isForeignKey() && attribute.isAssociation()) {
            return (S)proxy.get(attribute);
        }
        return null;
    }

    GeneratedKeys<E> batchInsert(Iterable<E> entities, boolean returnKeys) {
        final boolean batchInStatement = this.canBatchInStatement();
        int batchSize = this.context.getBatchUpdateSize();
        EntityReader<E, S> reader = this.context.read(this.entityClass);
        Iterator<E> iterator2 = entities.iterator();
        final boolean isImmtuable = this.type.isImmutable();
        final GeneratedKeys keys2 = returnKeys && this.hasGeneratedKey ? new GeneratedKeys() : null;
        int collectionSize = entities instanceof Collection ? ((Collection)entities).size() : -1;
        final Object[] elements = new Object[Math.min(collectionSize, batchSize)];
        while (iterator2.hasNext()) {
            int index;
            HashMap<Class<S>, List<S>> associations = new HashMap<Class<S>, List<S>>();
            for (index = 0; iterator2.hasNext() && index < batchSize; ++index) {
                E entity = iterator2.next();
                EntityProxy<E> proxy = this.proxyProvider.apply(entity);
                elements[index] = entity;
                if (this.hasForeignKeys) {
                    for (Attribute<E, ?> attribute : this.associativeAttributes) {
                        EntityProxy<S> otherProxy;
                        S referenced = this.foreignKeyReference(proxy, attribute);
                        if (referenced == null || (otherProxy = this.context.proxyOf(referenced, false)) == null || otherProxy.isLinked()) continue;
                        Class<S> key = otherProxy.type().getClassType();
                        ArrayList<S> values2 = (ArrayList<S>)associations.get(key);
                        if (values2 == null) {
                            values2 = new ArrayList<S>();
                            associations.put(key, values2);
                        }
                        values2.add(referenced);
                    }
                }
                this.incrementVersion(proxy);
                this.context.getStateListener().preInsert(entity, proxy);
            }
            this.cascadeBatch(associations);
            final int count = index;
            GeneratedResultReader keyReader = null;
            if (this.hasGeneratedKey) {
                keyReader = new GeneratedResultReader(){

                    @Override
                    public void read(int index, ResultSet results) throws SQLException {
                        int readCount = batchInStatement ? count : 1;
                        for (int i = index; i < index + readCount; ++i) {
                            if (!results.next()) {
                                throw new IllegalStateException();
                            }
                            EntityProxy proxy = (EntityProxy)EntityWriter.this.proxyProvider.apply(elements[i]);
                            EntityProxy keyProxy = keys2 == null ? proxy : keys2.proxy(isImmtuable ? null : proxy);
                            EntityWriter.this.readGeneratedKeys(keyProxy, results);
                        }
                    }

                    @Override
                    public String[] generatedColumns() {
                        return EntityWriter.this.generatedColumnNames;
                    }
                };
            }
            BatchUpdateOperation<Object> operation = new BatchUpdateOperation<Object>(this.context, elements, count, this, keyReader, batchInStatement);
            QueryElement<int[]> query = new QueryElement<int[]>(QueryType.INSERT, this.model, operation);
            query.from(new Class[]{this.entityClass});
            for (Attribute<E, ?> attribute : this.bindableAttributes) {
                query.value((Expression)((Object)attribute), null);
            }
            int[] updates = query.get();
            for (int i = 0; i < updates.length; ++i) {
                Object entity = elements[i];
                EntityProxy<E> proxy = this.proxyProvider.apply(entity);
                this.checkRowsAffected(updates[i], entity, proxy);
                proxy.link(reader);
                this.updateAssociations(Cascade.AUTO, entity, proxy, null);
                this.context.getStateListener().postInsert(entity, proxy);
                if (!this.cacheable) continue;
                this.cache.put(this.entityClass, proxy.key(), entity);
            }
        }
        return keys2;
    }

    private void readGeneratedKeys(Settable<E> proxy, ResultSet results) throws SQLException {
        if (this.keyAttribute != null) {
            this.readKeyFromResult(this.keyAttribute, proxy, results);
        } else {
            for (Attribute<E, ?> key : this.type.getKeyAttributes()) {
                this.readKeyFromResult(key, proxy, results);
            }
        }
    }

    private void readKeyFromResult(Attribute<E, ?> key, Settable<E> proxy, ResultSet results) throws SQLException {
        String column = key.getName();
        int resultIndex = 1;
        try {
            resultIndex = results.findColumn(column);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (key.getPrimitiveKind() != null) {
            switch (key.getPrimitiveKind()) {
                case INT: {
                    int intValue = this.mapping.readInt(results, resultIndex);
                    proxy.setInt(key, intValue, PropertyState.LOADED);
                    break;
                }
                case LONG: {
                    long longValue = this.mapping.readLong(results, resultIndex);
                    proxy.setLong(key, longValue, PropertyState.LOADED);
                }
            }
        } else {
            Object generatedKey = this.mapping.read((Expression)((Object)key), results, resultIndex);
            if (generatedKey == null) {
                throw new MissingKeyException();
            }
            proxy.setObject(key, generatedKey, PropertyState.LOADED);
        }
    }

    @Override
    public int bindParameters(PreparedStatement statement, E element, Predicate<Attribute<E, ?>> filter) throws SQLException {
        int i = 0;
        EntityProxy<E> proxy = this.type.getProxyProvider().apply(element);
        for (Attribute<E, ?> attribute : this.bindableAttributes) {
            Object value;
            if (filter != null && !filter.test(attribute)) continue;
            if (attribute.isAssociation()) {
                value = proxy.getKey(attribute);
                this.mapping.write((Expression)((Object)attribute), statement, i + 1, value);
            } else if (attribute.getPrimitiveKind() != null) {
                this.mapPrimitiveType(proxy, attribute, statement, i + 1);
            } else {
                value = proxy.get(attribute, false);
                this.mapping.write((Expression)((Object)attribute), statement, i + 1, value);
            }
            proxy.setState(attribute, PropertyState.LOADED);
            ++i;
        }
        return i;
    }

    private void mapPrimitiveType(EntityProxy<E> proxy, Attribute<E, ?> attribute, PreparedStatement statement, int index) throws SQLException {
        switch (attribute.getPrimitiveKind()) {
            case BYTE: {
                byte byteValue = proxy.getByte(attribute);
                this.mapping.writeByte(statement, index, byteValue);
                break;
            }
            case SHORT: {
                short shortValue = proxy.getShort(attribute);
                this.mapping.writeShort(statement, index, shortValue);
                break;
            }
            case INT: {
                int intValue = proxy.getInt(attribute);
                this.mapping.writeInt(statement, index, intValue);
                break;
            }
            case LONG: {
                long longValue = proxy.getLong(attribute);
                this.mapping.writeLong(statement, index, longValue);
                break;
            }
            case BOOLEAN: {
                boolean booleanValue = proxy.getBoolean(attribute);
                this.mapping.writeBoolean(statement, index, booleanValue);
                break;
            }
            case FLOAT: {
                float floatValue = proxy.getFloat(attribute);
                this.mapping.writeFloat(statement, index, floatValue);
                break;
            }
            case DOUBLE: {
                double doubleValue = proxy.getDouble(attribute);
                this.mapping.writeDouble(statement, index, doubleValue);
            }
        }
    }

    void insert(E entity, EntityProxy<E> proxy, GeneratedKeys<E> keys2) {
        this.insert(entity, proxy, Cascade.AUTO, keys2);
    }

    void insert(final E entity, EntityProxy<E> proxy, Cascade mode, GeneratedKeys<E> keys2) {
        GeneratedResultReader keyReader = null;
        if (this.hasGeneratedKey) {
            final Settable<E> settable = keys2 == null ? proxy : keys2;
            keyReader = new GeneratedResultReader(){

                @Override
                public void read(int index, ResultSet results) throws SQLException {
                    if (results.next()) {
                        EntityWriter.this.readGeneratedKeys(settable, results);
                    }
                }

                @Override
                public String[] generatedColumns() {
                    return EntityWriter.this.generatedColumnNames;
                }
            };
        }
        final Predicate<Attribute<E, ?>> filter = this.filterDefaultValues(proxy);
        EntityUpdateOperation insert2 = new EntityUpdateOperation(this.context, keyReader){

            @Override
            public int bindParameters(PreparedStatement statement) throws SQLException {
                return EntityWriter.this.bindParameters(statement, entity, filter);
            }
        };
        QueryElement<Scalar<Integer>> query = new QueryElement<Scalar<Integer>>(QueryType.INSERT, this.model, insert2);
        query.from(new Class[]{this.entityClass});
        for (Attribute<E, ?> attribute : this.associativeAttributes) {
            if (!attribute.getCascadeActions().contains((Object)CascadeAction.SAVE)) continue;
            this.cascadeKeyReference(Cascade.INSERT, proxy, attribute);
        }
        this.incrementVersion(proxy);
        for (Attribute<E, ?> attribute : this.bindableAttributes) {
            if (filter != null && !filter.test(attribute)) continue;
            query.value((Expression)((Object)attribute), null);
        }
        this.context.getStateListener().preInsert(entity, proxy);
        this.checkRowsAffected(query.get().value(), entity, null);
        proxy.link(this.context.read(this.entityClass));
        this.updateAssociations(mode, entity, proxy, null);
        this.context.getStateListener().postInsert(entity, proxy);
        if (this.cacheable) {
            this.cache.put(this.entityClass, proxy.key(), entity);
        }
    }

    private Predicate<Attribute<E, ?>> filterDefaultValues(final EntityProxy<E> proxy) {
        if (this.hasDefaultValues) {
            return new Predicate<Attribute<E, ?>>(){

                @Override
                public boolean test(Attribute<E, ?> value) {
                    return value.getDefaultValue() == null || proxy.getState(value) == PropertyState.MODIFIED;
                }
            };
        }
        return null;
    }

    public void upsert(E entity, EntityProxy<E> proxy) {
        if (this.hasGeneratedKey) {
            if (this.hasKey(proxy)) {
                this.update(entity, proxy, Cascade.UPSERT, null, null);
            } else {
                this.insert(entity, proxy, Cascade.UPSERT, null);
            }
        } else if (this.context.getPlatform().supportsUpsert()) {
            this.context.getStateListener().preUpdate(entity, proxy);
            for (Attribute<E, ?> attribute : this.associativeAttributes) {
                this.cascadeKeyReference(Cascade.UPSERT, proxy, attribute);
            }
            this.incrementVersion(proxy);
            List<Attribute<E, ?>> attributes = Arrays.asList(this.bindableAttributes);
            UpdateOperation upsert2 = new UpdateOperation(this.context);
            QueryElement<Scalar<Integer>> element = new QueryElement<Scalar<Integer>>(QueryType.UPSERT, this.model, upsert2);
            for (Attribute attribute : attributes) {
                element.value((Expression)((Object)attribute), proxy.get(attribute, false));
            }
            int rows = (Integer)upsert2.evaluate((QueryElement)element).value();
            if (rows <= 0) {
                throw new RowCountException(entity.getClass(), 1L, rows);
            }
            proxy.link(this.context.read(this.entityClass));
            this.updateAssociations(Cascade.UPSERT, entity, proxy, null);
            if (this.cacheable) {
                this.cache.put(this.entityClass, proxy.key(), entity);
            }
            this.context.getStateListener().postUpdate(entity, proxy);
        } else if (this.update(entity, proxy, Cascade.UPSERT, null, null) == 0) {
            this.insert(entity, proxy, Cascade.UPSERT, null);
        }
    }

    public void update(E entity, EntityProxy<E> proxy, Attribute<E, ?>[] attributes) {
        final List<Attribute<E, ?>> list = Arrays.asList(attributes);
        this.update(entity, proxy, Cascade.AUTO, new Predicate<Attribute<E, ?>>(){

            @Override
            public boolean test(Attribute<E, ?> value) {
                return list.contains(value) && !value.isAssociation();
            }
        }, new Predicate<Attribute<E, ?>>(){

            @Override
            public boolean test(Attribute<E, ?> value) {
                return list.contains(value) && value.isAssociation();
            }
        });
    }

    public void update(E entity, EntityProxy<E> proxy) {
        int count = this.update(entity, proxy, Cascade.AUTO, null, null);
        if (count != -1) {
            this.checkRowsAffected(count, entity, proxy);
        }
    }

    private int update(final E entity, final EntityProxy<E> proxy, Cascade mode, Predicate<Attribute<E, ?>> filterBindable, Predicate<Attribute<E, ?>> filterAssociations) {
        this.context.getStateListener().preUpdate(entity, proxy);
        if (filterBindable == null) {
            final ArrayList list = new ArrayList();
            for (Attribute<E, ?> value : this.bindableAttributes) {
                if (!this.stateless && proxy.getState(value) != PropertyState.MODIFIED) continue;
                list.add(value);
            }
            filterBindable = new Predicate<Attribute<E, ?>>(){

                @Override
                public boolean test(Attribute<E, ?> value) {
                    return list.contains(value) || value == EntityWriter.this.versionAttribute && !EntityWriter.this.hasSystemVersionColumn();
                }
            };
        }
        boolean hasVersion = this.versionAttribute != null;
        final Object version = hasVersion ? this.incrementVersion(proxy, filterBindable) : null;
        final Predicate filter = filterBindable;
        EntityUpdateOperation operation = new EntityUpdateOperation(this.context, null){

            @Override
            public int bindParameters(PreparedStatement statement) throws SQLException {
                int index = EntityWriter.this.bindParameters(statement, entity, filter);
                for (Attribute attribute : EntityWriter.this.whereAttributes) {
                    if (attribute == EntityWriter.this.versionAttribute) {
                        EntityWriter.this.mapping.write((Expression)((Object)attribute), statement, index + 1, version);
                    } else if (attribute.getPrimitiveKind() != null) {
                        EntityWriter.this.mapPrimitiveType(proxy, attribute, statement, index + 1);
                    } else {
                        Object value = attribute.isKey() && attribute.isAssociation() ? proxy.getKey(attribute) : proxy.get(attribute, false);
                        EntityWriter.this.mapping.write((Expression)((Object)attribute), statement, index + 1, value);
                    }
                    ++index;
                }
                return index;
            }
        };
        QueryElement<Scalar<Integer>> query = new QueryElement<Scalar<Integer>>(QueryType.UPDATE, this.model, operation);
        query.from(new Class[]{this.entityClass});
        int count = 0;
        for (Attribute<E, ?> attribute : this.bindableAttributes) {
            if (!filterBindable.test(attribute)) continue;
            S referenced = this.foreignKeyReference(proxy, attribute);
            if (referenced != null && !this.stateless && !attribute.getCascadeActions().contains((Object)CascadeAction.NONE)) {
                proxy.setState(attribute, PropertyState.LOADED);
                this.cascadeWrite(mode, referenced, null);
            }
            query.set((Expression)((Object)attribute), null);
            ++count;
        }
        int result2 = -1;
        if (count > 0) {
            if (this.keyAttribute != null) {
                query.where((Condition)Attributes.query(this.keyAttribute).equal("?"));
            } else {
                for (Attribute<E, ?> attribute : this.whereAttributes) {
                    if (attribute == this.versionAttribute) continue;
                    query.where((Condition)Attributes.query(attribute).equal("?"));
                }
            }
            if (hasVersion) {
                this.addVersionCondition(query, version);
            }
            result2 = query.get().value();
            EntityReader<E, S> reader = this.context.read(this.entityClass);
            proxy.link(reader);
            if (hasVersion && this.hasSystemVersionColumn()) {
                reader.refresh(entity, proxy, this.versionAttribute);
            }
            if (result2 > 0) {
                this.updateAssociations(mode, entity, proxy, filterAssociations);
            }
        } else {
            this.updateAssociations(mode, entity, proxy, filterAssociations);
        }
        this.context.getStateListener().postUpdate(entity, proxy);
        return result2;
    }

    private void addVersionCondition(Where<?> where, Object version) {
        QueryAttribute attribute = Attributes.query(this.versionAttribute);
        VersionColumnDefinition definition = this.context.getPlatform().versionColumnDefinition();
        String name = definition.columnName();
        if (!definition.createColumn() && name != null) {
            FieldExpression expression = (FieldExpression)attribute.as(name);
            where.where(expression.equal(version));
        } else {
            where.where((Condition)attribute.equal(version));
        }
    }

    private void updateAssociations(Cascade mode, E entity, EntityProxy<E> proxy, Predicate<Attribute<E, ?>> filter) {
        for (Attribute<E, ?> attribute : this.associativeAttributes) {
            if ((filter == null || !filter.test(attribute)) && !this.stateless && proxy.getState(attribute) != PropertyState.MODIFIED) continue;
            this.updateAssociation(mode, entity, proxy, attribute);
        }
    }

    private void updateAssociation(Cascade mode, E entity, EntityProxy<E> proxy, Attribute<E, ?> attribute) {
        switch (attribute.getCardinality()) {
            case ONE_TO_ONE: {
                Object value = proxy.get(attribute, false);
                if (value != null) {
                    QueryAttribute mapped = Attributes.get(attribute.getMappedAttribute());
                    EntityProxy<?> referred = this.context.proxyOf(value, true);
                    referred.set(mapped, entity, PropertyState.MODIFIED);
                    this.cascadeWrite(mode, value, referred);
                    break;
                }
                if (this.stateless) break;
                throw new PersistenceException("1-1 relationship can only be removed from the owning side");
            }
            case ONE_TO_MANY: {
                Object relation = proxy.get(attribute, false);
                if (relation instanceof ObservableCollection) {
                    ObservableCollection collection = (ObservableCollection)relation;
                    CollectionChanges changes = (CollectionChanges)collection.observer();
                    ArrayList added = new ArrayList(changes.addedElements());
                    ArrayList removed = new ArrayList(changes.removedElements());
                    changes.clear();
                    for (Object element : added) {
                        this.updateMappedAssociation(mode, element, attribute, entity);
                    }
                    for (Object element : removed) {
                        this.updateMappedAssociation(Cascade.UPDATE, element, attribute, null);
                    }
                    break;
                }
                if (relation instanceof Iterable) {
                    Iterable iterable = (Iterable)relation;
                    for (Object added : iterable) {
                        this.updateMappedAssociation(mode, added, attribute, entity);
                    }
                    break;
                }
                throw new IllegalStateException("unsupported relation type " + relation);
            }
            case MANY_TO_MANY: {
                Object collection;
                Class<?> referencedClass = attribute.getReferencedClass();
                if (referencedClass == null) {
                    throw new IllegalStateException("Invalid referenced class in " + attribute);
                }
                Type<?> referencedType = this.model.typeOf(referencedClass);
                QueryAttribute tKey = null;
                QueryAttribute uKey = null;
                for (Attribute<?, ?> a : referencedType.getAttributes()) {
                    Class<?> referenced = a.getReferencedClass();
                    if (referenced == null) continue;
                    if (tKey == null && this.entityClass.isAssignableFrom(referenced)) {
                        tKey = Attributes.query(a);
                        continue;
                    }
                    if (attribute.getElementClass() == null || !attribute.getElementClass().isAssignableFrom(referenced)) continue;
                    uKey = Attributes.query(a);
                }
                Objects.requireNotNull(tKey);
                Objects.requireNotNull(uKey);
                QueryAttribute tRef = Attributes.get(tKey.getReferencedAttribute());
                QueryAttribute uRef = Attributes.get(uKey.getReferencedAttribute());
                CollectionChanges changes = null;
                Object relation = proxy.get(attribute, false);
                Collection addedElements = (Collection)relation;
                boolean isObservable = relation instanceof ObservableCollection;
                if (relation instanceof ObservableCollection && (changes = (CollectionChanges)(collection = (ObservableCollection)relation).observer()) != null) {
                    addedElements = changes.addedElements();
                }
                for (Object added : addedElements) {
                    Object junction = referencedType.getFactory().get();
                    EntityProxy<?> junctionProxy = this.context.proxyOf(junction, false);
                    EntityProxy uProxy = this.context.proxyOf(added, false);
                    if (attribute.getCascadeActions().contains((Object)CascadeAction.SAVE)) {
                        this.cascadeWrite(mode, added, uProxy);
                    }
                    Object tValue = proxy.get(tRef, false);
                    Object uValue = uProxy.get(uRef, false);
                    junctionProxy.set(tKey, tValue, PropertyState.MODIFIED);
                    junctionProxy.set(uKey, uValue, PropertyState.MODIFIED);
                    Cascade cascade = isObservable && mode == Cascade.UPSERT ? Cascade.UPSERT : Cascade.INSERT;
                    this.cascadeWrite(cascade, junction, null);
                }
                if (changes == null) break;
                Object keyValue = proxy.get(tRef, false);
                for (Object removed : changes.removedElements()) {
                    Object otherValue = this.context.proxyOf(removed, false).get(uRef);
                    Class<?> removeType = referencedType.getClassType();
                    Supplier query = (Supplier)this.queryable.delete(removeType).where((Condition)tKey.equal(keyValue)).and((Condition)uKey.equal(otherValue));
                    int count = (Integer)((Scalar)query.get()).value();
                    if (count == 1) continue;
                    throw new RowCountException(entity.getClass(), 1L, count);
                }
                changes.clear();
                break;
            }
        }
        this.context.read(this.type.getClassType()).refresh(entity, proxy, attribute);
    }

    private void incrementVersion(EntityProxy<E> proxy) {
        if (this.versionAttribute != null && !this.hasSystemVersionColumn()) {
            Object version = proxy.get(this.versionAttribute);
            Class<?> type2 = this.versionAttribute.getClassType();
            if (type2 == Long.class || type2 == Long.TYPE) {
                if (version == null) {
                    version = 1L;
                } else {
                    Long value = (Long)version;
                    version = value + 1L;
                }
            } else if (type2 == Integer.class || type2 == Integer.TYPE) {
                if (version == null) {
                    version = 1;
                } else {
                    Integer value = (Integer)version;
                    version = value + 1;
                }
            } else if (type2 == Timestamp.class) {
                version = new Timestamp(System.currentTimeMillis());
            } else {
                throw new PersistenceException("Unsupported version type: " + this.versionAttribute.getClassType());
            }
            proxy.setObject(this.versionAttribute, version, PropertyState.MODIFIED);
        }
    }

    private Object incrementVersion(EntityProxy<E> proxy, Predicate<Attribute<E, ?>> filter) {
        boolean modified = false;
        for (Attribute<E, ?> attribute : this.bindableAttributes) {
            if (attribute == this.versionAttribute || !filter.test(attribute)) continue;
            modified = true;
            break;
        }
        Object version = proxy.get(this.versionAttribute, true);
        if (modified) {
            if (version == null) {
                throw new MissingVersionException(proxy);
            }
            this.incrementVersion(proxy);
        }
        return version;
    }

    private void updateMappedAssociation(Cascade mode, S entity, Attribute attribute, Object value) {
        EntityProxy<S> proxy = this.context.proxyOf(entity, false);
        QueryAttribute mapped = Attributes.get(attribute.getMappedAttribute());
        proxy.set(mapped, value, PropertyState.MODIFIED);
        if (attribute.getCascadeActions().contains((Object)CascadeAction.SAVE)) {
            this.cascadeWrite(mode, entity, proxy);
        } else {
            this.cascadeWrite(Cascade.UPDATE, entity, proxy);
        }
    }

    public void delete(E entity, EntityProxy<E> proxy) {
        this.context.getStateListener().preDelete(entity, proxy);
        proxy.unlink();
        if (this.cacheable) {
            this.cache.invalidate(this.entityClass, proxy.key());
        }
        for (Attribute<E, ?> attribute : this.associativeAttributes) {
            boolean delete2 = attribute.getCascadeActions().contains((Object)CascadeAction.DELETE);
            if (!delete2 || !this.stateless && proxy.getState(attribute) != PropertyState.FETCH) continue;
            this.context.read(this.type.getClassType()).refresh(entity, proxy, attribute);
        }
        Deletion<Scalar<Integer>> deletion = this.queryable.delete(this.entityClass);
        for (Attribute<E, ?> attribute : this.whereAttributes) {
            if (attribute == this.versionAttribute) {
                Object version = proxy.get(this.versionAttribute, true);
                if (version == null) {
                    throw new MissingVersionException(proxy);
                }
                this.addVersionCondition(deletion, version);
                continue;
            }
            QueryAttribute id = Attributes.query(attribute);
            deletion.where((Condition)id.equal(proxy.get(attribute)));
        }
        int rows = (Integer)((Scalar)deletion.get()).value();
        boolean cascaded = this.clearAssociations(entity, proxy);
        if (!cascaded) {
            this.checkRowsAffected(rows, entity, proxy);
        }
        this.context.getStateListener().postDelete(entity, proxy);
    }

    private boolean clearAssociations(E entity, EntityProxy<E> proxy) {
        boolean cascade = false;
        block4: for (Attribute<E, ?> attribute : this.associativeAttributes) {
            boolean delete2 = attribute.getCascadeActions().contains((Object)CascadeAction.DELETE);
            Object value = proxy.get(attribute, false);
            proxy.set(attribute, null, PropertyState.LOADED);
            if (value == null) continue;
            if (delete2 && attribute.isForeignKey() && attribute.getDeleteAction() == ReferentialAction.CASCADE) {
                cascade = true;
            }
            switch (attribute.getCardinality()) {
                case ONE_TO_ONE: 
                case MANY_TO_ONE: {
                    Object element = value;
                    this.cascadeRemove(entity, element, delete2);
                    continue block4;
                }
                case ONE_TO_MANY: 
                case MANY_TO_MANY: {
                    if (!(value instanceof Iterable)) continue block4;
                    Iterable iterable = (Iterable)value;
                    ArrayList elements = new ArrayList();
                    Iterator<Object> iterator2 = iterable.iterator();
                    while (iterator2.hasNext()) {
                        Object item;
                        Object e = item = iterator2.next();
                        elements.add(e);
                    }
                    for (Object item : elements) {
                        this.cascadeRemove(entity, item, delete2);
                    }
                    continue block4;
                }
            }
        }
        return cascade;
    }

    private void cascadeKeyReference(Cascade mode, EntityProxy<E> proxy, Attribute<E, ?> attribute) {
        EntityProxy<S> referred;
        S referenced = this.foreignKeyReference(proxy, attribute);
        if (referenced != null && proxy.getState(attribute) == PropertyState.MODIFIED && !(referred = this.context.proxyOf(referenced, false)).isLinked()) {
            proxy.setState(attribute, PropertyState.LOADED);
            this.cascadeWrite(mode, referenced, null);
        }
    }

    private <U extends S> void cascadeWrite(Cascade mode, U entity, EntityProxy<U> proxy) {
        if (entity != null) {
            if (proxy == null) {
                proxy = this.context.proxyOf(entity, false);
            }
            EntityWriter<U, S> writer = this.context.write(proxy.type().getClassType());
            if (mode == Cascade.AUTO) {
                mode = proxy.isLinked() ? Cascade.UPDATE : Cascade.UPSERT;
            }
            switch (mode) {
                case INSERT: {
                    writer.insert(entity, proxy, mode, null);
                    break;
                }
                case UPDATE: {
                    int updated = super.update(entity, proxy, mode, null, null);
                    if (updated != 0) break;
                    throw new RowCountException(entity.getClass(), 1L, updated);
                }
                case UPSERT: {
                    writer.upsert(entity, proxy);
                }
            }
        }
    }

    private <U extends S> void cascadeRemove(E entity, U element, boolean delete2) {
        EntityProxy<U> proxy = this.context.proxyOf(element, false);
        if (proxy != null) {
            EntityWriter<U, S> writer = this.context.write(proxy.type().getClassType());
            if (delete2 && proxy.isLinked()) {
                writer.delete(element, proxy);
            } else {
                super.removeEntity(proxy, entity);
            }
        }
    }

    void delete(Iterable<E> entities) {
        if (this.keyCount == 0) {
            for (E entity : entities) {
                this.delete(entity, this.type.getProxyProvider().apply(entity));
            }
        } else {
            this.batchDelete(entities);
        }
    }

    private void batchDelete(Iterable<E> entities) {
        int batchSize = this.context.getBatchUpdateSize();
        Iterator<E> iterator2 = entities.iterator();
        while (iterator2.hasNext()) {
            LinkedList<Object> ids = new LinkedList<Object>();
            while (iterator2.hasNext() && ids.size() < batchSize) {
                E entity = iterator2.next();
                EntityProxy<E> proxy = this.context.proxyOf(entity, true);
                if (this.versionAttribute != null || this.keyCount > 1) {
                    this.delete(entity, proxy);
                    continue;
                }
                this.context.getStateListener().preDelete(entity, proxy);
                boolean bl = this.clearAssociations(entity, proxy);
                Object key = proxy.key();
                if (this.cacheable) {
                    this.cache.invalidate(this.entityClass, key);
                }
                if (!bl) {
                    ids.add(key);
                }
                proxy.unlink();
                this.context.getStateListener().postDelete(entity, proxy);
            }
            if (ids.size() <= 0) continue;
            Deletion<Scalar<Integer>> deletion = this.queryable.delete(this.entityClass);
            for (Attribute attribute : this.type.getKeyAttributes()) {
                QueryAttribute id = Attributes.query(attribute);
                deletion.where((Condition)id.in(ids));
            }
            int rows = (Integer)((Scalar)deletion.get()).value();
            if (rows == ids.size()) continue;
            throw new RowCountException(this.entityClass, ids.size(), rows);
        }
    }

    private <U extends S> boolean hasKey(EntityProxy<U> proxy) {
        Type<U> type2 = proxy.type();
        if (this.keyCount > 0) {
            for (Attribute<U, ?> attribute : type2.getKeyAttributes()) {
                PropertyState state = proxy.getState(attribute);
                if (state == PropertyState.MODIFIED || state == PropertyState.LOADED) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void removeEntity(EntityProxy<E> proxy, S entity) {
        block4: for (Attribute<E, ?> attribute : this.associativeAttributes) {
            Object value = proxy.get(attribute, false);
            switch (attribute.getCardinality()) {
                case ONE_TO_ONE: 
                case MANY_TO_ONE: {
                    if (value != entity) continue block4;
                    proxy.set(attribute, null, PropertyState.LOADED);
                    continue block4;
                }
                case ONE_TO_MANY: 
                case MANY_TO_MANY: {
                    if (value instanceof Collection) {
                        Collection collection = (Collection)value;
                        collection.remove(entity);
                        continue block4;
                    }
                    if (!(value instanceof MutableResult)) continue block4;
                    MutableResult result2 = (MutableResult)value;
                    result2.remove(entity);
                }
            }
        }
    }

    private static enum Cascade {
        AUTO,
        INSERT,
        UPDATE,
        UPSERT;

    }
}

