/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.db;

import eu.pretix.libpretixsync.db.LocalObject;
import eu.pretix.libpretixsync.db.Receipt;
import io.requery.Entity;
import io.requery.Generated;
import io.requery.Key;
import io.requery.Nullable;
import io.requery.OneToMany;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

@Entity(cacheable=false)
public class AbstractClosing
implements LocalObject {
    @Generated
    @Key
    public Long id;
    public Long server_id;
    @Nullable
    public boolean dsfinvk_uploaded;
    public Date datetime;
    public boolean open;
    public Long cashier_numericid;
    public String cashier_userid;
    public String cashier_name;
    @Nullable
    public Long first_receipt;
    @Nullable
    public Long last_receipt;
    @OneToMany
    public List<Receipt> receipts;
    @Nullable
    public BigDecimal payment_sum;
    @Nullable
    public BigDecimal payment_sum_cash;
    @Nullable
    public BigDecimal cash_counted;
    @Nullable
    public String json_data;
    @Nullable
    public String invoice_settings;

    public JSONObject getInvoiceSettings() throws JSONException {
        try {
            return new JSONObject(this.invoice_settings != null ? this.invoice_settings : "{}");
        }
        catch (JSONException e) {
            return new JSONObject();
        }
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(tz);
        JSONObject jo = new JSONObject();
        jo.put("closing_id", this.id);
        jo.put("first_receipt", this.first_receipt);
        jo.put("last_receipt", this.last_receipt);
        jo.put("payment_sum", this.payment_sum.setScale(2, RoundingMode.HALF_UP));
        jo.put("payment_sum_cash", this.payment_sum_cash.setScale(2, RoundingMode.HALF_UP));
        jo.put("cash_counted", this.cash_counted.setScale(2, RoundingMode.HALF_UP));
        jo.put("datetime", df.format(this.datetime));
        jo.put("invoice_settings", this.invoice_settings);
        jo.put("cashier", this.cashier_numericid);
        jo.put("data", this.json_data != null ? new JSONObject(this.json_data) : new JSONObject());
        return jo;
    }
}

