/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.sync;

import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.db.Item;
import eu.pretix.libpretixsync.db.Quota;
import eu.pretix.libpretixsync.sync.BaseDownloadSyncAdapter;
import eu.pretix.libpretixsync.sync.FileStorage;
import eu.pretix.libpretixsync.sync.SyncManager;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.meta.QueryAttribute;
import io.requery.query.Result;
import io.requery.query.Tuple;
import io.requery.query.WhereAndOr;
import io.requery.util.CloseableIterator;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class QuotaSyncAdapter
extends BaseDownloadSyncAdapter<Quota, Long> {
    private Long subeventId;

    public QuotaSyncAdapter(BlockingEntityStore<Persistable> store, FileStorage fileStorage2, String eventSlug, PretixApi api, String syncCycleId, SyncManager.ProgressFeedback feedback, Long subeventId) {
        super(store, fileStorage2, eventSlug, api, syncCycleId, feedback);
        this.subeventId = subeventId;
    }

    @Override
    protected String getUrl() {
        Object url2 = this.api.eventResourceUrl(this.eventSlug, this.getResourceName());
        url2 = (String)url2 + "?with_availability=true";
        if (this.subeventId != null && this.subeventId > 0L) {
            url2 = (String)url2 + "&subevent=" + this.subeventId;
        }
        return url2;
    }

    @Override
    public void updateObject(Quota obj, JSONObject jsonobj) throws JSONException {
        obj.setEvent_slug(this.eventSlug);
        obj.setServer_id(jsonobj.getLong("id"));
        obj.setSubevent_id(jsonobj.optLong("subevent"));
        obj.setJson_data(jsonobj.toString());
        obj.setSize(jsonobj.isNull("size") ? null : Long.valueOf(jsonobj.getLong("size")));
        if (jsonobj.has("available")) {
            obj.setAvailable(jsonobj.getBoolean("available") ? 1L : 0L);
            obj.setAvailable_number(jsonobj.isNull("available_number") ? null : Long.valueOf(jsonobj.getLong("available_number")));
        } else {
            obj.setAvailable(null);
            obj.setAvailable_number(null);
        }
        JSONArray itemsarr = jsonobj.getJSONArray("items");
        ArrayList<Long> itemids = new ArrayList<Long>();
        for (int i = 0; i < itemsarr.length(); ++i) {
            itemids.add(itemsarr.getLong(i));
        }
        List items = ((Result)this.store.select(Item.class, new QueryAttribute[0]).where(Item.SERVER_ID.in(itemids)).get()).toList();
        for (Item item : items) {
            if (obj.getItems().contains(item)) continue;
            obj.getItems().add(item);
        }
        obj.getItems().retainAll(items);
    }

    @Override
    public CloseableIterator<Quota> runBatch(List<Long> ids) {
        return ((Result)((WhereAndOr)this.store.select(Quota.class, new QueryAttribute[0]).where(Quota.EVENT_SLUG.eq((Object)this.eventSlug)).and(Quota.SERVER_ID.in(ids))).get()).iterator();
    }

    @Override
    CloseableIterator<Tuple> getKnownIDsIterator() {
        if (this.subeventId != null && this.subeventId > 0L) {
            return ((Result)((WhereAndOr)this.store.select(Quota.SERVER_ID).where(Quota.EVENT_SLUG.eq((Object)this.eventSlug)).and(Quota.SUBEVENT_ID.eq((Object)this.subeventId))).get()).iterator();
        }
        return ((Result)this.store.select(Quota.SERVER_ID).where(Quota.EVENT_SLUG.eq((Object)this.eventSlug)).get()).iterator();
    }

    @Override
    String getResourceName() {
        return "quotas";
    }

    @Override
    Long getId(JSONObject obj) throws JSONException {
        return obj.getLong("id");
    }

    @Override
    Long getId(Quota obj) {
        return obj.getServer_id();
    }

    @Override
    Quota newEmptyObject() {
        return new Quota();
    }
}

