/*
 * Decompiled with CFR 0.152.
 */
package io.requery.util;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class ClassMap<V>
implements Map<Class<?>, V> {
    private final IdentityHashMap<Class<?>, V> map = new IdentityHashMap();
    private Class[] keys;

    private Class<?> findKey(Class<?> key) {
        if (this.keys == null) {
            Set<Class<?>> keySet = this.keySet();
            this.keys = keySet.toArray(new Class[keySet.size()]);
        }
        for (Class cls : this.keys) {
            if (cls != key) continue;
            return cls;
        }
        for (Class cls : this.keys) {
            if (!cls.isAssignableFrom(key)) continue;
            return cls;
        }
        return null;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(this.findKey((Class)key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(this.findKey((Class)key));
    }

    @Override
    public V put(Class<?> key, V value) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        this.keys = null;
        return this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(@Nonnull Map<? extends Class<?>, ? extends V> m3) {
        for (Map.Entry<Class<?>, V> entry : m3.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    @Nonnull
    public Set<Class<?>> keySet() {
        return this.map.keySet();
    }

    @Override
    @Nonnull
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    @Nonnull
    public Set<Map.Entry<Class<?>, V>> entrySet() {
        return this.map.entrySet();
    }
}

