/*
 * Decompiled with CFR 0.152.
 */
package eu.pretix.libpretixsync.sync;

import eu.pretix.libpretixsync.api.PretixApi;
import eu.pretix.libpretixsync.db.BadgeLayout;
import eu.pretix.libpretixsync.db.BadgeLayoutItem;
import eu.pretix.libpretixsync.db.Item;
import eu.pretix.libpretixsync.sync.BaseDownloadSyncAdapter;
import eu.pretix.libpretixsync.sync.FileStorage;
import eu.pretix.libpretixsync.sync.SyncManager;
import io.requery.BlockingEntityStore;
import io.requery.Persistable;
import io.requery.meta.QueryAttribute;
import io.requery.query.Result;
import io.requery.query.Tuple;
import io.requery.query.WhereAndOr;
import io.requery.util.CloseableIterator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class BadgeLayoutItemSyncAdapter
extends BaseDownloadSyncAdapter<BadgeLayoutItem, Long> {
    private Map<Long, Item> itemCache = new HashMap<Long, Item>();
    private Map<Long, BadgeLayout> layoutCache = new HashMap<Long, BadgeLayout>();

    public BadgeLayoutItemSyncAdapter(BlockingEntityStore<Persistable> store, FileStorage fileStorage2, String eventSlug, PretixApi api, String syncCycleId, SyncManager.ProgressFeedback feedback) {
        super(store, fileStorage2, eventSlug, api, syncCycleId, feedback);
    }

    private Item getItem(long id) {
        if (this.itemCache.size() == 0) {
            List items = ((Result)this.store.select(Item.class, new QueryAttribute[0]).where(Item.EVENT_SLUG.eq((Object)this.eventSlug)).get()).toList();
            for (Item item : items) {
                this.itemCache.put(item.getServer_id(), item);
            }
        }
        return this.itemCache.get(id);
    }

    private BadgeLayout getLayout(long id) {
        if (this.layoutCache.size() == 0) {
            List items = ((Result)this.store.select(BadgeLayout.class, new QueryAttribute[0]).where(BadgeLayout.EVENT_SLUG.eq((Object)this.eventSlug)).get()).toList();
            for (BadgeLayout item : items) {
                this.layoutCache.put(item.getServer_id(), item);
            }
        }
        return this.layoutCache.get(id);
    }

    @Override
    public void updateObject(BadgeLayoutItem obj, JSONObject jsonobj) throws JSONException {
        obj.setItem(this.getItem(jsonobj.getLong("item")));
        if (!jsonobj.isNull("layout")) {
            obj.setLayout(this.getLayout(jsonobj.getLong("layout")));
        } else {
            obj.setLayout(null);
        }
        obj.setServer_id(jsonobj.getLong("id"));
        obj.setJson_data(jsonobj.toString());
    }

    @Override
    public CloseableIterator<BadgeLayoutItem> runBatch(List<Long> ids) {
        return ((Result)((WhereAndOr)this.store.select(BadgeLayoutItem.class, new QueryAttribute[0]).leftJoin(Item.class).on(Item.ID.eq(BadgeLayoutItem.ITEM_ID)).where(Item.EVENT_SLUG.eq((Object)this.eventSlug)).and(BadgeLayoutItem.SERVER_ID.in(ids))).get()).iterator();
    }

    @Override
    CloseableIterator<Tuple> getKnownIDsIterator() {
        return ((Result)this.store.select(BadgeLayoutItem.SERVER_ID).leftJoin(Item.class).on(Item.ID.eq(BadgeLayoutItem.ITEM_ID)).where(Item.EVENT_SLUG.eq((Object)this.eventSlug)).get()).iterator();
    }

    @Override
    String getResourceName() {
        return "badgeitems";
    }

    @Override
    Long getId(JSONObject obj) throws JSONException {
        return obj.getLong("id");
    }

    @Override
    Long getId(BadgeLayoutItem obj) {
        return obj.getServer_id();
    }

    @Override
    BadgeLayoutItem newEmptyObject() {
        return new BadgeLayoutItem();
    }
}

