/*
 * Decompiled with CFR 0.152.
 */
package io.requery.proxy;

import io.requery.meta.Attribute;
import io.requery.meta.Type;
import io.requery.proxy.BooleanProperty;
import io.requery.proxy.ByteProperty;
import io.requery.proxy.DoubleProperty;
import io.requery.proxy.FloatProperty;
import io.requery.proxy.IntProperty;
import io.requery.proxy.LongProperty;
import io.requery.proxy.Property;
import io.requery.proxy.PropertyState;
import io.requery.proxy.Settable;
import io.requery.proxy.ShortProperty;
import io.requery.util.function.Supplier;

public class EntityBuilderProxy<B, E>
implements Settable<E> {
    private final Type<E> type;
    private final B builder;

    public EntityBuilderProxy(Type<E> type2) {
        Supplier supplier = type2.getBuilderFactory();
        this.builder = supplier.get();
        this.type = type2;
    }

    @Override
    public <V> void set(Attribute<E, V> attribute, V value) {
        this.set(attribute, value, PropertyState.LOADED);
    }

    @Override
    public <V> void set(Attribute<E, V> attribute, V value, PropertyState state) {
        this.setObject(attribute, value, state);
    }

    @Override
    public void setObject(Attribute<E, ?> attribute, Object value, PropertyState state) {
        Property<?, ?> property = attribute.getBuilderProperty();
        property.set(this.builder, value);
    }

    @Override
    public void setBoolean(Attribute<E, Boolean> attribute, boolean value, PropertyState state) {
        BooleanProperty property = (BooleanProperty)attribute.getBuilderProperty();
        property.setBoolean(this.builder, value);
    }

    @Override
    public void setDouble(Attribute<E, Double> attribute, double value, PropertyState state) {
        DoubleProperty property = (DoubleProperty)attribute.getBuilderProperty();
        property.setDouble(this.builder, value);
    }

    @Override
    public void setFloat(Attribute<E, Float> attribute, float value, PropertyState state) {
        FloatProperty property = (FloatProperty)attribute.getBuilderProperty();
        property.setFloat(this.builder, value);
    }

    @Override
    public void setByte(Attribute<E, Byte> attribute, byte value, PropertyState state) {
        ByteProperty property = (ByteProperty)attribute.getBuilderProperty();
        property.setByte(this.builder, value);
    }

    @Override
    public void setShort(Attribute<E, Short> attribute, short value, PropertyState state) {
        ShortProperty property = (ShortProperty)attribute.getBuilderProperty();
        property.setShort(this.builder, value);
    }

    @Override
    public void setInt(Attribute<E, Integer> attribute, int value, PropertyState state) {
        IntProperty property = (IntProperty)attribute.getBuilderProperty();
        property.setInt(this.builder, value);
    }

    @Override
    public void setLong(Attribute<E, Long> attribute, long value, PropertyState state) {
        LongProperty property = (LongProperty)attribute.getBuilderProperty();
        property.setLong(this.builder, value);
    }

    public E build() {
        return this.type.getBuildFunction().apply(this.builder);
    }
}

