/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.EntityCache;
import io.requery.PersistenceException;
import io.requery.Queryable;
import io.requery.meta.Attribute;
import io.requery.meta.QueryAttribute;
import io.requery.meta.Type;
import io.requery.proxy.CompositeKey;
import io.requery.proxy.EntityBuilderProxy;
import io.requery.proxy.EntityProxy;
import io.requery.proxy.Initializer;
import io.requery.proxy.PropertyLoader;
import io.requery.proxy.PropertyState;
import io.requery.proxy.QueryInitializer;
import io.requery.proxy.Settable;
import io.requery.query.AliasedExpression;
import io.requery.query.Condition;
import io.requery.query.Expression;
import io.requery.query.Functional;
import io.requery.query.Result;
import io.requery.query.Tuple;
import io.requery.query.WhereAndOr;
import io.requery.query.element.QueryElement;
import io.requery.query.element.QueryType;
import io.requery.sql.Attributes;
import io.requery.sql.BuildableEntityResultReader;
import io.requery.sql.EntityContext;
import io.requery.sql.EntityResultReader;
import io.requery.sql.Keyword;
import io.requery.sql.Mapping;
import io.requery.sql.MissingKeyException;
import io.requery.sql.QueryBuilder;
import io.requery.sql.ResultReader;
import io.requery.sql.SelectOperation;
import io.requery.util.FilteringIterator;
import io.requery.util.Objects;
import io.requery.util.function.Consumer;
import io.requery.util.function.Predicate;
import io.requery.util.function.Supplier;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;

class EntityReader<E extends S, S>
implements PropertyLoader<E> {
    private final EntityCache cache;
    private final Type<E> type;
    private final Mapping mapping;
    private final EntityContext<S> context;
    private final Queryable<S> queryable;
    private final QueryAttribute<E, ?> keyAttribute;
    private final boolean stateless;
    private final boolean cacheable;
    private final Set<Expression<?>> defaultSelection;
    private final Attribute<E, ?>[] defaultSelectionAttributes;

    EntityReader(Type<E> type2, EntityContext<S> context, Queryable<S> queryable) {
        this.type = Objects.requireNotNull(type2);
        this.context = Objects.requireNotNull(context);
        this.queryable = Objects.requireNotNull(queryable);
        this.cache = this.context.getCache();
        this.mapping = this.context.getMapping();
        this.stateless = type2.isStateless();
        this.cacheable = type2.isCacheable();
        LinkedHashSet<Expression> selection = new LinkedHashSet<Expression>();
        LinkedHashSet selectAttributes = new LinkedHashSet();
        for (Attribute<E, ?> attribute : type2.getAttributes()) {
            boolean isKey;
            boolean bl = isKey = attribute.isForeignKey() || attribute.isKey();
            if (attribute.isLazy() || !isKey && attribute.isAssociation()) continue;
            if (attribute.isVersion()) {
                Expression expression = this.aliasVersion(attribute);
                selection.add(expression);
            } else {
                selection.add((Expression)((Object)attribute));
            }
            selectAttributes.add(attribute);
        }
        this.defaultSelection = Collections.unmodifiableSet(selection);
        this.keyAttribute = Attributes.query(type2.getSingleKeyAttribute());
        this.defaultSelectionAttributes = Attributes.toArray(selectAttributes, new Predicate<Attribute<E, ?>>(){

            @Override
            public boolean test(Attribute<E, ?> value) {
                return true;
            }
        });
    }

    Set<Expression<?>> defaultSelection() {
        return this.defaultSelection;
    }

    Attribute<E, ?>[] defaultSelectionAttributes() {
        return this.defaultSelectionAttributes;
    }

    ResultReader<E> newResultReader(Attribute[] attributes) {
        if (this.type.isBuildable()) {
            return new BuildableEntityResultReader(this, attributes);
        }
        return new EntityResultReader(this, attributes);
    }

    private Expression aliasVersion(Attribute attribute) {
        String columnName = this.context.getPlatform().versionColumnDefinition().columnName();
        if (attribute.isVersion() && columnName != null) {
            Expression expression = (Expression)((Object)attribute);
            return new AliasedExpression(expression, columnName, expression.getName());
        }
        return (Expression)((Object)attribute);
    }

    @Override
    public <V> void load(E entity, EntityProxy<E> proxy, Attribute<E, V> attribute) {
        this.refresh(entity, proxy, attribute);
    }

    public E refresh(E entity, EntityProxy<E> proxy) {
        LinkedHashSet refreshAttributes = new LinkedHashSet();
        for (Attribute<E, ?> attribute : this.type.getAttributes()) {
            if (!this.stateless && proxy.getState(attribute) != PropertyState.LOADED) continue;
            refreshAttributes.add(attribute);
        }
        return this.refresh(entity, proxy, refreshAttributes);
    }

    public E refreshAll(E entity, EntityProxy<E> proxy) {
        return this.refresh(entity, proxy, this.type.getAttributes());
    }

    @SafeVarargs
    public final E refresh(E entity, EntityProxy<E> proxy, Attribute<E, ?> ... attributes) {
        Set<Attribute<E, ?>> elements;
        if (attributes == null || attributes.length == 0) {
            return entity;
        }
        if (attributes.length == 1) {
            elements = Collections.singleton(attributes[0]);
        } else {
            elements = new LinkedHashSet(attributes.length);
            Collections.addAll(elements, attributes);
        }
        return this.refresh(entity, proxy, elements);
    }

    private E refresh(E entity, EntityProxy<E> proxy, final Set<Attribute<E, ?>> attributes) {
        Predicate basicFilter = new Predicate<Attribute<E, ?>>(){

            @Override
            public boolean test(Attribute<E, ?> value) {
                return attributes.contains(value) && (!value.isAssociation() || value.isForeignKey());
            }
        };
        FilteringIterator filterator = new FilteringIterator(attributes.iterator(), basicFilter);
        if (filterator.hasNext()) {
            QueryBuilder qb = new QueryBuilder(this.context.getQueryBuilderOptions()).keyword(Keyword.SELECT).commaSeparated(filterator, new QueryBuilder.Appender<Attribute<E, ?>>(){

                @Override
                public void append(QueryBuilder qb, Attribute<E, ?> value) {
                    String versionColumn = EntityReader.this.context.getPlatform().versionColumnDefinition().columnName();
                    if (value.isVersion() && versionColumn != null) {
                        qb.append(versionColumn).space().append((Object)Keyword.AS).space().append(value.getName()).space();
                    } else {
                        qb.attribute(value);
                    }
                }
            }).keyword(Keyword.FROM).tableName(this.type.getName()).keyword(Keyword.WHERE).appendWhereConditions(this.type.getKeyAttributes());
            String sql = qb.toString();
            try (Connection connection = this.context.getConnection();
                 PreparedStatement statement = connection.prepareStatement(sql);){
                int index = 1;
                for (Attribute<E, ?> attribute : this.type.getKeyAttributes()) {
                    Object value = proxy.getKey(attribute);
                    if (value == null) {
                        throw new MissingKeyException(proxy);
                    }
                    this.mapping.write((Expression)((Object)attribute), statement, index++, value);
                }
                this.context.getStatementListener().beforeExecuteQuery(statement, sql, null);
                ResultSet results = statement.executeQuery();
                this.context.getStatementListener().afterExecuteQuery(statement);
                if (results.next()) {
                    Attribute[] selection = new Attribute[attributes.size()];
                    attributes.toArray(selection);
                    entity = this.type.isImmutable() ? this.fromBuilder(results, selection) : this.fromResult(entity, results, selection);
                }
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
        }
        for (Attribute<E, ?> attribute : attributes) {
            if (!attribute.isAssociation()) continue;
            this.refreshAssociation(proxy, attribute);
        }
        return entity;
    }

    private <V> void refreshAssociation(EntityProxy<E> proxy, Attribute<E, V> attribute) {
        Supplier query = this.associativeQuery(proxy, attribute);
        switch (attribute.getCardinality()) {
            case ONE_TO_ONE: 
            case MANY_TO_ONE: {
                Object value = query == null ? null : query.get().firstOrNull();
                proxy.set(attribute, attribute.getClassType().cast(value), PropertyState.LOADED);
                break;
            }
            case ONE_TO_MANY: 
            case MANY_TO_MANY: {
                Initializer<E, V> initializer = attribute.getInitializer();
                if (!(initializer instanceof QueryInitializer)) break;
                QueryInitializer queryInitializer = (QueryInitializer)((Object)initializer);
                V result2 = queryInitializer.initialize(proxy, attribute, query);
                proxy.set(attribute, result2, PropertyState.LOADED);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private <Q extends S> Supplier<? extends Result<Q>> associativeQuery(EntityProxy<E> proxy, Attribute<E, ?> attribute) {
        switch (attribute.getCardinality()) {
            case ONE_TO_ONE: 
            case MANY_TO_ONE: 
            case ONE_TO_MANY: {
                Object key;
                Class uType;
                QueryAttribute keyAttribute;
                if (attribute.isForeignKey()) {
                    keyAttribute = Attributes.get(attribute.getReferencedAttribute());
                    uType = keyAttribute.getDeclaringType().getClassType();
                    Object entity = uType.cast(proxy.get(attribute, false));
                    if (entity == null) {
                        return null;
                    }
                    EntityProxy referredProxy = this.context.getModel().typeOf(uType).getProxyProvider().apply(entity);
                    key = referredProxy.get(keyAttribute);
                } else {
                    keyAttribute = Attributes.get(attribute.getMappedAttribute());
                    uType = keyAttribute.getDeclaringType().getClassType();
                    QueryAttribute referenced = Attributes.get(keyAttribute.getReferencedAttribute());
                    key = proxy.get(referenced);
                }
                return this.order(this.queryable.select(uType, new QueryAttribute[0]).where((Condition)keyAttribute.equal(key)), attribute.getOrderByAttribute());
            }
            case MANY_TO_MANY: {
                Class<?> uType = attribute.getElementClass();
                QueryAttribute tKey = null;
                QueryAttribute uKey = null;
                Type<?> junctionType = this.context.getModel().typeOf(attribute.getReferencedClass());
                for (Attribute<?, ?> a : junctionType.getAttributes()) {
                    Class<?> referenceType = a.getReferencedClass();
                    if (referenceType == null) continue;
                    if (tKey == null && this.type.getClassType().isAssignableFrom(referenceType)) {
                        tKey = Attributes.query(a);
                        continue;
                    }
                    if (!uType.isAssignableFrom(referenceType)) continue;
                    uKey = Attributes.query(a);
                }
                Objects.requireNotNull(tKey);
                Objects.requireNotNull(uKey);
                QueryAttribute tId = Attributes.get(tKey.getReferencedAttribute());
                QueryAttribute uId = Attributes.get(uKey.getReferencedAttribute());
                Object id = proxy.get(tId);
                if (id == null) {
                    throw new IllegalStateException();
                }
                return this.order(this.queryable.select(uType, new QueryAttribute[0]).join(junctionType.getClassType()).on((Condition)uId.equal(uKey)).join(this.type.getClassType()).on((Condition)tKey.equal(tId)).where((Condition)tId.equal(id)), attribute.getOrderByAttribute());
            }
        }
        throw new IllegalStateException();
    }

    private <Q extends S> Supplier<? extends Result<Q>> order(WhereAndOr<? extends Result<Q>> query, Supplier<Attribute> supplier) {
        if (supplier != null) {
            Attribute attribute = supplier.get();
            if (attribute.getOrderByDirection() != null && attribute instanceof Functional) {
                switch (attribute.getOrderByDirection()) {
                    case ASC: {
                        query.orderBy(((Functional)((Object)attribute)).asc());
                        break;
                    }
                    case DESC: {
                        query.orderBy(((Functional)((Object)attribute)).desc());
                    }
                }
            } else {
                query.orderBy((Expression)((Object)attribute));
            }
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SafeVarargs
    final Iterable<E> batchRefresh(Iterable<E> entities, Attribute<E, ?> ... attributes) {
        Iterable<E> iterable;
        ArrayList<E> collection;
        ArrayList<E> arrayList = collection = this.type.isImmutable() ? new ArrayList<E>() : null;
        if (this.keyAttribute == null) {
            for (E entity : entities) {
                entity = this.refresh(entity, this.type.getProxyProvider().apply(entity), attributes);
                if (collection == null) continue;
                collection.add(entity);
            }
        } else {
            Attribute[] selectAttributes;
            Set<Object> selection = new LinkedHashSet();
            if (attributes == null || attributes.length == 0) {
                selection = this.defaultSelection;
                selectAttributes = this.defaultSelectionAttributes;
            } else {
                LinkedHashSet selectedAttributes = new LinkedHashSet();
                selection.add(this.keyAttribute);
                selectedAttributes.add(this.keyAttribute);
                for (Attribute<E, ?> attribute : attributes) {
                    if (attribute.isVersion()) {
                        selection.add(this.aliasVersion(attribute));
                    } else if (!attribute.isAssociation()) {
                        QueryAttribute queryAttribute = Attributes.query(attribute);
                        selection.add(queryAttribute);
                    }
                    selectedAttributes.add(attribute);
                }
                selectAttributes = selectedAttributes.toArray(new Attribute[selection.size()]);
            }
            HashMap<Object, EntityProxy<E>> map = new HashMap<Object, EntityProxy<E>>();
            for (Object entity : entities) {
                EntityProxy<E> proxy = this.type.getProxyProvider().apply(entity);
                Object key = proxy.key();
                if (key == null) {
                    throw new MissingKeyException();
                }
                map.put(key, proxy);
            }
            Condition condition = (Condition)Attributes.query(this.keyAttribute).in(map.keySet());
            if (this.type.isCacheable()) {
                Consumer collector = new Consumer<E>(){

                    @Override
                    public void accept(E e) {
                        if (collection != null) {
                            collection.add(e);
                        }
                    }
                };
                ResultReader<E> resultReader = this.newResultReader(selectAttributes);
                SelectOperation<E> select = new SelectOperation<E>(this.context, resultReader);
                QueryElement<E> query = new QueryElement<E>(QueryType.SELECT, this.context.getModel(), select);
                try (Result result2 = (Result)((QueryElement)query.select(selection)).where(condition).get();){
                    result2.each(collector);
                }
            }
            try (Result result3 = (Result)this.queryable.select(selection).where(condition).get();){
                for (Tuple tuple : result3) {
                    Object key = tuple.get(this.keyAttribute);
                    EntityProxy proxy = (EntityProxy)map.get(key);
                    Object object = proxy.syncObject();
                    synchronized (object) {
                        for (Expression expression : selection) {
                            void var16_30;
                            Object value = tuple.get(expression);
                            if (expression instanceof AliasedExpression) {
                                AliasedExpression aliased = (AliasedExpression)expression;
                                Expression expression2 = aliased.getInnerExpression();
                            }
                            QueryAttribute attribute = Attributes.query((Attribute)var16_30);
                            proxy.set(attribute, value, PropertyState.LOADED);
                        }
                    }
                }
            }
            if (attributes != null) {
                for (Attribute<E, ?> attribute : attributes) {
                    if (!attribute.isAssociation()) continue;
                    for (EntityProxy proxy : map.values()) {
                        this.refreshAssociation(proxy, attribute);
                    }
                }
            }
        }
        if (collection == null) {
            iterable = entities;
            return iterable;
        }
        iterable = collection;
        return iterable;
    }

    private E createEntity() {
        E entity = this.type.getFactory().get();
        EntityProxy<E> proxy = this.type.getProxyProvider().apply(entity);
        proxy.link(this);
        return entity;
    }

    private Object readCacheKey(ResultSet results) throws SQLException {
        CompositeKey key = null;
        if (this.keyAttribute != null) {
            key = this.readKey(this.keyAttribute, results, results.findColumn(this.keyAttribute.getName()));
        } else {
            int count = this.type.getKeyAttributes().size();
            if (count > 1) {
                LinkedHashMap keys2 = new LinkedHashMap(count);
                for (Attribute<E, ?> attribute : this.type.getKeyAttributes()) {
                    String name = attribute.getName();
                    Object value = this.readKey(attribute, results, results.findColumn(name));
                    keys2.put(attribute, value);
                }
                key = new CompositeKey(keys2);
            }
        }
        return key;
    }

    private Object readKey(Attribute<E, ?> attribute, ResultSet results, int index) throws SQLException {
        Attribute<E, ?> referenced = attribute;
        if (attribute.isAssociation()) {
            referenced = Attributes.get(attribute.getReferencedAttribute());
        }
        return this.mapping.read((Expression)((Object)referenced), results, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final E fromResult(E entity, ResultSet results, Attribute[] selection) throws SQLException {
        boolean overwrite;
        boolean bl = overwrite = entity != null || this.stateless;
        if (entity == null) {
            if (this.cacheable) {
                Type<E> type2 = this.type;
                synchronized (type2) {
                    Object key = this.readCacheKey(results);
                    if (key != null) {
                        entity = this.cache.get(this.type.getClassType(), key);
                    }
                    if (entity == null) {
                        entity = this.createEntity();
                        if (key != null) {
                            this.cache.put(this.type.getClassType(), key, entity);
                        }
                    }
                }
            } else {
                entity = this.createEntity();
            }
        }
        EntityProxy<E> proxy = this.type.getProxyProvider().apply(entity);
        Object object = proxy.syncObject();
        synchronized (object) {
            proxy.link(this);
            int index = 1;
            Attribute[] attributeArray = selection;
            int n = attributeArray.length;
            for (int i = 0; i < n; ++i) {
                Attribute expression;
                Attribute attribute = expression = attributeArray[i];
                boolean isAssociation = attribute.isAssociation();
                if ((attribute.isForeignKey() || attribute.isKey()) && isAssociation) {
                    QueryAttribute referenced = Attributes.get(attribute.getReferencedAttribute());
                    Object key = this.mapping.read(referenced, results, index);
                    if (key != null) {
                        Object value = proxy.get(attribute, false);
                        if (value == null) {
                            Class classType = attribute.getClassType();
                            EntityReader reader = this.context.read(classType);
                            value = super.createEntity();
                        }
                        this.context.proxyOf(value, false).set(Attributes.get(attribute.getReferencedAttribute()), key, PropertyState.LOADED);
                        PropertyState state = PropertyState.LOADED;
                        if (!this.stateless) {
                            state = proxy.getState(attribute);
                            state = state == PropertyState.LOADED ? state : PropertyState.FETCH;
                        }
                        proxy.setObject(attribute, value, state);
                    }
                } else {
                    if (isAssociation) continue;
                    if (overwrite || proxy.getState(attribute) != PropertyState.MODIFIED) {
                        if (attribute.getPrimitiveKind() != null) {
                            this.readPrimitiveField(proxy, attribute, results, index);
                        } else {
                            Object value = this.mapping.read((Expression)((Object)attribute), results, index);
                            proxy.setObject(attribute, value, PropertyState.LOADED);
                        }
                    }
                }
                ++index;
            }
        }
        this.context.getStateListener().postLoad(entity, proxy);
        return entity;
    }

    final <B> E fromBuilder(ResultSet results, Attribute[] selection) throws SQLException {
        EntityBuilderProxy proxy = new EntityBuilderProxy(this.type);
        int index = 1;
        for (Attribute expression : selection) {
            Attribute attribute = expression;
            if (attribute.getPrimitiveKind() != null) {
                this.readPrimitiveField(proxy, attribute, results, index);
            } else {
                Object value = this.mapping.read((Expression)((Object)attribute), results, index);
                proxy.setObject(attribute, value, PropertyState.LOADED);
            }
            ++index;
        }
        return proxy.build();
    }

    private void readPrimitiveField(Settable<E> proxy, Attribute<E, ?> attribute, ResultSet results, int index) throws SQLException {
        switch (attribute.getPrimitiveKind()) {
            case INT: {
                Attribute<E, ?> intAttribute = attribute;
                int intValue = this.mapping.readInt(results, index);
                proxy.setInt(intAttribute, intValue, PropertyState.LOADED);
                break;
            }
            case LONG: {
                Attribute<E, ?> longAttribute = attribute;
                long longValue = this.mapping.readLong(results, index);
                proxy.setLong(longAttribute, longValue, PropertyState.LOADED);
                break;
            }
            case SHORT: {
                Attribute<E, ?> shortAttribute = attribute;
                short shortValue = this.mapping.readShort(results, index);
                proxy.setShort(shortAttribute, shortValue, PropertyState.LOADED);
                break;
            }
            case BYTE: {
                Attribute<E, ?> byteAttribute = attribute;
                byte byteValue = this.mapping.readByte(results, index);
                proxy.setByte(byteAttribute, byteValue, PropertyState.LOADED);
                break;
            }
            case BOOLEAN: {
                Attribute<E, ?> booleanAttribute = attribute;
                boolean booleanValue = this.mapping.readBoolean(results, index);
                proxy.setBoolean(booleanAttribute, booleanValue, PropertyState.LOADED);
                break;
            }
            case FLOAT: {
                Attribute<E, ?> floatAttribute = attribute;
                float floatValue = this.mapping.readFloat(results, index);
                proxy.setFloat(floatAttribute, floatValue, PropertyState.LOADED);
                break;
            }
            case DOUBLE: {
                Attribute<E, ?> doubleAttribute = attribute;
                double doubleValue = this.mapping.readDouble(results, index);
                proxy.setDouble(doubleAttribute, doubleValue, PropertyState.LOADED);
            }
        }
    }
}

