/*
 * Decompiled with CFR 0.152.
 */
package io.requery.sql;

import io.requery.Converter;
import io.requery.PersistenceException;
import io.requery.ReferentialAction;
import io.requery.meta.Attribute;
import io.requery.meta.EntityModel;
import io.requery.meta.Type;
import io.requery.sql.CircularReferenceException;
import io.requery.sql.CompositeStatementListener;
import io.requery.sql.Configuration;
import io.requery.sql.ConfigurationBuilder;
import io.requery.sql.ConnectionProvider;
import io.requery.sql.FieldType;
import io.requery.sql.GeneratedColumnDefinition;
import io.requery.sql.GenericMapping;
import io.requery.sql.Keyword;
import io.requery.sql.LoggingListener;
import io.requery.sql.Mapping;
import io.requery.sql.Platform;
import io.requery.sql.QueryBuilder;
import io.requery.sql.TableCreationMode;
import io.requery.sql.TableModificationException;
import io.requery.sql.platform.PlatformDelegate;
import io.requery.sql.type.IntegerType;
import io.requery.util.Objects;
import io.requery.util.function.Predicate;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public class SchemaModifier
implements ConnectionProvider {
    private final ConnectionProvider connectionProvider;
    private final EntityModel model;
    private final CompositeStatementListener statementListeners;
    private final Configuration configuration;
    private Mapping mapping;
    private Platform platform;
    private QueryBuilder.Options queryOptions;

    public SchemaModifier(DataSource dataSource, EntityModel model) {
        this(new ConfigurationBuilder(dataSource, model).build());
    }

    public SchemaModifier(Configuration configuration) {
        this.configuration = configuration;
        this.connectionProvider = configuration.getConnectionProvider();
        this.platform = configuration.getPlatform();
        this.model = Objects.requireNotNull(configuration.getModel());
        this.mapping = configuration.getMapping();
        this.statementListeners = new CompositeStatementListener(configuration.getStatementListeners());
        if (configuration.getUseDefaultLogging()) {
            this.statementListeners.add(new LoggingListener());
        }
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        Connection connection = this.connectionProvider.getConnection();
        if (this.platform == null) {
            this.platform = new PlatformDelegate(connection);
        }
        if (this.mapping == null) {
            this.mapping = new GenericMapping();
            this.platform.addMappings(this.mapping);
        }
        return connection;
    }

    private QueryBuilder createQueryBuilder() {
        if (this.queryOptions == null) {
            try (Connection connection = this.getConnection();){
                String quoteIdentifier = connection.getMetaData().getIdentifierQuoteString();
                this.queryOptions = new QueryBuilder.Options(quoteIdentifier, true, this.configuration.getTableTransformer(), this.configuration.getColumnTransformer(), this.configuration.getQuoteTableNames(), this.configuration.getQuoteColumnNames());
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
        }
        return new QueryBuilder(this.queryOptions);
    }

    public void createTables(TableCreationMode mode) {
        try (Connection connection = this.getConnection();){
            connection.setAutoCommit(false);
            this.createTables(connection, mode, true);
            connection.commit();
        }
        catch (SQLException e) {
            throw new TableModificationException(e);
        }
    }

    public void createTables(Connection connection, TableCreationMode mode, boolean createIndexes) {
        ArrayList<Type<?>> sorted2 = this.sortTypes();
        try (Statement statement = connection.createStatement();){
            if (mode == TableCreationMode.DROP_CREATE) {
                ArrayList<Type<?>> reversed = this.sortTypes();
                Collections.reverse(reversed);
                this.executeDropStatements(statement, reversed);
            }
            for (Type<?> type2 : sorted2) {
                String sql = this.tableCreateStatement(type2, mode);
                this.statementListeners.beforeExecuteUpdate(statement, sql, null);
                statement.execute(sql);
                this.statementListeners.afterExecuteUpdate(statement, 0);
            }
            if (createIndexes) {
                for (Type<?> type2 : sorted2) {
                    this.createIndexes(connection, mode, type2);
                }
            }
        }
        catch (SQLException e) {
            throw new TableModificationException(e);
        }
    }

    public void createIndexes(Connection connection, TableCreationMode mode) {
        ArrayList<Type<?>> sorted2 = this.sortTypes();
        for (Type<?> type2 : sorted2) {
            this.createIndexes(connection, mode, type2);
        }
    }

    public String createTablesString(TableCreationMode mode) {
        ArrayList<Type<?>> sorted2 = this.sortTypes();
        StringBuilder sb = new StringBuilder();
        for (Type<?> type2 : sorted2) {
            String sql = this.tableCreateStatement(type2, mode);
            sb.append(sql);
            sb.append(";\n");
        }
        return sb.toString();
    }

    public void dropTables() {
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            ArrayList<Type<?>> reversed = this.sortTypes();
            Collections.reverse(reversed);
            this.executeDropStatements(statement, reversed);
        }
        catch (SQLException e) {
            throw new TableModificationException(e);
        }
    }

    public void dropTable(Type<?> type2) {
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            this.executeDropStatements(statement, Collections.singletonList(type2));
        }
        catch (SQLException e) {
            throw new TableModificationException(e);
        }
    }

    private void executeDropStatements(Statement statement, List<Type<?>> types) throws SQLException {
        for (Type<?> type2 : types) {
            QueryBuilder qb = this.createQueryBuilder();
            qb.keyword(Keyword.DROP, Keyword.TABLE);
            if (this.platform.supportsIfExists()) {
                qb.keyword(Keyword.IF, Keyword.EXISTS);
            }
            qb.tableName(type2.getName());
            try {
                String sql = qb.toString();
                this.statementListeners.beforeExecuteUpdate(statement, sql, null);
                statement.execute(sql);
                this.statementListeners.afterExecuteUpdate(statement, 0);
            }
            catch (SQLException e) {
                if (!this.platform.supportsIfExists()) continue;
                throw e;
            }
        }
    }

    public <T> void addColumn(Attribute<T, ?> attribute) {
        try (Connection connection = this.getConnection();){
            this.addColumn(connection, attribute);
        }
        catch (SQLException e) {
            throw new TableModificationException(e);
        }
    }

    public <T> void addColumn(Connection connection, Attribute<T, ?> attribute) {
        this.addColumn(connection, attribute, true);
    }

    public <T> void addColumn(Connection connection, Attribute<T, ?> attribute, boolean inlineUnique) {
        Type<T> type2 = attribute.getDeclaringType();
        QueryBuilder qb = this.createQueryBuilder();
        qb.keyword(Keyword.ALTER, Keyword.TABLE).tableName(type2.getName());
        if (attribute.isForeignKey()) {
            if (this.platform.supportsAddingConstraint()) {
                qb.keyword(Keyword.ADD, Keyword.COLUMN);
                this.createColumn(qb, attribute);
                this.executeSql(connection, qb);
                qb = this.createQueryBuilder();
                qb.keyword(Keyword.ALTER, Keyword.TABLE).tableName(type2.getName()).keyword(Keyword.ADD);
                this.createForeignKeyColumn(qb, attribute, false, false);
            } else {
                qb = this.createQueryBuilder();
                qb.keyword(Keyword.ALTER, Keyword.TABLE).tableName(type2.getName()).keyword(Keyword.ADD);
                this.createForeignKeyColumn(qb, attribute, false, true);
            }
        } else {
            qb.keyword(Keyword.ADD, Keyword.COLUMN);
            this.createColumn(qb, attribute, inlineUnique);
        }
        this.executeSql(connection, qb);
    }

    public <T> void dropColumn(Attribute<T, ?> attribute) {
        Type<T> type2 = attribute.getDeclaringType();
        if (attribute.isForeignKey()) {
            // empty if block
        }
        QueryBuilder qb = this.createQueryBuilder();
        qb.keyword(Keyword.ALTER, Keyword.TABLE).tableName(type2.getName()).keyword(Keyword.DROP, Keyword.COLUMN).attribute(attribute);
        try (Connection connection = this.getConnection();){
            this.executeSql(connection, qb);
        }
        catch (SQLException e) {
            throw new TableModificationException(e);
        }
    }

    private void executeSql(Connection connection, QueryBuilder qb) {
        try (Statement statement = connection.createStatement();){
            String sql = qb.toString();
            this.statementListeners.beforeExecuteUpdate(statement, sql, null);
            statement.execute(sql);
            this.statementListeners.afterExecuteUpdate(statement, 0);
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
    }

    private ArrayList<Type<?>> sortTypes() {
        ArrayDeque queue = new ArrayDeque(this.model.getTypes());
        ArrayList sorted2 = new ArrayList();
        while (!queue.isEmpty()) {
            Type<?> type2 = queue.poll();
            if (type2.isView()) continue;
            Set<Type<?>> referencing = this.referencedTypesOf(type2);
            for (Type<?> referenced : referencing) {
                Set<Type<?>> backReferences = this.referencedTypesOf(referenced);
                if (!backReferences.contains(type2)) continue;
                throw new CircularReferenceException("circular reference detected between " + type2.getName() + " and " + referenced.getName());
            }
            if (referencing.isEmpty() || sorted2.containsAll(referencing)) {
                sorted2.add(type2);
                queue.remove(type2);
                continue;
            }
            queue.offer(type2);
        }
        return sorted2;
    }

    private Set<Type<?>> referencedTypesOf(Type<?> type2) {
        LinkedHashSet referencedTypes = new LinkedHashSet();
        for (Attribute<?, ?> attribute : type2.getAttributes()) {
            Class<?> referenced;
            if (!attribute.isForeignKey() || (referenced = attribute.getReferencedClass() == null ? attribute.getClassType() : attribute.getReferencedClass()) == null) continue;
            for (Type<?> t : this.model.getTypes()) {
                if (type2 == t || !referenced.isAssignableFrom(t.getClassType())) continue;
                referencedTypes.add(t);
            }
        }
        return Collections.unmodifiableSet(referencedTypes);
    }

    public <T> String tableCreateStatement(Type<T> type2, TableCreationMode mode) {
        String tableName = type2.getName();
        QueryBuilder qb = this.createQueryBuilder();
        qb.keyword(Keyword.CREATE);
        if (type2.getTableCreateAttributes() != null) {
            for (String attribute : type2.getTableCreateAttributes()) {
                qb.append(attribute, true);
            }
        }
        qb.keyword(Keyword.TABLE);
        if (mode == TableCreationMode.CREATE_NOT_EXISTS) {
            qb.keyword(Keyword.IF, Keyword.NOT, Keyword.EXISTS);
        }
        qb.tableName(tableName);
        qb.openParenthesis();
        int index = 0;
        Predicate<Attribute> filter = new Predicate<Attribute>(){

            @Override
            public boolean test(Attribute value) {
                if (value.isVersion() && !SchemaModifier.this.platform.versionColumnDefinition().createColumn()) {
                    return false;
                }
                if (SchemaModifier.this.platform.supportsInlineForeignKeyReference()) {
                    return !value.isForeignKey() && !value.isAssociation();
                }
                return value.isForeignKey() || !value.isAssociation();
            }
        };
        Set<Attribute<T, ?>> attributes = type2.getAttributes();
        for (Attribute<T, ?> attribute : attributes) {
            if (!filter.test(attribute)) continue;
            if (index > 0) {
                qb.comma();
            }
            this.createColumn(qb, attribute);
            ++index;
        }
        for (Attribute<T, ?> attribute : attributes) {
            if (!attribute.isForeignKey()) continue;
            if (index > 0) {
                qb.comma();
            }
            this.createForeignKeyColumn(qb, attribute, true, false);
            ++index;
        }
        if (type2.getKeyAttributes().size() > 1) {
            if (index > 0) {
                qb.comma();
            }
            qb.keyword(Keyword.PRIMARY, Keyword.KEY);
            qb.openParenthesis();
            qb.commaSeparated(type2.getKeyAttributes(), new QueryBuilder.Appender<Attribute<T, ?>>(){

                @Override
                public void append(QueryBuilder qb, Attribute<T, ?> value) {
                    qb.attribute(value);
                }
            });
            qb.closeParenthesis();
        }
        qb.closeParenthesis();
        return qb.toString();
    }

    private void createForeignKeyColumn(QueryBuilder qb, Attribute<?, ?> attribute, boolean forCreateStatement, boolean forceInline) {
        Type<?> referenced = this.model.typeOf(attribute.getReferencedClass() != null ? attribute.getReferencedClass() : attribute.getClassType());
        Attribute<Object, Object> referencedAttribute = attribute.getReferencedAttribute() != null ? attribute.getReferencedAttribute().get() : (!referenced.getKeyAttributes().isEmpty() ? referenced.getKeyAttributes().iterator().next() : null);
        if (!(forceInline || this.platform.supportsInlineForeignKeyReference() && forCreateStatement)) {
            qb.keyword(Keyword.FOREIGN, Keyword.KEY).openParenthesis().attribute(attribute).closeParenthesis().space();
        } else {
            qb.attribute(attribute);
            FieldType fieldType = null;
            if (referencedAttribute != null) {
                fieldType = this.mapping.mapAttribute(referencedAttribute);
            }
            if (fieldType == null) {
                fieldType = new IntegerType(Integer.TYPE);
            }
            qb.value(fieldType.getIdentifier());
        }
        qb.keyword(Keyword.REFERENCES);
        qb.tableName(referenced.getName());
        if (referencedAttribute != null) {
            qb.openParenthesis().attribute(referencedAttribute).closeParenthesis().space();
        }
        if (attribute.getDeleteAction() != null) {
            qb.keyword(Keyword.ON, Keyword.DELETE);
            this.appendReferentialAction(qb, attribute.getDeleteAction());
        }
        if (this.platform.supportsOnUpdateCascade() && referencedAttribute != null && !referencedAttribute.isGenerated() && attribute.getUpdateAction() != null) {
            qb.keyword(Keyword.ON, Keyword.UPDATE);
            this.appendReferentialAction(qb, attribute.getUpdateAction());
        }
        if (this.platform.supportsInlineForeignKeyReference()) {
            if (!attribute.isNullable()) {
                qb.keyword(Keyword.NOT, Keyword.NULL);
            }
            if (attribute.isUnique()) {
                qb.keyword(Keyword.UNIQUE);
            }
        }
    }

    private void appendReferentialAction(QueryBuilder qb, ReferentialAction action) {
        switch (action) {
            case CASCADE: {
                qb.keyword(Keyword.CASCADE);
                break;
            }
            case NO_ACTION: {
                qb.keyword(Keyword.NO, Keyword.ACTION);
                break;
            }
            case RESTRICT: {
                qb.keyword(Keyword.RESTRICT);
                break;
            }
            case SET_DEFAULT: {
                qb.keyword(Keyword.SET, Keyword.DEFAULT);
                break;
            }
            case SET_NULL: {
                qb.keyword(Keyword.SET, Keyword.NULL);
            }
        }
    }

    private void createColumn(QueryBuilder qb, Attribute<?, ?> attribute) {
        this.createColumn(qb, attribute, true);
    }

    private void createColumn(QueryBuilder qb, Attribute<?, ?> attribute, boolean inlineUnique) {
        String suffix;
        qb.attribute(attribute);
        FieldType fieldType = this.mapping.mapAttribute(attribute);
        GeneratedColumnDefinition generatedColumnDefinition = this.platform.generatedColumnDefinition();
        if (!attribute.isGenerated() || !generatedColumnDefinition.skipTypeIdentifier()) {
            Object identifier = fieldType.getIdentifier();
            Converter<?, ?> converter = attribute.getConverter();
            if (converter == null && this.mapping instanceof GenericMapping) {
                GenericMapping genericMapping = (GenericMapping)this.mapping;
                converter = genericMapping.converterForType(attribute.getClassType());
            }
            if (attribute.getDefinition() != null && attribute.getDefinition().length() > 0) {
                qb.append(attribute.getDefinition());
            } else if (fieldType.hasLength()) {
                Integer length = attribute.getLength();
                if (length == null && converter != null) {
                    length = converter.getPersistedSize();
                }
                if (length == null) {
                    length = fieldType.getDefaultLength();
                }
                if (length == null) {
                    length = 255;
                }
                qb.append(identifier).openParenthesis().append(length).closeParenthesis();
            } else {
                qb.append(identifier);
            }
            qb.space();
        }
        if ((suffix = fieldType.getIdentifierSuffix()) != null) {
            qb.append(suffix).space();
        }
        if (attribute.isKey() && !attribute.isForeignKey()) {
            if (attribute.isGenerated() && !generatedColumnDefinition.postFixPrimaryKey()) {
                generatedColumnDefinition.appendGeneratedSequence(qb, attribute);
                qb.space();
            }
            if (attribute.getDeclaringType().getKeyAttributes().size() == 1) {
                qb.keyword(Keyword.PRIMARY, Keyword.KEY);
            }
            if (attribute.isGenerated() && generatedColumnDefinition.postFixPrimaryKey()) {
                generatedColumnDefinition.appendGeneratedSequence(qb, attribute);
                qb.space();
            }
        } else if (attribute.isGenerated()) {
            generatedColumnDefinition.appendGeneratedSequence(qb, attribute);
            qb.space();
        }
        if (attribute.getCollate() != null && attribute.getCollate().length() > 0) {
            qb.keyword(Keyword.COLLATE);
            qb.append(attribute.getCollate());
            qb.space();
        }
        if (attribute.getDefaultValue() != null && attribute.getDefaultValue().length() > 0) {
            qb.keyword(Keyword.DEFAULT);
            qb.append(attribute.getDefaultValue());
            qb.space();
        }
        if (!attribute.isNullable()) {
            qb.keyword(Keyword.NOT, Keyword.NULL);
        }
        if (inlineUnique && attribute.isUnique()) {
            qb.keyword(Keyword.UNIQUE);
        }
    }

    public void createIndex(Connection connection, Attribute<?, ?> attribute, TableCreationMode mode) {
        QueryBuilder qb = this.createQueryBuilder();
        String name = this.getIndexDefaultName(attribute);
        this.createIndex(qb, name, Collections.singleton(attribute), attribute.getDeclaringType(), mode);
        this.executeSql(connection, qb);
    }

    private <T> void createIndexes(Connection connection, TableCreationMode mode, Type<T> type2) {
        Set<Attribute<T, ?>> attributes = type2.getAttributes();
        LinkedHashMap indexes = new LinkedHashMap();
        for (Attribute<T, ?> attribute : attributes) {
            if (!attribute.isIndexed()) continue;
            LinkedHashSet<String> names = new LinkedHashSet<String>(attribute.getIndexNames());
            for (String indexName : names) {
                LinkedHashSet indexColumns;
                if (indexName.isEmpty()) {
                    indexName = this.getIndexDefaultName(attribute);
                }
                if ((indexColumns = (LinkedHashSet)indexes.get(indexName)) == null) {
                    indexColumns = new LinkedHashSet();
                    indexes.put(indexName, indexColumns);
                }
                indexColumns.add(attribute);
            }
        }
        for (Map.Entry entry : indexes.entrySet()) {
            QueryBuilder qb = this.createQueryBuilder();
            this.createIndex(qb, (String)entry.getKey(), (Set)entry.getValue(), type2, mode);
            this.executeSql(connection, qb);
        }
    }

    private String getIndexDefaultName(Attribute<?, ?> attribute) {
        return attribute.getDeclaringType().getName() + "_" + attribute.getName() + "_index";
    }

    private void createIndex(QueryBuilder qb, String indexName, Set<? extends Attribute<?, ?>> attributes, Type<?> type2, TableCreationMode mode) {
        qb.keyword(Keyword.CREATE);
        if (attributes.size() >= 1 && attributes.iterator().next().isUnique() || type2.getTableUniqueIndexes() != null && Arrays.asList(type2.getTableUniqueIndexes()).contains(indexName)) {
            qb.keyword(Keyword.UNIQUE);
        }
        qb.keyword(Keyword.INDEX);
        if (mode == TableCreationMode.CREATE_NOT_EXISTS) {
            qb.keyword(Keyword.IF, Keyword.NOT, Keyword.EXISTS);
        }
        qb.append(indexName).space().keyword(Keyword.ON).tableName(type2.getName()).openParenthesis().commaSeparated(attributes, new QueryBuilder.Appender<Attribute>(){

            @Override
            public void append(QueryBuilder qb, Attribute value) {
                qb.attribute(value);
            }
        }).closeParenthesis();
    }
}

